/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ExecutorThreadPool
extends AbstractLifeCycle
implements ThreadPool,
LifeCycle {
    private final ExecutorService _executor;

    public ExecutorThreadPool(ExecutorService executor) {
        this._executor = executor;
    }

    public ExecutorThreadPool() {
        this(new ThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorThreadPool(int queueSize) {
        this(new ThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(queueSize < 0 ? new LinkedBlockingQueue() : (queueSize == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize))))));
    }

    public ExecutorThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
        this(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue));
    }

    @Override
    public boolean dispatch(Runnable job) {
        try {
            this._executor.execute(job);
            return true;
        }
        catch (RejectedExecutionException e) {
            Log.warn(e);
            return false;
        }
    }

    @Override
    public int getIdleThreads() {
        if (this._executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this._executor;
            return tpe.getPoolSize() - tpe.getActiveCount();
        }
        return -1;
    }

    @Override
    public int getThreads() {
        if (this._executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this._executor;
            return tpe.getPoolSize();
        }
        return -1;
    }

    @Override
    public boolean isLowOnThreads() {
        if (this._executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this._executor;
            return tpe.getTaskCount() >= (long)tpe.getMaximumPoolSize();
        }
        return false;
    }

    @Override
    public void join() throws InterruptedException {
        this._executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._executor.shutdownNow();
    }
}

