/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

class SocketConnector
extends AbstractLifeCycle
implements HttpClient.Connector {
    private final HttpClient _httpClient;

    SocketConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    @Override
    public void startConnection(final HttpDestination destination) throws IOException {
        Socket socket = null;
        if (destination.isSecure()) {
            SSLContext sslContext = this._httpClient.getSSLContext();
            socket = sslContext.getSocketFactory().createSocket();
        } else {
            Log.debug("Using Regular Socket");
            socket = SocketFactory.getDefault().createSocket();
        }
        socket.setSoTimeout(this._httpClient.getSoTimeout());
        socket.setTcpNoDelay(true);
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        socket.connect(address.toSocketAddress(), this._httpClient.getConnectTimeout());
        SocketEndPoint endpoint = new SocketEndPoint(socket);
        final HttpConnection connection = new HttpConnection(this._httpClient.getRequestBuffers(), this._httpClient.getResponseBuffers(), endpoint);
        connection.setDestination(destination);
        destination.onNewConnection(connection);
        this._httpClient.getThreadPool().dispatch(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection next;
                    Connection con = connection;
                    while ((next = con.handle()) != con) {
                        con = next;
                    }
                }
                catch (IOException e) {
                    if (e instanceof InterruptedIOException) {
                        Log.ignore(e);
                    }
                    Log.debug(e);
                    destination.onException(e);
                }
            }
        });
    }
}

