/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ajp;

import java.io.IOException;
import org.eclipse.jetty.ajp.Ajp13Connection;
import org.eclipse.jetty.ajp.Ajp13Request;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.util.log.Log;

public class Ajp13SocketConnector
extends SocketConnector {
    static String __secretWord = null;
    static boolean __allowShutdown = false;

    public Ajp13SocketConnector() {
        super.setRequestHeaderSize(8185);
        super.setResponseHeaderSize(8185);
        super.setRequestBufferSize(8185);
        super.setResponseBufferSize(8185);
        super.setMaxIdleTime(0);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Log.info("AJP13 is not a secure protocol. Please protect port {}", Integer.toString(this.getLocalPort()));
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        if (request.isSecure()) {
            request.setScheme("https");
        }
        System.err.println("Customize " + endpoint + " " + request);
    }

    @Override
    protected Connection newConnection(EndPoint endpoint) {
        return new Ajp13Connection(this, endpoint, this.getServer());
    }

    @Override
    public boolean isConfidential(Request request) {
        return ((Ajp13Request)request).isSslSecure();
    }

    @Override
    public boolean isIntegral(Request request) {
        return ((Ajp13Request)request).isSslSecure();
    }

    @Override
    public void setHeaderBufferSize(int headerBufferSize) {
        Log.debug("IGNORED");
    }

    @Override
    public void setRequestBufferSize(int requestBufferSize) {
        Log.debug("IGNORED");
    }

    @Override
    public void setResponseBufferSize(int responseBufferSize) {
        Log.debug("IGNORED");
    }

    public void setAllowShutdown(boolean allowShutdown) {
        Log.warn("AJP13: Shutdown Request is: " + allowShutdown);
        __allowShutdown = allowShutdown;
    }

    public void setSecretWord(String secretWord) {
        Log.warn("AJP13: Shutdown Request secret word is : " + secretWord);
        __secretWord = secretWord;
    }
}

