/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Link;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlusDescriptorProcessor
extends IterativeDescriptorProcessor {
    public PlusDescriptorProcessor() {
        try {
            this.registerVisitor("env-entry", this.getClass().getDeclaredMethod("visitEnvEntry", __signature));
            this.registerVisitor("resource-ref", this.getClass().getDeclaredMethod("visitResourceRef", __signature));
            this.registerVisitor("resource-env-ref", this.getClass().getDeclaredMethod("visitResourceEnvRef", __signature));
            this.registerVisitor("message-destination-ref", this.getClass().getDeclaredMethod("visitMessageDestinationRef", __signature));
            this.registerVisitor("post-construct", this.getClass().getDeclaredMethod("visitPostConstruct", __signature));
            this.registerVisitor("pre-destroy", this.getClass().getDeclaredMethod("visitPreDestroy", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start(WebAppContext context, Descriptor descriptor) {
        RunAsCollection runAsCollection;
        LifeCycleCallbackCollection callbacks;
        InjectionCollection injections = (InjectionCollection)context.getAttribute("org.eclipse.jetty.injectionCollection");
        if (injections == null) {
            injections = new InjectionCollection();
            context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
        }
        if ((callbacks = (LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) == null) {
            callbacks = new LifeCycleCallbackCollection();
            context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", callbacks);
        }
        if ((runAsCollection = (RunAsCollection)context.getAttribute("org.eclipse.jetty.runAsCollection")) == null) {
            runAsCollection = new RunAsCollection();
            context.setAttribute("org.eclipse.jetty.runAsCollection", runAsCollection);
        }
    }

    @Override
    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void visitEnvEntry(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String name = node.getString("env-entry-name", false, true);
        String type = node.getString("env-entry-type", false, true);
        String valueStr = node.getString("env-entry-value", false, true);
        if (valueStr == null || valueStr.equals("")) {
            Log.warn("No value for env-entry-name " + name);
            return;
        }
        Origin o = context.getMetaData().getOrigin("env-entry." + name);
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("env-entry." + name, descriptor);
                this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
                Object value = TypeUtil.valueOf(type, valueStr);
                this.bindEnvEntry(name, value);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    context.getMetaData().setOrigin("env-entry." + name, descriptor);
                    this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
                    Object value = TypeUtil.valueOf(type, valueStr);
                    this.bindEnvEntry(name, value);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("env-entry." + name + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting env-entry " + name + " in " + descriptor.getResource());
            }
        }
    }

    public void visitResourceRef(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("res-ref-name", false, true);
        String type = node.getString("res-type", false, true);
        String auth = node.getString("res-auth", false, true);
        String shared = node.getString("res-sharing-scope", false, true);
        Origin o = context.getMetaData().getOrigin("resource-ref." + jndiName);
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("resource-ref." + jndiName, descriptor);
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                this.bindResourceRef(context, jndiName, typeClass);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    context.getMetaData().setOrigin("resource-ref." + jndiName, descriptor);
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = context.loadClass(type);
                    }
                    this.addInjections(context, descriptor, node, jndiName, typeClass);
                    this.bindResourceRef(context, jndiName, typeClass);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("resource-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                break;
            }
            case WebFragment: {
                Descriptor otherFragment = context.getMetaData().getOriginDescriptor("resource-ref." + jndiName);
                XmlParser.Node otherFragmentRoot = otherFragment.getRoot();
                Iterator iter = otherFragmentRoot.iterator();
                XmlParser.Node otherNode = null;
                while (iter.hasNext() && otherNode == null) {
                    XmlParser.Node n;
                    Object obj = iter.next();
                    if (!(obj instanceof XmlParser.Node) || !"resource-ref".equals((n = (XmlParser.Node)obj).getTag()) || !jndiName.equals(n.getString("res-ref-name", false, true))) continue;
                    otherNode = n;
                }
                if (otherNode != null) {
                    String otherType = otherNode.getString("res-type", false, true);
                    String otherAuth = otherNode.getString("res-auth", false, true);
                    String otherShared = otherNode.getString("res-sharing-scope", false, true);
                    type = type == null ? "" : type;
                    otherType = otherType == null ? "" : otherType;
                    auth = auth == null ? "" : auth;
                    otherAuth = otherAuth == null ? "" : otherAuth;
                    shared = shared == null ? "" : shared;
                    String string = otherShared = otherShared == null ? "" : otherShared;
                    if (!(type.equals(otherType) && auth.equals(otherAuth) && shared.equals(otherShared))) {
                        throw new IllegalStateException("Conflicting resource-ref " + jndiName + " in " + descriptor.getResource());
                    }
                    this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                    break;
                }
                throw new IllegalStateException("resource-ref." + jndiName + " not found in declaring descriptor " + otherFragment);
            }
        }
    }

    public void visitResourceEnvRef(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("resource-env-ref-name", false, true);
        String type = node.getString("resource-env-ref-type", false, true);
        Origin o = context.getMetaData().getOrigin("resource-env-ref." + jndiName);
        switch (o) {
            case NotSet: {
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                this.bindResourceEnvRef(context, jndiName, typeClass);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    context.getMetaData().setOrigin("resource-env-ref." + jndiName, descriptor);
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = context.loadClass(type);
                    }
                    this.addInjections(context, descriptor, node, jndiName, typeClass);
                    this.bindResourceEnvRef(context, jndiName, typeClass);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("resource-env-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                break;
            }
            case WebFragment: {
                Descriptor otherFragment = context.getMetaData().getOriginDescriptor("resource-env-ref." + jndiName);
                XmlParser.Node otherFragmentRoot = otherFragment.getRoot();
                Iterator iter = otherFragmentRoot.iterator();
                XmlParser.Node otherNode = null;
                while (iter.hasNext() && otherNode == null) {
                    XmlParser.Node n;
                    Object obj = iter.next();
                    if (!(obj instanceof XmlParser.Node) || !"resource-env-ref".equals((n = (XmlParser.Node)obj).getTag()) || !jndiName.equals(n.getString("resource-env-ref-name", false, true))) continue;
                    otherNode = n;
                }
                if (otherNode != null) {
                    String otherType = otherNode.getString("resource-env-ref-type", false, true);
                    type = type == null ? "" : type;
                    String string = otherType = otherType == null ? "" : otherType;
                    if (!type.equals(otherType)) {
                        throw new IllegalStateException("Conflicting resource-env-ref " + jndiName + " in " + descriptor.getResource());
                    }
                    this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                    break;
                }
                throw new IllegalStateException("resource-env-ref." + jndiName + " not found in declaring descriptor " + otherFragment);
            }
        }
    }

    public void visitMessageDestinationRef(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("message-destination-ref-name", false, true);
        String type = node.getString("message-destination-type", false, true);
        String usage = node.getString("message-destination-usage", false, true);
        Origin o = context.getMetaData().getOrigin("message-destination-ref." + jndiName);
        switch (o) {
            case NotSet: {
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                this.bindMessageDestinationRef(context, jndiName, typeClass);
                context.getMetaData().setOrigin("message-destination-ref." + jndiName, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = context.loadClass(type);
                    }
                    this.addInjections(context, descriptor, node, jndiName, typeClass);
                    this.bindMessageDestinationRef(context, jndiName, typeClass);
                    context.getMetaData().setOrigin("message-destination-ref." + jndiName, descriptor);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("message-destination-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                break;
            }
            case WebFragment: {
                Descriptor otherFragment = context.getMetaData().getOriginDescriptor("message-destination-ref." + jndiName);
                XmlParser.Node otherFragmentRoot = otherFragment.getRoot();
                Iterator iter = otherFragmentRoot.iterator();
                XmlParser.Node otherNode = null;
                while (iter.hasNext() && otherNode == null) {
                    XmlParser.Node n;
                    Object obj = iter.next();
                    if (!(obj instanceof XmlParser.Node) || !"message-destination-ref".equals((n = (XmlParser.Node)obj).getTag()) || !jndiName.equals(n.getString("message-destination-ref-name", false, true))) continue;
                    otherNode = n;
                }
                if (otherNode != null) {
                    String otherType = node.getString("message-destination-type", false, true);
                    String otherUsage = node.getString("message-destination-usage", false, true);
                    type = type == null ? "" : type;
                    String string = usage = usage == null ? "" : usage;
                    if (!type.equals(otherType) || !usage.equalsIgnoreCase(otherUsage)) {
                        throw new IllegalStateException("Conflicting message-destination-ref " + jndiName + " in " + descriptor.getResource());
                    }
                    this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                    break;
                }
                throw new IllegalStateException("message-destination-ref." + jndiName + " not found in declaring descriptor " + otherFragment);
            }
        }
    }

    public void visitPostConstruct(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.equals("")) {
            Log.warn("No lifecycle-callback-class specified");
            return;
        }
        if (methodName == null || methodName.equals("")) {
            Log.warn("No lifecycle-callback-method specified for class " + className);
            return;
        }
        Origin o = context.getMetaData().getOrigin("post-construct");
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("post-construct", descriptor);
                try {
                    Class<?> clazz = context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback();
                    callback.setTarget(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load post-construct target class " + className);
                }
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                try {
                    Class<?> clazz = context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback();
                    callback.setTarget(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load post-construct target class " + className);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class<?> clazz = context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback();
                    callback.setTarget(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                    break;
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load post-construct target class " + className);
                }
            }
        }
    }

    public void visitPreDestroy(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.equals("")) {
            Log.warn("No lifecycle-callback-class specified for pre-destroy");
            return;
        }
        if (methodName == null || methodName.equals("")) {
            Log.warn("No lifecycle-callback-method specified for pre-destroy class " + className);
            return;
        }
        Origin o = context.getMetaData().getOrigin("pre-destroy");
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("pre-destroy", descriptor);
                try {
                    Class<?> clazz = context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback();
                    callback.setTarget(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load pre-destory target class " + className);
                }
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                try {
                    Class<?> clazz = context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback();
                    callback.setTarget(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load pre-destory target class " + className);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class<?> clazz = context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback();
                    callback.setTarget(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                    break;
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load pre-destory target class " + className);
                }
            }
        }
    }

    public void addInjections(WebAppContext context, Descriptor descriptor, XmlParser.Node node, String jndiName, Class<?> valueClass) {
        Iterator<XmlParser.Node> itor = node.iterator("injection-target");
        while (itor.hasNext()) {
            XmlParser.Node injectionNode = itor.next();
            String targetClassName = injectionNode.getString("injection-target-class", false, true);
            String targetName = injectionNode.getString("injection-target-name", false, true);
            if (targetClassName == null || targetClassName.equals("")) {
                Log.warn("No classname found in injection-target");
                continue;
            }
            if (targetName == null || targetName.equals("")) {
                Log.warn("No field or method name in injection-target");
                continue;
            }
            InjectionCollection injections = (InjectionCollection)context.getAttribute("org.eclipse.jetty.injectionCollection");
            if (injections == null) {
                injections = new InjectionCollection();
                context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
            }
            try {
                Class<?> clazz = context.loadClass(targetClassName);
                Injection injection = new Injection();
                injection.setJndiName(jndiName);
                injection.setTarget(clazz, targetName, valueClass);
                injections.add(injection);
                if (context.getMetaData().getOriginDescriptor(node.getTag() + "." + jndiName + ".injection") != null) continue;
                context.getMetaData().setOrigin(node.getTag() + "." + jndiName + ".injection", descriptor);
            }
            catch (ClassNotFoundException e) {
                Log.warn("Couldn't load injection target class " + targetClassName);
            }
        }
    }

    public void bindEnvEntry(String name, Object value) throws Exception {
        InitialContext ic = null;
        boolean bound = false;
        ic = new InitialContext();
        try {
            NamingEntry ne = (NamingEntry)ic.lookup("java:comp/env/" + NamingEntryUtil.makeNamingEntryName(ic.getNameParser(""), name));
            if (ne != null && ne instanceof EnvEntry) {
                EnvEntry ee = (EnvEntry)ne;
                bound = ee.isOverrideWebXml();
            }
        }
        catch (NameNotFoundException e) {
            bound = false;
        }
        if (!bound) {
            Context envCtx = (Context)ic.lookup("java:comp/env");
            NamingUtil.bind(envCtx, name, value);
        }
    }

    public void bindResourceRef(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindResourceEnvRef(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindMessageDestinationRef(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    protected void bindEntry(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        String nameInEnvironment = name;
        boolean bound = false;
        HandlerWrapper scope = context;
        NamingEntry ne = NamingEntryUtil.lookupNamingEntry(scope, name);
        if (ne != null && ne instanceof Link) {
            nameInEnvironment = ((Link)ne).getLink();
        }
        if (bound = NamingEntryUtil.bindToENC(scope = context, name, nameInEnvironment)) {
            return;
        }
        scope = context.getServer();
        bound = NamingEntryUtil.bindToENC(scope, name, nameInEnvironment);
        if (bound) {
            return;
        }
        bound = NamingEntryUtil.bindToENC(null, name, nameInEnvironment);
        if (bound) {
            return;
        }
        nameInEnvironment = typeClass.getName() + "/default";
        NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(context.getServer(), nameInEnvironment);
        if (defaultNE == null) {
            defaultNE = NamingEntryUtil.lookupNamingEntry(null, nameInEnvironment);
        }
        if (defaultNE == null) {
            throw new IllegalStateException("Nothing to bind for name " + nameInEnvironment);
        }
        defaultNE.bindToENC(name);
    }
}

