/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAccessHandler
extends HandlerWrapper {
    Map<String, PathMap> _whiteAddr = new HashMap<String, PathMap>();
    List<String> _whitePattern = new CopyOnWriteArrayList<String>();
    Map<String, PathMap> _blackAddr = new HashMap<String, PathMap>();
    List<String> _blackPattern = new CopyOnWriteArrayList<String>();

    public void addBlack(String addrPath) {
        this.add(addrPath, this._blackAddr, this._blackPattern);
    }

    public void addWhite(String addrPath) {
        this.add(addrPath, this._whiteAddr, this._whitePattern);
    }

    public void setBlack(String[] addrPaths) {
        this.set(addrPaths, this._blackAddr, this._blackPattern);
    }

    public void setWhite(String[] addrPaths) {
        this.set(addrPaths, this._whiteAddr, this._whitePattern);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String addr;
        EndPoint endp;
        HttpConnection connection = baseRequest.getConnection();
        if (connection != null && (endp = connection.getEndPoint()) != null && (addr = endp.getRemoteAddr()) != null && !this.isAddrUriAllowed(addr, baseRequest.getPathInfo())) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request, response);
    }

    protected void add(String addrPath, Map<String, PathMap> addrMap, List<String> patternList) {
        PathMap map;
        String path;
        int idx = addrPath.indexOf(47);
        String addr = idx > 0 ? addrPath.substring(0, idx) : addrPath;
        String string = path = idx > 0 ? addrPath.substring(idx) : null;
        if (path != null && path.length() > 1 && path.charAt(1) == '*') {
            path = path.substring(1);
        }
        if ((map = addrMap.get(addr)) == null) {
            map = new PathMap(true);
            addrMap.put(addr, map);
            if (addr.endsWith(".")) {
                patternList.add(addr);
            }
        }
        if (path != null) {
            map.put(path, path);
        }
    }

    protected void set(String[] addrPaths, Map<String, PathMap> addrMap, List<String> patternList) {
        addrMap.clear();
        patternList.clear();
        for (String addrPath : addrPaths) {
            this.add(addrPath, addrMap, patternList);
        }
    }

    protected boolean isAddrUriAllowed(String addr, String path) {
        PathMap black;
        PathMap white;
        if (this._whiteAddr.size() > 0 && ((white = this._whiteAddr.get(addr)) == null || white.size() > 0 && white.match(path) == null)) {
            boolean match = false;
            for (String pattern : this._whitePattern) {
                if (!addr.startsWith(pattern) || (white = this._whiteAddr.get(pattern)) == null || white.size() <= 0 || white.match(path) == null) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if ((black = this._blackAddr.get(addr)) != null && (black.size() == 0 || black.match(path) != null)) {
            return false;
        }
        for (String pattern : this._blackPattern) {
            if (!addr.startsWith(pattern)) continue;
            black = this._blackAddr.get(pattern);
            if (black == null || black.match(path) == null) break;
            return false;
        }
        return true;
    }
}

