/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Server;

public class LocalConnector
extends AbstractConnector {
    ByteArrayEndPoint _endp;
    ByteArrayBuffer _in;
    ByteArrayBuffer _out;
    Server _server;
    boolean _accepting;
    boolean _keepOpen;

    public LocalConnector() {
        this.setPort(1);
    }

    public Object getConnection() {
        return this._endp;
    }

    public void setServer(Server server) {
        super.setServer(server);
        this._server = server;
    }

    public void clear() {
        this._in.clear();
        this._out.clear();
    }

    public void reopen() {
        this._in.clear();
        this._out.clear();
        this._endp = new ByteArrayEndPoint();
        this._endp.setIn(this._in);
        this._endp.setOut(this._out);
        this._endp.setGrowOutput(true);
        this._accepting = false;
    }

    public void doStart() throws Exception {
        this._in = new ByteArrayBuffer(8192);
        this._out = new ByteArrayBuffer(8192);
        this._endp = new ByteArrayEndPoint();
        this._endp.setIn(this._in);
        this._endp.setOut(this._out);
        this._endp.setGrowOutput(true);
        this._accepting = false;
        super.doStart();
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponses(String requests, boolean keepOpen) throws Exception {
        ByteArrayBuffer buf = new ByteArrayBuffer(requests, "ISO-8859-1");
        if (this._in.space() < buf.length()) {
            ByteArrayBuffer n = new ByteArrayBuffer(this._in.length() + buf.length());
            n.put(this._in);
            this._in = n;
            this._endp.setIn(this._in);
        }
        this._in.put(buf);
        LocalConnector localConnector = this;
        synchronized (localConnector) {
            this._keepOpen = keepOpen;
            this._accepting = true;
            this.notify();
            while (this._accepting) {
                this.wait();
            }
        }
        this._out = this._endp.getOut();
        return this._out.toString("ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayBuffer getResponses(ByteArrayBuffer buf, boolean keepOpen) throws Exception {
        if (this._in.space() < buf.length()) {
            ByteArrayBuffer n = new ByteArrayBuffer(this._in.length() + buf.length());
            n.put(this._in);
            this._in = n;
            this._endp.setIn(this._in);
        }
        this._in.put(buf);
        LocalConnector localConnector = this;
        synchronized (localConnector) {
            this._keepOpen = keepOpen;
            this._accepting = true;
            this.notify();
            while (this._accepting) {
                this.wait();
            }
        }
        this._out = this._endp.getOut();
        return this._out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        HttpConnection connection = null;
        while (this.isRunning()) {
            LocalConnector localConnector;
            block17: {
                Object var7_4;
                LocalConnector localConnector2 = this;
                synchronized (localConnector2) {
                    try {
                        while (!this._accepting) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    if (connection == null) {
                        connection = new HttpConnection(this, this._endp, this.getServer());
                        this.connectionOpened(connection);
                    }
                    while (this._in.length() > 0) {
                        connection.handle();
                    }
                    var7_4 = null;
                    if (this._keepOpen) break block17;
                }
                catch (Throwable throwable) {
                    var7_4 = null;
                    if (!this._keepOpen) {
                        this.connectionClosed(connection);
                        connection = null;
                    }
                    localConnector = this;
                    synchronized (localConnector) {
                        this._accepting = false;
                        this.notify();
                    }
                    throw throwable;
                }
                this.connectionClosed(connection);
                connection = null;
            }
            localConnector = this;
            synchronized (localConnector) {
                this._accepting = false;
                this.notify();
            }
        }
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }
}

