/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.ssl.ServletSSL;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class SslSocketConnector
extends SocketConnector
implements SslConnector {
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private String[] _excludeCipherSuites = null;
    private String _keystorePath = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String _sslTrustManagerFactoryAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    private String _truststorePath;
    private String _truststoreType = "JKS";
    private boolean _wantClientAuth = false;
    private int _handshakeTimeout = 0;
    private SSLContext _context;

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            return null;
        }
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        SslConnection connection = new SslConnection(socket);
        connection.dispatch();
    }

    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
    }

    protected SSLContext createSSLContext() throws Exception {
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context;
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        if (this._context == null) {
            this._context = this.createSSLContext();
        }
        return this._context.getServerSocketFactory();
    }

    protected KeyManager[] getKeyManagers() throws Exception {
        KeyStore keyStore = this.getKeyStore(this._keystorePath, this._keystoreType, this._password == null ? null : this._password.toString());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, this._keyPassword == null ? (this._password == null ? null : this._password.toString().toCharArray()) : this._keyPassword.toString().toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    protected TrustManager[] getTrustManagers() throws Exception {
        if (this._truststorePath == null) {
            this._truststorePath = this._keystorePath;
            this._truststoreType = this._keystoreType;
            this._trustPassword = this._password;
            this._sslTrustManagerFactoryAlgorithm = this._sslKeyManagerFactoryAlgorithm;
        }
        KeyStore trustStore = this.getKeyStore(this._truststorePath, this._truststoreType, this._trustPassword == null ? null : this._trustPassword.toString());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore getKeyStore(String keystorePath, String keystoreType, String keystorePassword) throws Exception {
        KeyStore keyStore;
        block5: {
            InputStream keystoreInputStream;
            block3: {
                KeyStore keyStore2;
                block4: {
                    keystoreInputStream = null;
                    try {
                        if (keystorePath == null) break block3;
                        keystoreInputStream = Resource.newResource(keystorePath).getInputStream();
                        KeyStore keystore = KeyStore.getInstance(keystoreType);
                        keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toString().toCharArray());
                        keyStore2 = keystore;
                        Object var8_8 = null;
                        if (keystoreInputStream == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var8_10 = null;
                            if (keystoreInputStream == null) break block6;
                            keystoreInputStream.close();
                        }
                        throw throwable;
                    }
                    keystoreInputStream.close();
                }
                return keyStore2;
            }
            keyStore = null;
            Object var8_9 = null;
            if (keystoreInputStream == null) break block5;
            keystoreInputStream.close();
        }
        return keyStore;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SocketEndPoint socket_end_point = (SocketEndPoint)endpoint;
        SSLSocket sslSocket = (SSLSocket)socket_end_point.getTransport();
        try {
            String idStr;
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
                idStr = cachedInfo.getIdStr();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength(cipherSuite));
                certs = SslSocketConnector.getCertChain(sslSession);
                byte[] idBytes = sslSession.getId();
                idStr = TypeUtil.toHexString(idBytes);
                cachedInfo = new CachedInfo(keySize, certs, idStr);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            } else if (this._needClientAuth) {
                throw new IllegalStateException("no client auth");
            }
            request.setAttribute("javax.servlet.request.ssl_session_id", idStr);
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
        }
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites;
    }

    public String getKeystore() {
        return this._keystorePath;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststorePath;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = (SSLServerSocket)(host == null ? factory.createServerSocket(port, backlog) : factory.createServerSocket(port, backlog, InetAddress.getByName(host)));
            if (this._wantClientAuth) {
                socket.setWantClientAuth(this._wantClientAuth);
            }
            if (this._needClientAuth) {
                socket.setNeedClientAuth(this._needClientAuth);
            }
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0) {
                List<String> excludedCSList = Arrays.asList(this._excludeCipherSuites);
                String[] enabledCipherSuites = socket.getEnabledCipherSuites();
                ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                for (String cipherName : excludedCSList) {
                    if (!enabledCSList.contains(cipherName)) continue;
                    enabledCSList.remove(cipherName);
                }
                enabledCipherSuites = enabledCSList.toArray(new String[enabledCSList.size()]);
                socket.setEnabledCipherSuites(enabledCipherSuites);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            throw new IOException("Could not create JsseListener: " + e.toString());
        }
        return socket;
    }

    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._excludeCipherSuites = cipherSuites;
    }

    public void setKeyPassword(String password) {
        this._keyPassword = Password.getPassword("org.eclipse.jetty.ssl.keypassword", password, null);
    }

    public void setKeystore(String keystore) {
        this._keystorePath = keystore;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword("org.eclipse.jetty.ssl.password", password, null);
    }

    public void setTrustPassword(String password) {
        this._trustPassword = Password.getPassword("org.eclipse.jetty.ssl.password", password, null);
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setProvider(String _provider) {
        this._provider = _provider;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this._secureRandomAlgorithm = algorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslKeyManagerFactoryAlgorithm = algorithm;
    }

    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslTrustManagerFactoryAlgorithm = algorithm;
    }

    public void setTruststore(String truststore) {
        this._truststorePath = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public void setSslContext(SSLContext sslContext) {
        this._context = sslContext;
    }

    public SSLContext getSslContext() {
        try {
            if (this._context == null) {
                this._context = this.createSSLContext();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._context;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public void setHandshakeTimeout(int msec) {
        this._handshakeTimeout = msec;
    }

    public int getHandshakeTimeout() {
        return this._handshakeTimeout;
    }

    public String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    public void setAlgorithm(String algorithm) {
        throw new UnsupportedOperationException();
    }

    public class SslConnection
    extends SocketConnector.Connection {
        public SslConnection(Socket socket) throws IOException {
            super(socket);
        }

        public void run() {
            try {
                int handshakeTimeout = SslSocketConnector.this.getHandshakeTimeout();
                int oldTimeout = this._socket.getSoTimeout();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(handshakeTimeout);
                }
                ((SSLSocket)this._socket).startHandshake();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(oldTimeout);
                }
                super.run();
            }
            catch (SSLException e) {
                Log.debug(e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (IOException e) {
                Log.debug(e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
        }
    }

    private class CachedInfo {
        private final java.security.cert.X509Certificate[] _certs;
        private final Integer _keySize;
        private final String _idStr;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs, String id) {
            this._keySize = keySize;
            this._certs = certs;
            this._idStr = id;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        String getIdStr() {
            return this._idStr;
        }
    }
}

