/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreDestroyAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    WebAppContext _wac;

    public PreDestroyAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@PreDestroy annotation not applicable for classes: " + className);
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@PreDestroy annotation not applicable for fields: " + className + "." + fieldName);
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._wac.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        Class clazz = null;
        try {
            clazz = Loader.loadClass(null, className);
            Method m = clazz.getDeclaredMethod(methodName, Util.convertTypes(params));
            if (!Util.isServletType(m.getDeclaringClass())) {
                Log.debug("Ignored " + m.getName() + " as non-servlet type");
                return;
            }
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PreDestroyCallback callback = new PreDestroyCallback();
            callback.setTargetClass(m.getDeclaringClass());
            callback.setTarget(m);
            callbacks.add(callback);
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }
}

