/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DelegateAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;

public class DeferredAuthenticator
extends DelegateAuthenticator {
    private static HttpServletResponse __nullResponse = new HttpServletResponse(){

        public void addCookie(Cookie cookie) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void addHeader(String name, String value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 1024;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return __nullOut;
        }

        public PrintWriter getWriter() throws IOException {
            return IO.getNullPrintWriter();
        }

        public boolean isCommitted() {
            return true;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        public void setLocale(Locale loc) {
        }
    };
    private static ServletOutputStream __nullOut = new ServletOutputStream(){

        public void write(int b) throws IOException {
        }

        public void print(String s) throws IOException {
        }

        public void println(String s) throws IOException {
        }
    };

    public DeferredAuthenticator(Authenticator delegate) {
        super(delegate);
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (!mandatory) {
            return new DeferredAuthentication(this._delegate, request, response);
        }
        return this._delegate.validateRequest(request, response, mandatory);
    }

    public static class DeferredAuthentication
    implements Authentication.Deferred {
        protected final Authenticator _authenticator;
        protected final ServletRequest _request;
        protected final ServletResponse _response;
        private Authentication _delegate;
        private IdentityService _identityService;

        public DeferredAuthentication(Authenticator authenticator, ServletRequest request, ServletResponse response) {
            if (authenticator == null) {
                throw new NullPointerException("No Authenticator");
            }
            this._authenticator = authenticator;
            this._request = request;
            this._response = response;
        }

        public IdentityService getIdentityService() {
            return this._identityService;
        }

        public void setIdentityService(IdentityService identityService) {
            this._identityService = identityService;
        }

        public Authentication authenticate() {
            try {
                Authentication authentication = this._authenticator.validateRequest(this._request, (ServletResponse)__nullResponse, false);
                if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                    if (this._identityService != null) {
                        this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
                    }
                    return authentication;
                }
            }
            catch (ServerAuthException e) {
                Log.debug(e);
            }
            return Authentication.UNAUTHENTICATED;
        }

        public Authentication authenticate(ServletRequest request, ServletResponse response) {
            try {
                Authentication authentication = this._authenticator.validateRequest(this._request, response, true);
                if (authentication instanceof Authentication.User && this._identityService != null) {
                    this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
            catch (ServerAuthException e) {
                Log.debug(e);
                return Authentication.UNAUTHENTICATED;
            }
        }

        public Authentication login(String username, String password) {
            return null;
        }
    }
}

