/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.http.EncodedHttpURI;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpMethods;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpConnection
implements Connection {
    private static final int UNKNOWN = -2;
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final long _timeStamp = System.currentTimeMillis();
    private int _requests;
    private volatile boolean _handling;
    protected final Connector _connector;
    protected final EndPoint _endp;
    protected final Server _server;
    protected final HttpURI _uri;
    protected final Parser _parser;
    protected final HttpFields _requestFields;
    protected final Request _request;
    protected ServletInputStream _in;
    protected final Generator _generator;
    protected final HttpFields _responseFields;
    protected final Response _response;
    protected Output _out;
    protected OutputWriter _writer;
    protected PrintWriter _printWriter;
    int _include;
    private Object _associatedObject;
    private int _version = -2;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private boolean _head = false;
    private boolean _host = false;
    private boolean _delayedHandling = false;

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        __currentConnection.set(connection);
    }

    public HttpConnection(Connector connector, EndPoint endpoint, Server server) {
        this._uri = "UTF-8".equals(URIUtil.__CHARSET) ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endpoint;
        HttpBuffers ab = (HttpBuffers)((Object)this._connector);
        this._parser = new HttpParser(ab.getRequestBuffers(), endpoint, new RequestHandler());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(ab.getResponseBuffers(), this._endp);
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    protected HttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        this._uri = URIUtil.__CHARSET.equals("UTF-8") ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endpoint;
        this._parser = parser;
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = request;
        this._response = new Response(this);
        this._generator = generator;
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    public Parser getParser() {
        return this._parser;
    }

    public int getRequests() {
        return this._requests;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this._connector != null) {
            return this._connector.isIntegral(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean getResolveNames() {
        return this._connector.getResolveNames();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._expect100Continue) {
            if (((HttpParser)this._parser).getHeaderBuffer() == null || ((HttpParser)this._parser).getHeaderBuffer().length() < 2) {
                this._generator.setResponse(100, null);
                this._generator.completeHeader(null, true);
                this._generator.complete();
                this._generator.reset(false);
            }
            this._expect100Continue = false;
        }
        if (this._in == null) {
            this._in = new HttpInput((HttpParser)this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String encoding) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = new PrintWriter(this._writer){

                public void close() {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        Log.debug(e);
                        this.setError();
                    }
                }
            };
        }
        this._writer.setCharacterEncoding(encoding);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle() throws IOException {
        block36: {
            block35: {
                more_in_buffer = true;
                progress = true;
                try {
                    if (!HttpConnection.$assertionsDisabled && HttpConnection.getCurrentConnection() != null) {
                        throw new AssertionError();
                    }
                    if (!HttpConnection.$assertionsDisabled && this._handling) {
                        throw new AssertionError();
                    }
                    this._handling = true;
                    HttpConnection.setCurrentConnection(this);
                    while (more_in_buffer) {
                        block34: {
                            try {
                                if (this._request._async.isAsync()) {
                                    Log.debug("resume request", this._request);
                                    if (!this._request._async.isComplete()) {
                                        this.handleRequest();
                                    } else if (!this._parser.isComplete()) {
                                        progress |= this._parser.parseAvailable() > 0L;
                                    }
                                    if (this._generator.isCommitted() && !this._generator.isComplete()) {
                                        this._generator.flushBuffer();
                                    }
                                    if (this._endp.isBufferingOutput()) {
                                        this._endp.flush();
                                    }
                                    break block34;
                                }
                                if (!this._parser.isComplete()) {
                                    progress |= this._parser.parseAvailable() > 0L;
                                }
                                while (this._generator.isCommitted() && !this._generator.isComplete() && (written = this._generator.flushBuffer()) > 0L) {
                                    progress = true;
                                    if (!this._endp.isBufferingOutput()) continue;
                                    this._endp.flush();
                                }
                                if (this._endp.isBufferingOutput()) {
                                    this._endp.flush();
                                    if (!this._endp.isBufferingOutput()) {
                                        progress = true;
                                    }
                                }
                                if (!progress) {
                                    var6_5 = null;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (HttpException e) {
                                if (Log.isDebugEnabled()) {
                                    Log.debug("uri=" + this._uri);
                                    Log.debug("fields=" + this._requestFields);
                                    Log.debug(e);
                                }
                                this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                                this._parser.reset(true);
                                this._endp.close();
                                throw e;
                            }
                            catch (Throwable var5_9) {
                                var6_5 = null;
                                v0 = more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                                if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                    if (!this._generator.isPersistent()) {
                                        this._parser.reset(true);
                                        more_in_buffer = false;
                                    }
                                    this.reset(more_in_buffer == false);
                                    progress = true;
                                }
                                if (this._request.isAsyncStarted()) {
                                    Log.debug("return with suspended request");
                                    more_in_buffer = false;
                                    throw var5_9;
                                }
                                if (this._generator.isCommitted() == false) throw var5_9;
                                if (this._generator.isComplete() != false) throw var5_9;
                                if (this._endp instanceof SelectChannelEndPoint == false) throw var5_9;
                                ((SelectChannelEndPoint)this._endp).setWritable(false);
                                throw var5_9;
                            }
                            v1 = more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                            if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                if (!this._generator.isPersistent()) {
                                    this._parser.reset(true);
                                    more_in_buffer = false;
                                }
                                this.reset(more_in_buffer == false);
                                progress = true;
                            }
                            if (this._request.isAsyncStarted()) {
                                Log.debug("return with suspended request");
                                more_in_buffer = false;
                            } else if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp instanceof SelectChannelEndPoint) {
                                ((SelectChannelEndPoint)this._endp).setWritable(false);
                            }
                            var8_6 = null;
                            break block35;
lbl-1000:
                            // 1 sources

                            {
                                progress = false;
                            }
                        }
                        var6_5 = null;
                        v2 = more_in_buffer = this._parser.isMoreInBuffer() != false || this._endp.isBufferingInput() != false;
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            if (!this._generator.isPersistent()) {
                                this._parser.reset(true);
                                more_in_buffer = false;
                            }
                            this.reset(more_in_buffer == false);
                            progress = true;
                        }
                        if (this._request.isAsyncStarted()) {
                            Log.debug("return with suspended request");
                            more_in_buffer = false;
                            continue;
                        }
                        if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof SelectChannelEndPoint)) continue;
                        ((SelectChannelEndPoint)this._endp).setWritable(false);
                    }
                    break block36;
                }
                catch (Throwable var7_10) {
                    var8_8 = null;
                    HttpConnection.setCurrentConnection(null);
                    this._handling = false;
                    throw var7_10;
                }
            }
            HttpConnection.setCurrentConnection(null);
            this._handling = false;
            return;
        }
        var8_7 = null;
        HttpConnection.setCurrentConnection(null);
        this._handling = false;
    }

    public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
        throw new UnsupportedOperationException();
    }

    public void cancelTimeout(Timeout.Task task) {
        throw new UnsupportedOperationException();
    }

    public void reset(boolean returnBuffers) {
        this._parser.reset(returnBuffers);
        this._requestFields.clear();
        this._request.recycle();
        this._generator.reset(returnBuffers);
        this._responseFields.clear();
        this._response.recycle();
        this._uri.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest() throws IOException {
        boolean error = false;
        String threadName = null;
        try {
            boolean handling;
            if (Log.isDebugEnabled()) {
                threadName = Thread.currentThread().getName();
                Thread.currentThread().setName(threadName + " - " + this._uri);
            }
            Server server = this._server;
            boolean bl = handling = this._request._async.handling() && server != null && server.isRunning();
            while (handling) {
                Object var7_11;
                this._request.setHandled(false);
                try {
                    block33: {
                        try {
                            String info = URIUtil.canonicalPath(this._uri.getDecodedPath());
                            if (info == null) {
                                throw new HttpException(400);
                            }
                            this._request.setPathInfo(info);
                            if (this._out != null) {
                                this._out.reopen();
                            }
                            if (this._request._async.isInitial()) {
                                this._request.setDispatcherType(DispatcherType.REQUEST);
                                this._connector.customize(this._endp, this._request);
                                server.handle(this);
                                break block33;
                            }
                            this._request.setDispatcherType(DispatcherType.ASYNC);
                            server.handleAsync(this);
                        }
                        catch (ContinuationThrowable e) {
                            Log.debug(e);
                            var7_11 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                            continue;
                        }
                        catch (EofException e) {
                            Log.debug(e);
                            error = true;
                            var7_11 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                            continue;
                        }
                        catch (HttpException e) {
                            Log.debug(e);
                            this._request.setHandled(true);
                            this._response.sendError(e.getStatus(), e.getReason());
                            error = true;
                            var7_11 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                            continue;
                        }
                        catch (Exception e) {
                            Log.warn(e);
                            this._request.setHandled(true);
                            this._generator.sendError(500, null, null, true);
                            error = true;
                            var7_11 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                            continue;
                        }
                        catch (Error e) {
                            Log.warn(e);
                            this._request.setHandled(true);
                            this._generator.sendError(500, null, null, true);
                            error = true;
                            var7_11 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                            continue;
                        }
                    }
                    var7_11 = null;
                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                }
                catch (Throwable throwable) {
                    var7_11 = null;
                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                    throw throwable;
                }
            }
            Object var9_13 = null;
            if (threadName != null) {
                Thread.currentThread().setName(threadName);
            }
            if (!this._request._async.isUncompleted()) return;
            this._request._async.doComplete();
            if (this._expect100Continue) {
                this._expect100Continue = false;
                if (this._parser instanceof HttpParser) {
                    ((HttpParser)this._parser).setState(0);
                }
            }
            if (this._endp.isOpen()) {
                if (this._generator.isPersistent()) {
                    this._connector.persist(this._endp);
                }
                if (error) {
                    this._endp.close();
                } else {
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                }
            } else {
                this._response.complete();
            }
            this._request.setHandled(true);
            return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (threadName != null) {
                Thread.currentThread().setName(threadName);
            }
            if (!this._request._async.isUncompleted()) throw throwable;
            this._request._async.doComplete();
            if (this._expect100Continue) {
                this._expect100Continue = false;
                if (this._parser instanceof HttpParser) {
                    ((HttpParser)this._parser).setState(0);
                }
            }
            if (this._endp.isOpen()) {
                if (this._generator.isPersistent()) {
                    this._connector.persist(this._endp);
                }
                if (error) {
                    this._endp.close();
                } else {
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    }
                    this._response.complete();
                }
            } else {
                this._response.complete();
            }
            this._request.setHandled(true);
            throw throwable;
        }
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, last);
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, true);
        }
        this._generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flushBuffer();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException(e);
        }
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    public boolean isIdle() {
        return this._generator.isIdle() && (this._parser.isIdle() || this._delayedHandling);
    }

    public boolean isSuspended() {
        return this._request.getAsyncContinuation().isSuspended();
    }

    public boolean isExpecting100Continues() {
        return this._expect100Continue;
    }

    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public class OutputWriter
    extends HttpWriter {
        OutputWriter() {
            super(HttpConnection.this._out);
        }
    }

    public class Output
    extends HttpOutput {
        Output() {
            super((AbstractGenerator)HttpConnection.this._generator, HttpConnection.this._connector.isLowResources() ? (long)HttpConnection.this._connector.getLowResourceMaxIdleTime() : (long)HttpConnection.this._connector.getMaxIdleTime());
        }

        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            if (!HttpConnection.this.isIncluding() && !this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            super.close();
        }

        public void flush() throws IOException {
            if (!this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        public void print(String s) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            PrintWriter writer = HttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendResponse(Buffer response) throws IOException {
            ((HttpGenerator)this._generator).sendResponse(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendContent(Object content) throws IOException {
            Resource resource = null;
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.getContentWritten() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                Buffer contentType = c.getContentType();
                if (contentType != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    String enc = HttpConnection.this._response.getSetCharacterEncoding();
                    if (enc == null) {
                        HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, contentType);
                    } else if (contentType instanceof BufferCache.CachedBuffer) {
                        BufferCache.CachedBuffer content_type = ((BufferCache.CachedBuffer)contentType).getAssociate(enc);
                        if (content_type != null) {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, content_type);
                        } else {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quote(enc, ";= "));
                        }
                    } else {
                        HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quote(enc, ";= "));
                    }
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                Buffer lm = c.getLastModified();
                long lml = c.getResource().lastModified();
                if (lm != null) {
                    HttpConnection.this._responseFields.put(HttpHeaders.LAST_MODIFIED_BUFFER, lm, lml);
                } else if (c.getResource() != null && lml != -1L) {
                    HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
                }
                content = c.getBuffer();
                if (content == null) {
                    content = c.getInputStream();
                }
            } else if (content instanceof Resource) {
                resource = (Resource)content;
                HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, resource.lastModified());
                content = resource.getInputStream();
            }
            if (content instanceof Buffer) {
                this._generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof InputStream) {
                InputStream in;
                block26: {
                    in = (InputStream)content;
                    try {
                        int max = this._generator.prepareUncheckedAddContent();
                        Buffer buffer = this._generator.getUncheckedBuffer();
                        int len = buffer.readFrom(in, max);
                        while (len >= 0) {
                            this._generator.completeUncheckedAddContent();
                            HttpConnection.this._out.flush();
                            max = this._generator.prepareUncheckedAddContent();
                            buffer = this._generator.getUncheckedBuffer();
                            len = buffer.readFrom(in, max);
                        }
                        this._generator.completeUncheckedAddContent();
                        HttpConnection.this._out.flush();
                        Object var9_10 = null;
                        if (resource == null) break block26;
                        resource.release();
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (resource != null) {
                            resource.release();
                        } else {
                            in.close();
                        }
                        throw throwable;
                    }
                }
                in.close();
                {
                }
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        private String _charset;

        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = false;
            HttpConnection.this._expect100Continue = false;
            HttpConnection.this._expect102Processing = false;
            HttpConnection.this._delayedHandling = false;
            this._charset = null;
            if (HttpConnection.this._request.getTimeStamp() == 0L) {
                HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            }
            HttpConnection.this._request.setMethod(method.toString());
            try {
                HttpConnection.this._uri.parse(uri.array(), uri.getIndex(), uri.length());
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                if (version == null) {
                    HttpConnection.this._request.setProtocol("");
                    HttpConnection.this._version = 9;
                } else {
                    version = HttpVersions.CACHE.get(version);
                    HttpConnection.this._version = HttpVersions.CACHE.getOrdinal(version);
                    if (HttpConnection.this._version <= 0) {
                        HttpConnection.this._version = 10;
                    }
                    HttpConnection.this._request.setProtocol(version.toString());
                }
                HttpConnection.this._head = method == HttpMethods.HEAD_BUFFER;
            }
            catch (Exception e) {
                Log.warn(e);
                throw new HttpException(400, null, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            block0 : switch (ho) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    switch (HttpHeaderValues.CACHE.getOrdinal(value)) {
                        case 6: {
                            HttpConnection.this._expect100Continue = true;
                            break block0;
                        }
                        case 7: {
                            HttpConnection.this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = value.toString().split(",");
                    block24: for (int i = 0; values != null && i < values.length; ++i) {
                        BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[i].trim());
                        if (cb == null) {
                            HttpConnection.this._expect = true;
                            continue;
                        }
                        switch (cb.getOrdinal()) {
                            case 6: {
                                HttpConnection.this._expect100Continue = true;
                                continue block24;
                            }
                            case 7: {
                                HttpConnection.this._expect102Processing = true;
                                continue block24;
                            }
                            default: {
                                HttpConnection.this._expect = true;
                            }
                        }
                    }
                    break;
                }
                case 21: 
                case 40: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 16: {
                    value = MimeTypes.CACHE.lookup(value);
                    this._charset = MimeTypes.getCharsetFromContentType(value);
                    break;
                }
                case 1: {
                    switch (HttpHeaderValues.CACHE.getOrdinal(value)) {
                        case -1: {
                            String[] values = value.toString().split(",");
                            block25: for (int i = 0; values != null && i < values.length; ++i) {
                                BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[i].trim());
                                if (cb == null) continue;
                                switch (cb.getOrdinal()) {
                                    case 1: {
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                                        HttpConnection.this._generator.setPersistent(false);
                                        continue block25;
                                    }
                                    case 5: {
                                        if (HttpConnection.this._version != 10) continue block25;
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                                        continue block25;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                            HttpConnection.this._generator.setPersistent(false);
                            break;
                        }
                        case 5: {
                            if (HttpConnection.this._version != 10) break;
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                        }
                    }
                    break;
                }
            }
            HttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            HttpConnection.this._requests++;
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (HttpConnection.this._server.getSendDateHeader()) {
                        HttpConnection.this._responseFields.put(HttpHeaders.DATE_BUFFER, HttpConnection.this._request.getTimeStampBuffer(), HttpConnection.this._request.getTimeStamp());
                    }
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (!HttpConnection.this._expect) break;
                    HttpConnection.this._generator.sendError(417, null, null, true);
                    return;
                }
            }
            if (this._charset != null) {
                HttpConnection.this._request.setCharacterEncodingUnchecked(this._charset);
            }
            if (((HttpParser)HttpConnection.this._parser).getContentLength() <= 0L && !((HttpParser)HttpConnection.this._parser).isChunking() || HttpConnection.this._expect100Continue) {
                HttpConnection.this.handleRequest();
            } else {
                HttpConnection.this._delayedHandling = true;
            }
        }

        public void content(Buffer ref) throws IOException {
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void messageComplete(long contentLength) throws IOException {
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            Log.debug("Bad request!: " + version + " " + status + " " + reason);
        }
    }
}

