/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;

public class CookieCutter {
    private static final byte STATE_DELIMITER = 1;
    private static final byte STATE_NAME = 2;
    private static final byte STATE_VALUE = 4;
    private static final byte STATE_QUOTED_VALUE = 8;
    private static final byte STATE_UNQUOTED_VALUE = 16;
    private Cookie[] _cookies;
    private String[] _fields;
    int _added = 0;
    boolean _dirty;
    HttpServletRequest _request;

    public CookieCutter() {
    }

    public CookieCutter(HttpServletRequest request) {
        this._request = request;
    }

    public Cookie[] getCookies() {
        if (this._added > 0) {
            if (!this._dirty && this._added == this._fields.length) {
                this._added = 0;
                return this._cookies;
            }
            this.parseFields();
        }
        return this._cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this._dirty = false;
        this._added = 0;
        this._cookies = cookies;
    }

    public void reset() {
        this._fields = null;
        this._cookies = null;
    }

    public void addCookieField(String f) {
        if (!this._dirty && this._fields != null && this._fields.length > this._added && this._fields[this._added].equals(f)) {
            ++this._added;
            return;
        }
        if (this._dirty) {
            ++this._added;
            this._fields = (String[])LazyList.addToArray(this._fields, f, String.class);
        } else {
            this._dirty = true;
            if (this._added > 0) {
                String[] fields = new String[this._added + 1];
                System.arraycopy(this._fields, 0, fields, 0, this._added);
                fields[this._added++] = f;
                this._fields = fields;
            } else {
                this._fields = new String[]{f};
                this._added = 1;
            }
        }
    }

    protected void parseFields() {
        Object cookies = null;
        int version = 0;
        for (int f = 0; f < this._added; ++f) {
            String hdr = this._fields[f];
            String name = null;
            String value = null;
            Cookie cookie = null;
            int state = 2;
            int tokenstart = 0;
            int length = hdr.length();
            for (int i = 0; i < length; ++i) {
                char c = hdr.charAt(i);
                block1 : switch (c) {
                    case ',': 
                    case ';': {
                        switch (state) {
                            case 1: {
                                state = 2;
                                tokenstart = i + 1;
                                break;
                            }
                            case 16: {
                                state = 2;
                                value = hdr.substring(tokenstart, i).trim();
                                if (this._request != null && this._request.isRequestedSessionIdFromURL()) {
                                    value = URIUtil.decodePath(value);
                                }
                                tokenstart = i + 1;
                                break;
                            }
                            case 2: {
                                name = hdr.substring(tokenstart, i);
                                value = "";
                                tokenstart = i + 1;
                                break;
                            }
                            case 4: {
                                state = 2;
                                value = "";
                                tokenstart = i + 1;
                            }
                        }
                        break;
                    }
                    case '=': {
                        switch (state) {
                            case 2: {
                                state = 4;
                                name = hdr.substring(tokenstart, i);
                                tokenstart = i + 1;
                                break;
                            }
                            case 4: {
                                state = 16;
                                tokenstart = i;
                            }
                        }
                        break;
                    }
                    case '\"': {
                        switch (state) {
                            case 4: {
                                state = 8;
                                tokenstart = i + 1;
                                break;
                            }
                            case 8: {
                                state = 1;
                                value = hdr.substring(tokenstart, i);
                            }
                        }
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    default: {
                        switch (state) {
                            case 4: {
                                state = 16;
                                tokenstart = i;
                                break block1;
                            }
                            case 1: {
                                state = 2;
                                tokenstart = i;
                            }
                        }
                    }
                }
                if (i + 1 == length) {
                    switch (state) {
                        case 16: {
                            value = hdr.substring(tokenstart).trim();
                            if (this._request == null || !this._request.isRequestedSessionIdFromURL()) break;
                            value = URIUtil.decodePath(value);
                            break;
                        }
                        case 2: {
                            name = hdr.substring(tokenstart);
                            value = "";
                            break;
                        }
                        case 4: {
                            value = "";
                        }
                    }
                }
                if (name == null || value == null) continue;
                name = name.trim();
                try {
                    if (name.startsWith("$")) {
                        String lowercaseName = name.toLowerCase();
                        if ("$path".equals(lowercaseName)) {
                            cookie.setPath(value);
                        } else if ("$domain".equals(lowercaseName)) {
                            cookie.setDomain(value);
                        } else if ("$version".equals(lowercaseName)) {
                            version = Integer.parseInt(value);
                        }
                    } else {
                        cookie = new Cookie(name, value);
                        if (version > 0) {
                            cookie.setVersion(version);
                        }
                        cookies = LazyList.add(cookies, cookie);
                    }
                }
                catch (Exception e) {
                    Log.ignore(e);
                }
                name = null;
                value = null;
            }
        }
        int l = LazyList.size(cookies);
        if (l > 0) {
            if (this._cookies != null && this._cookies.length == l) {
                for (int i = 0; i < l; ++i) {
                    this._cookies[i] = (Cookie)LazyList.get(cookies, i);
                }
            } else {
                this._cookies = (Cookie[])LazyList.toArray(cookies, Cookie.class);
            }
        }
        this._added = 0;
        this._dirty = false;
    }
}

