/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.io.Buffer;

public class HttpEventListenerWrapper
implements HttpEventListener {
    HttpEventListener _listener;
    boolean _delegatingRequests;
    boolean _delegatingResponses;

    public HttpEventListenerWrapper() {
        this._listener = null;
        this._delegatingRequests = false;
        this._delegatingResponses = false;
    }

    public HttpEventListenerWrapper(HttpEventListener eventListener, boolean delegating) {
        this._listener = eventListener;
        this._delegatingRequests = delegating;
        this._delegatingResponses = delegating;
    }

    public HttpEventListener getEventListener() {
        return this._listener;
    }

    public void setEventListener(HttpEventListener listener) {
        this._listener = listener;
    }

    public boolean isDelegatingRequests() {
        return this._delegatingRequests;
    }

    public boolean isDelegatingResponses() {
        return this._delegatingResponses;
    }

    public void setDelegatingRequests(boolean delegating) {
        this._delegatingRequests = delegating;
    }

    public void setDelegatingResponses(boolean delegating) {
        this._delegatingResponses = delegating;
    }

    public void onConnectionFailed(Throwable ex) {
        if (this._delegatingRequests) {
            this._listener.onConnectionFailed(ex);
        }
    }

    public void onException(Throwable ex) {
        if (this._delegatingRequests || this._delegatingResponses) {
            this._listener.onException(ex);
        }
    }

    public void onExpire() {
        if (this._delegatingRequests || this._delegatingResponses) {
            this._listener.onExpire();
        }
    }

    public void onRequestCommitted() throws IOException {
        if (this._delegatingRequests) {
            this._listener.onRequestCommitted();
        }
    }

    public void onRequestComplete() throws IOException {
        if (this._delegatingRequests) {
            this._listener.onRequestComplete();
        }
    }

    public void onResponseComplete() throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseComplete();
        }
    }

    public void onResponseContent(Buffer content) throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseContent(content);
        }
    }

    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseHeader(name, value);
        }
    }

    public void onResponseHeaderComplete() throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseHeaderComplete();
        }
    }

    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseStatus(version, status, reason);
        }
    }

    public void onRetry() {
        if (this._delegatingRequests) {
            this._listener.onRetry();
        }
    }
}

