/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BlockingHttpConnection
extends HttpConnection {
    private static final Logger LOG = Log.getLogger(BlockingHttpConnection.class);
    private volatile boolean _handling;

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        super(connector, endpoint, server, parser, generator, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection handle() throws IOException {
        Connection connection = this;
        boolean more_in_buffer = true;
        try {
            BlockingHttpConnection.setCurrentConnection(this);
            while (more_in_buffer && this._endp.isOpen()) {
                block35: {
                    try {
                        long written;
                        if (!this._parser.isComplete()) {
                            this._parser.parseAvailable();
                        }
                        while (this._generator.isCommitted() && !this._generator.isComplete() && (written = this._generator.flushBuffer()) > 0L) {
                            if (!this._endp.isBufferingOutput()) continue;
                            this._endp.flush();
                        }
                        if (!this._endp.isBufferingOutput()) break block35;
                        this._endp.flush();
                    }
                    catch (HttpException e) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("uri=" + this._uri, new Object[0]);
                                LOG.debug("fields=" + this._requestFields, new Object[0]);
                                LOG.debug(e);
                            }
                            this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                            this._parser.reset();
                            this._endp.shutdownOutput();
                        }
                        catch (Throwable throwable) {
                            boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                                Connection switched;
                                Connection connection2 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                                if (switched != null) {
                                    this._parser.reset();
                                    this._generator.reset(true);
                                    connection = switched;
                                } else {
                                    if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                                        this._parser.reset();
                                        more_in_buffer = false;
                                        this._endp.close();
                                    }
                                    if (more_in_buffer) {
                                        this.reset(false);
                                        more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                    } else {
                                        this.reset(true);
                                    }
                                }
                            } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                                more_in_buffer = false;
                                this._endp.close();
                            }
                            if (!this._request.isAsyncStarted()) throw throwable;
                            throw new IllegalStateException();
                            return connection;
                        }
                        boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            Connection switched;
                            Connection connection3 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                            if (switched != null) {
                                this._parser.reset();
                                this._generator.reset(true);
                                connection = switched;
                            } else {
                                if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                                    this._parser.reset();
                                    more_in_buffer = false;
                                    this._endp.close();
                                }
                                if (more_in_buffer) {
                                    this.reset(false);
                                    more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                } else {
                                    this.reset(true);
                                }
                            }
                        } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                            more_in_buffer = false;
                            this._endp.close();
                        }
                        if (!this._request.isAsyncStarted()) continue;
                        throw new IllegalStateException();
                    }
                }
                boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                    Connection switched;
                    Connection connection4 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                    if (switched != null) {
                        this._parser.reset();
                        this._generator.reset(true);
                        connection = switched;
                    } else {
                        if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                            this._parser.reset();
                            more_in_buffer = false;
                            this._endp.close();
                        }
                        if (more_in_buffer) {
                            this.reset(false);
                            more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                        } else {
                            this.reset(true);
                        }
                    }
                } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                    more_in_buffer = false;
                    this._endp.close();
                }
                if (!this._request.isAsyncStarted()) continue;
                throw new IllegalStateException();
            }
        }
        finally {
            this._parser.returnBuffers();
            BlockingHttpConnection.setCurrentConnection(null);
            this._handling = false;
        }
    }
}

