/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebFilterAnnotation
extends DiscoveredAnnotation {
    public WebFilterAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    @Override
    public void apply() {
        FilterHolder holder;
        Class<?> clazz = this.getTargetClass();
        if (clazz == null) {
            Log.warn(this._className + " cannot be loaded");
            return;
        }
        if (!Filter.class.isAssignableFrom(clazz)) {
            Log.warn(clazz.getName() + " is not assignable from javax.servlet.Filter");
            return;
        }
        MetaData metaData = this._context.getMetaData();
        WebFilter filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (filterAnnotation.value().length > 0 && filterAnnotation.urlPatterns().length > 0) {
            Log.warn(clazz.getName() + " defines both @WebFilter.value and @WebFilter.urlPatterns");
            return;
        }
        String name = filterAnnotation.filterName().equals("") ? clazz.getName() : filterAnnotation.filterName();
        String[] urlPatterns = filterAnnotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = filterAnnotation.urlPatterns();
        }
        if ((holder = this._context.getServletHandler().getFilter(name)) == null) {
            String s;
            int i$;
            holder = this._context.getServletHandler().newFilterHolder(Holder.Source.ANNOTATION);
            holder.setName(name);
            holder.setHeldClass(clazz);
            metaData.setOrigin(name + ".filter.filter-class");
            holder.setDisplayName(filterAnnotation.displayName());
            metaData.setOrigin(name + ".filter.display-name");
            for (WebInitParam ip : filterAnnotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(name + ".filter.init-param." + ip.name());
            }
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            if (urlPatterns.length > 0) {
                ArrayList<String> paths = new ArrayList<String>();
                String[] arr$ = urlPatterns;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    s = arr$[i$];
                    paths.add(Util.normalizePattern(s));
                }
                mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
            }
            if (filterAnnotation.servletNames().length > 0) {
                ArrayList<String> names = new ArrayList<String>();
                String[] arr$ = filterAnnotation.servletNames();
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    s = arr$[i$];
                    names.add(s);
                }
                mapping.setServletNames(names.toArray(new String[names.size()]));
            }
            EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
            for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                dispatcherSet.add(d);
            }
            mapping.setDispatcherTypes(dispatcherSet);
            metaData.setOrigin(name + ".filter.mappings");
            holder.setAsyncSupported(filterAnnotation.asyncSupported());
            metaData.setOrigin(name + ".filter.async-supported");
            this._context.getServletHandler().addFilter(holder);
            this._context.getServletHandler().addFilterMapping(mapping);
        } else {
            for (WebInitParam ip : filterAnnotation.initParams()) {
                if (metaData.getOrigin(name + ".filter.init-param." + ip.name()) != Origin.NotSet) continue;
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(name + ".filter.init-param." + ip.name());
            }
            FilterMapping[] mappings = this._context.getServletHandler().getFilterMappings();
            boolean mappingExists = false;
            if (mappings != null) {
                for (FilterMapping m : mappings) {
                    if (!m.getFilterName().equals(name)) continue;
                    mappingExists = true;
                    break;
                }
            }
            if (!mappingExists) {
                String s;
                int i$;
                FilterMapping mapping = new FilterMapping();
                mapping.setFilterName(holder.getName());
                if (urlPatterns.length > 0) {
                    ArrayList<String> paths = new ArrayList<String>();
                    String[] arr$ = urlPatterns;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        s = arr$[i$];
                        paths.add(Util.normalizePattern(s));
                    }
                    mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                }
                if (filterAnnotation.servletNames().length > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    String[] arr$ = filterAnnotation.servletNames();
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        s = arr$[i$];
                        names.add(s);
                    }
                    mapping.setServletNames(names.toArray(new String[names.size()]));
                }
                EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
                for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                    dispatcherSet.add(d);
                }
                mapping.setDispatcherTypes(dispatcherSet);
                this._context.getServletHandler().addFilterMapping(mapping);
                metaData.setOrigin(name + ".filter.mappings");
            }
        }
    }
}

