/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;

public class MetaData {
    public static final String METADATA = "org.eclipse.jetty.metaData";
    public static final String METADATA_COMPLETE = "org.eclipse.jetty.metadataComplete";
    public static final String WEBXML_MAJOR_VERSION = "org.eclipse.jetty.webXmlMajorVersion";
    public static final String WEBXML_MINOR_VERSION = "org.eclipse.jetty.webXmlMinorVersion";
    public static final String WEBXML_CLASSNAMES = "org.eclipse.jetty.webXmlClassNames";
    protected WebAppContext _context;
    protected Map<String, OriginInfo> _origins = new HashMap<String, OriginInfo>();
    protected Descriptor _webDefaultsRoot;
    protected Descriptor _webXmlRoot;
    protected Descriptor _webOverrideRoot;
    protected List<DiscoveredAnnotation> _annotations = new ArrayList<DiscoveredAnnotation>();
    protected List<DescriptorProcessor> _descriptorProcessors = new ArrayList<DescriptorProcessor>();
    protected List<FragmentDescriptor> _webFragmentRoots = new ArrayList<FragmentDescriptor>();
    protected Map<String, FragmentDescriptor> _webFragmentNameMap = new HashMap<String, FragmentDescriptor>();
    protected Map<Resource, FragmentDescriptor> _webFragmentResourceMap = new HashMap<Resource, FragmentDescriptor>();
    protected Map<Resource, List<DiscoveredAnnotation>> _webFragmentAnnotations = new HashMap<Resource, List<DiscoveredAnnotation>>();
    protected List<Resource> _orderedResources;
    protected Ordering _ordering;
    protected StandardDescriptorProcessor _standardDescriptorProcessor;

    public MetaData(WebAppContext context) throws ClassNotFoundException {
        this._context = context;
    }

    public WebAppContext getContext() {
        return this._context;
    }

    public void setDefaults(Resource webDefaults) throws Exception {
        this._webDefaultsRoot = new DefaultsDescriptor(webDefaults, this);
        this._webDefaultsRoot.parse();
        if (this._webDefaultsRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new AbsoluteOrdering();
            }
            List<String> order = this._webDefaultsRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void setWebXml(Resource webXml) throws Exception {
        this._webXmlRoot = new Descriptor(webXml, this);
        this._webXmlRoot.parse();
        if (this._webXmlRoot.getMetaDataComplete() == Descriptor.MetaDataComplete.True) {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.TRUE);
        } else {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.FALSE);
        }
        this._context.getServletContext().setEffectiveMajorVersion(this._webXmlRoot.getMajorVersion());
        this._context.getServletContext().setEffectiveMinorVersion(this._webXmlRoot.getMinorVersion());
        this._context.setAttribute(WEBXML_CLASSNAMES, this._webXmlRoot.getClassNames());
        if (this._webXmlRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new AbsoluteOrdering();
            }
            List<String> order = this._webXmlRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void setOverride(Resource override) throws Exception {
        this._webOverrideRoot = new OverrideDescriptor(override, this);
        this._webOverrideRoot.setValidating(false);
        this._webOverrideRoot.parse();
        if (this._webOverrideRoot.getMetaDataComplete() == Descriptor.MetaDataComplete.True) {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.TRUE);
        } else if (this._webOverrideRoot.getMetaDataComplete() == Descriptor.MetaDataComplete.False) {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.FALSE);
        }
        if (this._webOverrideRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new AbsoluteOrdering();
            }
            List<String> order = this._webOverrideRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void addFragment(Resource jarResource, Resource xmlResource) throws Exception {
        Boolean metaComplete = (Boolean)this._context.getAttribute(METADATA_COMPLETE);
        if (metaComplete != null && metaComplete.booleanValue()) {
            return;
        }
        FragmentDescriptor descriptor = new FragmentDescriptor(xmlResource, this);
        this._webFragmentResourceMap.put(jarResource, descriptor);
        this._webFragmentRoots.add(descriptor);
        descriptor.parse();
        if (descriptor.getName() != null) {
            this._webFragmentNameMap.put(descriptor.getName(), descriptor);
        }
        if (this._ordering != null && this._ordering.isAbsolute()) {
            return;
        }
        if (this._ordering == null && descriptor.isOrdered()) {
            this._ordering = new RelativeOrdering();
        }
    }

    public void addDiscoveredAnnotations(List<DiscoveredAnnotation> annotations) {
        this._annotations.addAll(annotations);
    }

    public void addDiscoveredAnnotations(Resource resource, List<DiscoveredAnnotation> annotations) {
        this._webFragmentAnnotations.put(resource, new ArrayList<DiscoveredAnnotation>(annotations));
    }

    public void addDescriptorProcessor(DescriptorProcessor p) {
        this._descriptorProcessors.add(p);
    }

    public void orderFragments() {
        if (this._orderedResources != null) {
            return;
        }
        if (this._ordering != null) {
            this._orderedResources = this._ordering.order((List)this._context.getAttribute("org.eclipse.jetty.webInfJars"));
            this._context.setAttribute("org.eclipse.jetty.webInfOrderedJars", this._orderedResources);
            ArrayList<String> orderedJars = new ArrayList<String>();
            for (Resource webInfJar : this._orderedResources) {
                String fullname = webInfJar.getName();
                int i = fullname.indexOf(".jar");
                int j = fullname.lastIndexOf("/", i);
                orderedJars.add(fullname.substring(j + 1, i + 4));
            }
            this._context.setAttribute("javax.servlet.context.orderedLibs", orderedJars);
        } else {
            this._orderedResources = new ArrayList<Resource>((List)this._context.getAttribute("org.eclipse.jetty.webInfJars"));
        }
    }

    public void resolve() throws Exception {
        for (DescriptorProcessor p : this._descriptorProcessors) {
            p.process(this.getWebDefault());
            p.process(this.getWebXml());
            p.process(this.getOverrideWeb());
        }
        for (DiscoveredAnnotation a : this._annotations) {
            a.apply();
        }
        List<Resource> resources = this.getOrderedResources();
        for (Resource r : resources) {
            List<DiscoveredAnnotation> fragAnnotations;
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd != null) {
                for (DescriptorProcessor p : this._descriptorProcessors) {
                    p.process(fd);
                }
            }
            if ((fragAnnotations = this._webFragmentAnnotations.get(r)) == null) continue;
            for (DiscoveredAnnotation a : fragAnnotations) {
                a.apply();
            }
        }
    }

    public boolean isDistributable() {
        boolean distributable = this._webDefaultsRoot != null && this._webDefaultsRoot.isDistributable() || this._webXmlRoot != null && this._webXmlRoot.isDistributable() || this._webOverrideRoot != null && this._webOverrideRoot.isDistributable();
        List<Resource> orderedResources = this.getOrderedResources();
        for (Resource r : orderedResources) {
            FragmentDescriptor d = this._webFragmentResourceMap.get(r);
            if (d == null) continue;
            distributable = distributable && d.isDistributable();
        }
        return distributable;
    }

    public Descriptor getWebXml() {
        return this._webXmlRoot;
    }

    public Descriptor getOverrideWeb() {
        return this._webOverrideRoot;
    }

    public Descriptor getWebDefault() {
        return this._webDefaultsRoot;
    }

    public List<FragmentDescriptor> getFragments() {
        return this._webFragmentRoots;
    }

    public List<Resource> getOrderedResources() {
        return this._orderedResources;
    }

    public List<FragmentDescriptor> getOrderedFragments() {
        ArrayList<FragmentDescriptor> list = new ArrayList<FragmentDescriptor>();
        if (this._orderedResources == null) {
            return list;
        }
        for (Resource r : this._orderedResources) {
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd == null) continue;
            list.add(fd);
        }
        return list;
    }

    public Ordering getOrdering() {
        return this._ordering;
    }

    public void setOrdering(Ordering o) {
        this._ordering = o;
    }

    public FragmentDescriptor getFragment(Resource jar) {
        return this._webFragmentResourceMap.get(jar);
    }

    public FragmentDescriptor getFragment(String name) {
        return this._webFragmentNameMap.get(name);
    }

    public Resource getJarForFragment(String name) {
        FragmentDescriptor f = this.getFragment(name);
        if (f == null) {
            return null;
        }
        Resource jar = null;
        for (Resource r : this._webFragmentResourceMap.keySet()) {
            if (!this._webFragmentResourceMap.get(r).equals(f)) continue;
            jar = r;
        }
        return jar;
    }

    public Map<String, FragmentDescriptor> getNamedFragments() {
        return Collections.unmodifiableMap(this._webFragmentNameMap);
    }

    public Origin getOrigin(String name) {
        OriginInfo x = this._origins.get(name);
        if (x == null) {
            return Origin.NotSet;
        }
        return x.getOriginType();
    }

    public Descriptor getOriginDescriptor(String name) {
        OriginInfo o = this._origins.get(name);
        if (o == null) {
            return null;
        }
        return o.getDescriptor();
    }

    public void setOrigin(String name, Descriptor d) {
        OriginInfo x = new OriginInfo(name, d);
        this._origins.put(name, x);
    }

    public void setOrigin(String name) {
        if (name == null) {
            return;
        }
        OriginInfo x = new OriginInfo(name, Origin.Annotation);
        this._origins.put(name, x);
    }

    public class RelativeOrdering
    implements Ordering {
        protected LinkedList<Resource> _beforeOthers = new LinkedList();
        protected LinkedList<Resource> _afterOthers = new LinkedList();
        protected LinkedList<Resource> _noOthers = new LinkedList();

        @Override
        public List<Resource> order(List<Resource> jars) {
            for (Resource jar : jars) {
                FragmentDescriptor descriptor = MetaData.this._webFragmentResourceMap.get(jar);
                if (descriptor != null) {
                    switch (descriptor.getOtherType()) {
                        case None: {
                            ((RelativeOrdering)MetaData.this._ordering).addNoOthers(jar);
                            break;
                        }
                        case Before: {
                            ((RelativeOrdering)MetaData.this._ordering).addBeforeOthers(jar);
                            break;
                        }
                        case After: {
                            ((RelativeOrdering)MetaData.this._ordering).addAfterOthers(jar);
                        }
                    }
                    continue;
                }
                ((RelativeOrdering)MetaData.this._ordering).addNoOthers(jar);
            }
            ArrayList<Resource> orderedList = new ArrayList<Resource>();
            int maxIterations = 2;
            boolean done = false;
            do {
                boolean changesBefore = this.orderList(this._beforeOthers);
                boolean changesAfter = this.orderList(this._afterOthers);
                boolean changesNone = this.orderList(this._noOthers);
                boolean bl = done = !changesBefore && !changesAfter && !changesNone;
            } while (!done && --maxIterations > 0);
            if (!done) {
                throw new IllegalStateException("Circular references for fragments");
            }
            for (Resource r : this._beforeOthers) {
                orderedList.add(r);
            }
            for (Resource r : this._noOthers) {
                orderedList.add(r);
            }
            for (Resource r : this._afterOthers) {
                orderedList.add(r);
            }
            return orderedList;
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        public boolean hasOther() {
            return !this._beforeOthers.isEmpty() || !this._afterOthers.isEmpty();
        }

        public void addBeforeOthers(Resource r) {
            this._beforeOthers.addLast(r);
        }

        public void addAfterOthers(Resource r) {
            this._afterOthers.addLast(r);
        }

        public void addNoOthers(Resource r) {
            this._noOthers.addLast(r);
        }

        protected boolean orderList(LinkedList<Resource> list) {
            boolean changes = false;
            ArrayList<Resource> iterable = new ArrayList<Resource>(list);
            for (Resource r : iterable) {
                List<String> afters;
                FragmentDescriptor f = MetaData.this.getFragment(r);
                if (f == null) continue;
                List<String> befores = f.getBefores();
                if (befores != null && !befores.isEmpty()) {
                    for (String b : befores) {
                        if (this.isBefore(list, f.getName(), b)) continue;
                        int idx1 = this.getIndexOf(list, f.getName());
                        int idx2 = this.getIndexOf(list, b);
                        if (idx2 < 0) {
                            changes = true;
                            Resource bResource = MetaData.this.getJarForFragment(b);
                            if (bResource == null || !this._noOthers.remove(bResource)) continue;
                            this.insert(list, idx1 + 1, b);
                            continue;
                        }
                        list.remove(idx1);
                        this.insert(list, idx2, f.getName());
                        changes = true;
                    }
                }
                if ((afters = f.getAfters()) == null || afters.isEmpty()) continue;
                for (String a : afters) {
                    if (this.isAfter(list, f.getName(), a)) continue;
                    int idx1 = this.getIndexOf(list, f.getName());
                    int idx2 = this.getIndexOf(list, a);
                    if (idx2 < 0) {
                        changes = true;
                        Resource aResource = MetaData.this.getJarForFragment(a);
                        if (aResource == null || !this._noOthers.remove(aResource)) continue;
                        this.insert(list, idx1, aResource);
                        continue;
                    }
                    list.remove(idx2);
                    this.insert(list, idx1, a);
                    changes = true;
                }
            }
            return changes;
        }

        protected boolean isBefore(List<Resource> list, String fragNameA, String fragNameB) {
            int idxa = this.getIndexOf(list, fragNameA);
            int idxb = this.getIndexOf(list, fragNameB);
            if (idxb >= 0 && idxb < idxa) {
                return false;
            }
            if (idxb < 0) {
                if (list == this._beforeOthers) {
                    return true;
                }
                if (list == this._afterOthers) {
                    if (this._beforeOthers.contains(fragNameB)) {
                        throw new IllegalStateException("Incorrect relationship: " + fragNameA + " before " + fragNameB);
                    }
                    return false;
                }
            }
            return true;
        }

        protected boolean isAfter(List<Resource> list, String fragNameA, String fragNameB) {
            int idxa = this.getIndexOf(list, fragNameA);
            int idxb = this.getIndexOf(list, fragNameB);
            if (idxb >= 0 && idxa < idxb) {
                return false;
            }
            if (idxb < 0) {
                if (list == this._afterOthers) {
                    return true;
                }
                if (list == this._beforeOthers) {
                    if (this._afterOthers.contains(fragNameB)) {
                        throw new IllegalStateException("Incorrect relationship: " + fragNameB + " after " + fragNameA);
                    }
                    return false;
                }
            }
            return true;
        }

        protected void insert(List<Resource> list, int index, String fragName) {
            Resource jar = MetaData.this.getJarForFragment(fragName);
            if (jar == null) {
                throw new IllegalStateException("No jar for insertion");
            }
            this.insert(list, index, jar);
        }

        protected void insert(List<Resource> list, int index, Resource resource) {
            if (list == null) {
                throw new IllegalStateException("List is null for insertion");
            }
            if (index > list.size()) {
                list.add(resource);
            } else {
                list.add(index, resource);
            }
        }

        protected void remove(List<Resource> resources, Resource r) {
            if (resources == null) {
                return;
            }
            resources.remove(r);
        }

        protected int getIndexOf(List<Resource> resources, String fragmentName) {
            FragmentDescriptor fd = MetaData.this.getFragment(fragmentName);
            if (fd == null) {
                return -1;
            }
            Resource r = MetaData.this.getJarForFragment(fragmentName);
            if (r == null) {
                return -1;
            }
            return resources.indexOf(r);
        }
    }

    public class AbsoluteOrdering
    implements Ordering {
        public static final String OTHER = "@@-OTHER-@@";
        protected List<String> _order = new ArrayList<String>();
        protected boolean _hasOther = false;

        @Override
        public List<Resource> order(List<Resource> jars) {
            ArrayList<Resource> orderedList = new ArrayList<Resource>();
            ArrayList<Resource> tmp = new ArrayList<Resource>(jars);
            HashMap<String, FragmentDescriptor> others = new HashMap<String, FragmentDescriptor>(MetaData.this.getNamedFragments());
            int index = -1;
            for (String item : this._order) {
                if (!item.equals(OTHER)) {
                    FragmentDescriptor f = (FragmentDescriptor)others.remove(item);
                    if (f == null) continue;
                    Resource jar = MetaData.this.getJarForFragment(item);
                    orderedList.add(jar);
                    tmp.remove(jar);
                    continue;
                }
                index = orderedList.size();
            }
            if (this._hasOther) {
                orderedList.addAll(index < 0 ? 0 : index, tmp);
            }
            return orderedList;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        public void add(String name) {
            this._order.add(name);
        }

        public void addOthers() {
            if (this._hasOther) {
                throw new IllegalStateException("Duplicate <other> element in absolute ordering");
            }
            this._hasOther = true;
            this._order.add(OTHER);
        }

        @Override
        public boolean hasOther() {
            return this._hasOther;
        }
    }

    public static interface Ordering {
        public List<Resource> order(List<Resource> var1);

        public boolean isAbsolute();

        public boolean hasOther();
    }

    public static class OriginInfo {
        protected String name;
        protected Origin origin;
        protected Descriptor descriptor;

        public OriginInfo(String n, Descriptor d) {
            this.name = n;
            this.descriptor = d;
            if (d == null) {
                throw new IllegalArgumentException("No descriptor");
            }
            if (d instanceof FragmentDescriptor) {
                this.origin = Origin.WebFragment;
            }
            if (d instanceof OverrideDescriptor) {
                this.origin = Origin.WebOverride;
            }
            if (d instanceof DefaultsDescriptor) {
                this.origin = Origin.WebDefaults;
            }
            this.origin = Origin.WebXml;
        }

        public OriginInfo(String n) {
            this.name = n;
            this.origin = Origin.Annotation;
        }

        public OriginInfo(String n, Origin o) {
            this.name = n;
            this.origin = o;
        }

        public String getName() {
            return this.name;
        }

        public Origin getOriginType() {
            return this.origin;
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static enum Origin {
        NotSet,
        WebXml,
        WebDefaults,
        WebOverride,
        WebFragment,
        Annotation;

    }
}

