/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.nio.NIOConnector;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.servlet.NIOResourceCache;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartOutputStream;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private ServletContext _servletContext;
    private ContextHandler _contextHandler;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _welcomeServlets = true;
    private boolean _welcomeExactServlets = false;
    private boolean _redirectWelcome = false;
    private boolean _gzip = true;
    private Resource _resourceBase;
    private NIOResourceCache _nioCache;
    private ResourceCache _bioCache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private boolean _useFileMappedBuffer = false;
    private ByteArrayBuffer _cacheControl;
    private String _relativeResourceBase;
    private ServletHandler _servletHandler;
    private ServletHolder _defaultHolder;

    public void init() throws UnavailableException {
        String t;
        boolean aliases;
        this._servletContext = this.getServletContext();
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        this._contextHandler = scontext == null ? ((ContextHandler.Context)this._servletContext).getContextHandler() : ContextHandler.getCurrentContext().getContextHandler();
        this._mimeTypes = this._contextHandler.getMimeTypes();
        this._welcomes = this._contextHandler.getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.html", "index.jsp"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        if ("exact".equals(this.getInitParameter("welcomeServlets"))) {
            this._welcomeExactServlets = true;
            this._welcomeServlets = false;
        } else {
            this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        }
        if (this.getInitParameter("aliases") != null) {
            this._contextHandler.setAliases(this.getInitBoolean("aliases", false));
        }
        if (!(aliases = this._contextHandler.isAliases()) && !FileResource.getCheckAliases()) {
            throw new IllegalStateException("Alias checking disabled");
        }
        if (aliases) {
            this._servletContext.log("Aliases are enabled");
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        this._relativeResourceBase = this.getInitParameter("relativeResourceBase");
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            if (this._relativeResourceBase != null) {
                throw new UnavailableException("resourceBase & relativeResourceBase");
            }
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
                throw new UnavailableException(e.toString());
            }
        }
        if ((t = this.getInitParameter("cacheControl")) != null) {
            this._cacheControl = new ByteArrayBuffer(t);
        }
        try {
            String cache_type = this.getInitParameter("cacheType");
            int max_cache_size = this.getInitInt("maxCacheSize", -2);
            int max_cached_file_size = this.getInitInt("maxCachedFileSize", -2);
            int max_cached_files = this.getInitInt("maxCachedFiles", -2);
            if ((cache_type == null || "nio".equals(cache_type) || "both".equals(cache_type)) && (max_cache_size == -2 || max_cache_size > 0)) {
                this._nioCache = new NIOResourceCache(this._mimeTypes);
                this._nioCache.setUseFileMappedBuffer(this._useFileMappedBuffer);
                if (max_cache_size > 0) {
                    this._nioCache.setMaxCacheSize(max_cache_size);
                }
                if (max_cached_file_size >= -1) {
                    this._nioCache.setMaxCachedFileSize(max_cached_file_size);
                }
                if (max_cached_files >= -1) {
                    this._nioCache.setMaxCachedFiles(max_cached_files);
                }
                this._nioCache.start();
            }
            if (("bio".equals(cache_type) || "both".equals(cache_type)) && (max_cache_size == -2 || max_cache_size > 0)) {
                this._bioCache = new ResourceCache(this._mimeTypes);
                if (max_cache_size > 0) {
                    this._bioCache.setMaxCacheSize(max_cache_size);
                }
                if (max_cached_file_size >= -1) {
                    this._bioCache.setMaxCachedFileSize(max_cached_file_size);
                }
                if (max_cached_files >= -1) {
                    this._bioCache.setMaxCachedFiles(max_cached_files);
                }
                this._bioCache.start();
            }
            if (this._nioCache == null) {
                this._bioCache = null;
            }
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            throw new UnavailableException(e.toString());
        }
        this._servletHandler = (ServletHandler)this._contextHandler.getChildHandlerByClass(ServletHandler.class);
        for (ServletHolder h : this._servletHandler.getServlets()) {
            if (h.getServletInstance() != this) continue;
            this._defaultHolder = h;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("resource base = " + this._resourceBase);
        }
    }

    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter("org.eclipse.jetty.servlet.Default." + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = this.getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    @Override
    public Resource getResource(String pathInContext) {
        Resource r = null;
        if (this._relativeResourceBase != null) {
            pathInContext = URIUtil.addPaths(this._relativeResourceBase, pathInContext);
        }
        try {
            if (this._resourceBase != null) {
                r = this._resourceBase.addPath(pathInContext);
            } else {
                URL u = this._servletContext.getResource(pathInContext);
                r = this._contextHandler.newResource(u);
            }
            if (Log.isDebugEnabled()) {
                Log.debug("RESOURCE " + pathInContext + "=" + r);
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block45: {
            String accept;
            String servletPath = null;
            String pathInfo = null;
            Enumeration reqRanges = null;
            Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
            if (included != null && included.booleanValue()) {
                servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (servletPath == null) {
                    servletPath = request.getServletPath();
                    pathInfo = request.getPathInfo();
                }
            } else {
                included = Boolean.FALSE;
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
                reqRanges = request.getHeaders("Range");
                if (!this.hasDefinedRange(reqRanges)) {
                    reqRanges = null;
                }
            }
            String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
            boolean endsWithSlash = pathInContext.endsWith("/");
            String pathInContextGz = null;
            boolean gzip = false;
            if (!included.booleanValue() && this._gzip && reqRanges == null && !endsWithSlash && (accept = request.getHeader("Accept-Encoding")) != null && accept.indexOf("gzip") >= 0) {
                gzip = true;
            }
            Resource resource = null;
            HttpContent content = null;
            Connector connector = HttpConnection.getCurrentConnection().getConnector();
            ResourceCache cache = connector instanceof NIOConnector && !(connector instanceof SslConnector) ? this._nioCache : this._bioCache;
            try {
                if (gzip) {
                    pathInContextGz = pathInContext + ".gz";
                    resource = cache == null ? this.getResource(pathInContextGz) : ((content = cache.lookup(pathInContextGz, this)) != null ? content.getResource() : this.getResource(pathInContextGz));
                    if (resource == null || !resource.exists() || resource.isDirectory()) {
                        String real_path;
                        if (cache != null && content == null && (real_path = this._servletContext.getRealPath(pathInContextGz)) != null) {
                            cache.miss(pathInContextGz, this._contextHandler.newResource(real_path));
                        }
                        gzip = false;
                        pathInContextGz = null;
                    }
                }
                if (!gzip) {
                    resource = cache == null ? this.getResource(pathInContext) : ((content = cache.lookup(pathInContext, this)) != null ? content.getResource() : this.getResource(pathInContext));
                }
                if (Log.isDebugEnabled()) {
                    Log.debug("resource=" + resource + (content != null ? " content" : ""));
                }
                if (resource == null || !resource.exists()) {
                    response.sendError(404);
                    break block45;
                }
                if (!resource.isDirectory()) {
                    if (endsWithSlash && this._contextHandler.isAliases() && pathInContext.length() > 1) {
                        String q = request.getQueryString();
                        pathInContext = pathInContext.substring(0, pathInContext.length() - 1);
                        if (q != null && q.length() != 0) {
                            pathInContext = pathInContext + "?" + q;
                        }
                        response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._servletContext.getContextPath(), pathInContext)));
                    } else {
                        if (content == null) {
                            content = new UnCachedContent(resource);
                        }
                        if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                            if (gzip) {
                                response.setHeader("Content-Encoding", "gzip");
                                String mt = this._servletContext.getMimeType(pathInContext);
                                if (mt != null) {
                                    response.setContentType(mt);
                                }
                            }
                            this.sendData(request, response, included, resource, content, reqRanges);
                        }
                    }
                    break block45;
                }
                String welcome = null;
                if (!endsWithSlash || pathInContext.length() == 1 && request.getAttribute("org.eclipse.jetty.server.nullPathInfo") != null) {
                    StringBuffer buf;
                    StringBuffer stringBuffer = buf = request.getRequestURL();
                    synchronized (stringBuffer) {
                        int param = buf.lastIndexOf(";");
                        if (param < 0) {
                            buf.append('/');
                        } else {
                            buf.insert(param, '/');
                        }
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            buf.append('?');
                            buf.append(q);
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                        break block45;
                    }
                }
                welcome = this.getWelcomeFile(pathInContext);
                if (null != welcome) {
                    if (this._redirectWelcome) {
                        response.setContentLength(0);
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._servletContext.getContextPath(), welcome) + "?" + q));
                        } else {
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._servletContext.getContextPath(), welcome)));
                        }
                    } else {
                        RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                        if (dispatcher != null) {
                            if (included.booleanValue()) {
                                dispatcher.include((ServletRequest)request, (ServletResponse)response);
                            } else {
                                request.setAttribute("org.eclipse.jetty.server.welcome", (Object)welcome);
                                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                            }
                        }
                    }
                } else {
                    content = new UnCachedContent(resource);
                    if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                        this.sendDirectory(request, response, resource, pathInContext);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Log.warn("EXCEPTION ", e);
                if (!response.isCommitted()) {
                    response.sendError(500, e.getMessage());
                }
            }
            finally {
                if (content != null) {
                    content.release();
                } else if (resource != null) {
                    resource.release();
                }
            }
        }
    }

    private boolean hasDefinedRange(Enumeration reqRanges) {
        return reqRanges != null && reqRanges.hasMoreElements();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    private String getWelcomeFile(String pathInContext) throws MalformedURLException, IOException {
        if (this._welcomes == null) {
            return null;
        }
        String welcome_servlet = null;
        for (int i = 0; i < this._welcomes.length; ++i) {
            PathMap.Entry entry;
            String welcome_in_context = URIUtil.addPaths(pathInContext, this._welcomes[i]);
            Resource welcome = this.getResource(welcome_in_context);
            if (welcome != null && welcome.exists()) {
                return this._welcomes[i];
            }
            if (!this._welcomeServlets && !this._welcomeExactServlets || welcome_servlet != null || (entry = this._servletHandler.getHolderEntry(welcome_in_context)) == null || entry.getValue() == this._defaultHolder || !this._welcomeServlets && (!this._welcomeExactServlets || !entry.getKey().equals(welcome_in_context))) continue;
            welcome_servlet = welcome_in_context;
        }
        return welcome_servlet;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, HttpContent content) throws IOException {
        try {
            if (!request.getMethod().equals("HEAD")) {
                long date;
                String ifms = request.getHeader("If-Modified-Since");
                if (ifms != null) {
                    Buffer mdlm;
                    if (content != null && (mdlm = content.getLastModified()) != null && ifms.equals(mdlm.toString())) {
                        response.reset();
                        response.setStatus(304);
                        response.flushBuffer();
                        return false;
                    }
                    long ifmsl = request.getDateHeader("If-Modified-Since");
                    if (ifmsl != -1L && resource.lastModified() / 1000L <= ifmsl / 1000L) {
                        response.reset();
                        response.setStatus(304);
                        response.flushBuffer();
                        return false;
                    }
                }
                if ((date = request.getDateHeader("If-Unmodified-Since")) != -1L && resource.lastModified() / 1000L > date / 1000L) {
                    response.sendError(412);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response.isCommitted()) {
                response.sendError(400, iae.getMessage());
            }
            throw iae;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths(request.getRequestURI(), "/");
        if (this._resourceBase instanceof ResourceCollection) {
            resource = this._resourceBase.addPath(pathInContext);
        } else if (this._contextHandler.getBaseResource() instanceof ResourceCollection) {
            resource = this._contextHandler.getBaseResource().addPath(pathInContext);
        }
        String dir = resource.getListHTML(base, pathInContext.length() > 1);
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, HttpContent content, Enumeration reqRanges) throws IOException {
        long content_length = content == null ? resource.length() : content.getContentLength();
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length < 0L) {
            if (include) {
                resource.writeTo((OutputStream)out, 0L, content_length);
            } else if (out instanceof HttpConnection.Output) {
                if (response instanceof Response) {
                    this.writeOptionHeaders(((Response)response).getHttpFields());
                    ((HttpConnection.Output)((Object)out)).sendContent(content);
                } else if (content.getBuffer() != null) {
                    this.writeHeaders(response, content, content_length);
                    ((HttpConnection.Output)((Object)out)).sendContent(content.getBuffer());
                } else {
                    this.writeHeaders(response, content, content_length);
                    resource.writeTo((OutputStream)out, 0L, content_length);
                }
            } else {
                this.writeHeaders(response, content, content_length);
                resource.writeTo((OutputStream)out, 0L, content_length);
            }
        } else {
            InclusiveByteRange ibr;
            int i;
            List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.writeHeaders(response, content, content_length);
                response.setStatus(416);
                response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, 0L, content_length);
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.writeHeaders(response, content, singleLength);
                response.setStatus(206);
                response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return;
            }
            this.writeHeaders(response, content, -1L);
            String mimetype = content.getContentType().toString();
            MultiPartOutputStream multi = new MultiPartOutputStream((OutputStream)out);
            response.setStatus(206);
            String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            int length = 0;
            String[] header = new String[ranges.size()];
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                header[i] = ibr.toHeaderRangeString(content_length);
                length = (int)((long)length + ((long)((i > 0 ? 2 : 0) + 2 + multi.getBoundary().length() + 2 + "Content-Type".length() + 2 + mimetype.length() + 2 + "Content-Range".length() + 2 + header[i].length() + 2 + 2) + (ibr.getLast(content_length) - ibr.getFirst(content_length)) + 1L));
            }
            response.setContentLength(length += 4 + multi.getBoundary().length() + 2 + 2);
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                multi.startPart(mimetype, new String[]{"Content-Range: " + header[i]});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy(in, multi, size);
                    pos += size;
                    continue;
                }
                resource.writeTo(multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void writeHeaders(HttpServletResponse response, HttpContent content, long count) throws IOException {
        if (content.getContentType() != null && response.getContentType() == null) {
            response.setContentType(content.getContentType().toString());
        }
        if (response instanceof Response) {
            long lml;
            Response r = (Response)response;
            HttpFields fields = r.getHttpFields();
            if (content.getLastModified() != null) {
                fields.put(HttpHeaders.LAST_MODIFIED_BUFFER, content.getLastModified(), content.getResource().lastModified());
            } else if (content.getResource() != null && (lml = content.getResource().lastModified()) != -1L) {
                fields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
            }
            if (count != -1L) {
                r.setLongContentLength(count);
            }
            this.writeOptionHeaders(fields);
        } else {
            long lml = content.getResource().lastModified();
            if (lml >= 0L) {
                response.setDateHeader("Last-Modified", lml);
            }
            if (count != -1L) {
                if (count < Integer.MAX_VALUE) {
                    response.setContentLength((int)count);
                } else {
                    response.setHeader("Content-Length", Long.toString(count));
                }
            }
            this.writeOptionHeaders(response);
        }
    }

    protected void writeOptionHeaders(HttpFields fields) throws IOException {
        if (this._acceptRanges) {
            fields.put(HttpHeaders.ACCEPT_RANGES_BUFFER, HttpHeaderValues.BYTES_BUFFER);
        }
        if (this._cacheControl != null) {
            fields.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
        }
    }

    protected void writeOptionHeaders(HttpServletResponse response) throws IOException {
        if (this._acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
        if (this._cacheControl != null) {
            response.setHeader("Cache-Control", this._cacheControl.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        try {
            if (this._nioCache == null) return;
            this._nioCache.stop();
            return;
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            return;
        }
        finally {
            try {
                if (this._bioCache != null) {
                    this._bioCache.stop();
                }
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
            }
            finally {
                super.destroy();
            }
        }
    }

    private class UnCachedContent
    implements HttpContent {
        Resource _resource;

        UnCachedContent(Resource resource) {
            this._resource = resource;
        }

        @Override
        public Buffer getContentType() {
            return DefaultServlet.this._mimeTypes.getMimeByExtension(this._resource.toString());
        }

        @Override
        public Buffer getLastModified() {
            return null;
        }

        @Override
        public Buffer getBuffer() {
            return null;
        }

        @Override
        public long getContentLength() {
            return this._resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        @Override
        public void release() {
            this._resource.release();
            this._resource = null;
        }
    }
}

