/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.Fragment;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class WebXmlProcessor {
    public static final String WEB_PROCESSOR = "org.eclipse.jetty.webProcessor";
    public static final String METADATA_COMPLETE = "org.eclipse.jetty.metadataComplete";
    public static final String WEBXML_MAJOR_VERSION = "org.eclipse.jetty.webXmlMajorVersion";
    public static final String WEBXML_MINOR_VERSION = "org.eclipse.jetty.webXmlMinorVersion";
    public static final String WEBXML_CLASSNAMES = "org.eclipse.jetty.webXmlClassNames";
    protected WebAppContext _context;
    protected Map<String, Descriptor> _origins = new HashMap<String, Descriptor>();
    protected Descriptor _webDefaultsRoot;
    protected Descriptor _webXmlRoot;
    protected Descriptor _webOverrideRoot;
    protected List<Fragment> _webFragmentRoots = new ArrayList<Fragment>();
    protected Map<String, Fragment> _webFragmentNameMap = new HashMap<String, Fragment>();
    protected List<Fragment> _orderedFragments = new LinkedList<Fragment>();
    protected XmlParser _parser;
    protected Ordering _ordering;
    protected StandardDescriptorProcessor _standardDescriptorProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlParser newParser() throws ClassNotFoundException {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_2.dtd", true);
        URL dtd23 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_3.dtd", true);
        URL j2ee14xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_1_4.xsd", true);
        URL webapp24xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_4.xsd", true);
        URL webapp25xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_5.xsd", true);
        URL webapp30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_3_0.xsd", true);
        URL webcommon30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-common_3_0.xsd", true);
        URL webfragment30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-fragment_3_0.xsd", true);
        URL schemadtd = Loader.getResource(Servlet.class, "javax/servlet/resources/XMLSchema.dtd", true);
        URL xmlxsd = Loader.getResource(Servlet.class, "javax/servlet/resources/xml.xsd", true);
        URL webservice11xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_web_services_client_1_1.xsd", true);
        URL webservice12xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_web_services_client_1_2.xsd", true);
        URL datatypesdtd = Loader.getResource(Servlet.class, "javax/servlet/resources/datatypes.dtd", true);
        URL jsp20xsd = null;
        URL jsp21xsd = null;
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
            jsp20xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_0.xsd");
            jsp21xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_1.xsd");
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        finally {
            if (jsp20xsd == null) {
                jsp20xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_0.xsd", true);
            }
            if (jsp21xsd == null) {
                jsp21xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_1.xsd", true);
            }
        }
        WebXmlProcessor.redirect(xmlParser, "web-app_2_2.dtd", dtd22);
        WebXmlProcessor.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        WebXmlProcessor.redirect(xmlParser, "web.dtd", dtd23);
        WebXmlProcessor.redirect(xmlParser, "web-app_2_3.dtd", dtd23);
        WebXmlProcessor.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        WebXmlProcessor.redirect(xmlParser, "XMLSchema.dtd", schemadtd);
        WebXmlProcessor.redirect(xmlParser, "http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        WebXmlProcessor.redirect(xmlParser, "-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        WebXmlProcessor.redirect(xmlParser, "jsp_2_0.xsd", jsp20xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        WebXmlProcessor.redirect(xmlParser, "j2ee_1_4.xsd", j2ee14xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        WebXmlProcessor.redirect(xmlParser, "web-app_2_4.xsd", webapp24xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        WebXmlProcessor.redirect(xmlParser, "web-app_2_5.xsd", webapp25xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        WebXmlProcessor.redirect(xmlParser, "web-app_3_0.xsd", webapp30xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", webapp30xsd);
        WebXmlProcessor.redirect(xmlParser, "web-common_3_0.xsd", webcommon30xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-common_3_0.xsd", webcommon30xsd);
        WebXmlProcessor.redirect(xmlParser, "web-fragment_3_0.xsd", webfragment30xsd);
        WebXmlProcessor.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", webfragment30xsd);
        WebXmlProcessor.redirect(xmlParser, "xml.xsd", xmlxsd);
        WebXmlProcessor.redirect(xmlParser, "http://www.w3.org/2001/xml.xsd", xmlxsd);
        WebXmlProcessor.redirect(xmlParser, "datatypes.dtd", datatypesdtd);
        WebXmlProcessor.redirect(xmlParser, "http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        WebXmlProcessor.redirect(xmlParser, "j2ee_web_services_client_1_1.xsd", webservice11xsd);
        WebXmlProcessor.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        WebXmlProcessor.redirect(xmlParser, "javaee_web_services_client_1_2.xsd", webservice12xsd);
        WebXmlProcessor.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        return xmlParser;
    }

    protected static void redirect(XmlParser parser, String resource, URL source) {
        if (source != null) {
            parser.redirectEntity(resource, source);
        }
    }

    public WebXmlProcessor(WebAppContext context) throws ClassNotFoundException {
        this._context = context;
        this._parser = WebXmlProcessor.newParser();
    }

    public WebAppContext getContext() {
        return this._context;
    }

    public XmlParser getParser() {
        return this._parser;
    }

    public void parseDefaults(Resource webDefaults) throws Exception {
        this._webDefaultsRoot = new DefaultsDescriptor(webDefaults, this);
        this._webDefaultsRoot.parse();
        if (this._webDefaultsRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new AbsoluteOrdering();
            }
            List<String> order = this._webDefaultsRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void parseWebXml(Resource webXml) throws Exception {
        this._webXmlRoot = new Descriptor(webXml, this);
        this._webXmlRoot.parse();
        this._webXmlRoot.processClassNames();
        if (this._webXmlRoot.getMetaDataComplete() == Descriptor.MetaDataComplete.True) {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.TRUE);
        } else {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.FALSE);
        }
        this._context.getServletContext().setEffectiveMajorVersion(this._webXmlRoot.getMajorVersion());
        this._context.getServletContext().setEffectiveMinorVersion(this._webXmlRoot.getMinorVersion());
        this._context.setAttribute(WEBXML_CLASSNAMES, this._webXmlRoot.getClassNames());
        if (this._webXmlRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new AbsoluteOrdering();
            }
            List<String> order = this._webXmlRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void parseOverride(Resource override) throws Exception {
        this._webOverrideRoot = new OverrideDescriptor(override, this);
        this._webOverrideRoot.setValidating(false);
        this._webOverrideRoot.parse();
        if (this._webOverrideRoot.getMetaDataComplete() == Descriptor.MetaDataComplete.True) {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.TRUE);
        } else if (this._webOverrideRoot.getMetaDataComplete() == Descriptor.MetaDataComplete.False) {
            this._context.setAttribute(METADATA_COMPLETE, Boolean.FALSE);
        }
        if (this._webOverrideRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new AbsoluteOrdering();
            }
            List<String> order = this._webOverrideRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void parseFragment(Resource fragment) throws Exception {
        Boolean metaComplete = (Boolean)this._context.getAttribute(METADATA_COMPLETE);
        if (metaComplete != null && metaComplete.booleanValue()) {
            return;
        }
        Fragment frag = new Fragment(fragment, this);
        frag.parse();
        this._webFragmentRoots.add(frag);
        if (frag.getName() != null) {
            this._webFragmentNameMap.put(frag.getName(), frag);
        }
        if (frag.isOrdered() && frag.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new RelativeOrdering();
            }
            switch (frag.getOtherType()) {
                case None: {
                    ((RelativeOrdering)this._ordering).addNoOthers(frag);
                    break;
                }
                case Before: {
                    ((RelativeOrdering)this._ordering).addBeforeOthers(frag);
                    break;
                }
                case After: {
                    ((RelativeOrdering)this._ordering).addAfterOthers(frag);
                }
            }
        }
    }

    public void orderFragments() {
        if (this._ordering != null) {
            this._orderedFragments = this._ordering.order();
            ArrayList<String> orderedJars = new ArrayList<String>();
            for (Fragment frag : this._orderedFragments) {
                String fullname = frag.getResource().getName();
                int i = fullname.indexOf(".jar");
                int j = fullname.lastIndexOf("/", i);
                orderedJars.add(fullname.substring(j + 1, i + 4));
            }
            this._context.setAttribute("javax.servlet.context.orderedLibs", orderedJars);
        } else {
            this._orderedFragments = this._webFragmentRoots;
        }
    }

    public void processFragments() throws Exception {
        boolean distributable = this._webDefaultsRoot != null && this._webDefaultsRoot.isDistributable() || this._webXmlRoot != null && this._webXmlRoot.isDistributable() || this._webOverrideRoot != null && this._webOverrideRoot.isDistributable();
        for (Fragment frag : this._orderedFragments) {
            this.process(frag);
            distributable = distributable && frag.isDistributable();
        }
        this._context.setDistributable(distributable);
    }

    public Descriptor getWebXml() {
        return this._webXmlRoot;
    }

    public Descriptor getOverrideWeb() {
        return this._webOverrideRoot;
    }

    public Descriptor getWebDefault() {
        return this._webDefaultsRoot;
    }

    public List<Fragment> getFragments() {
        return this._webFragmentRoots;
    }

    public List<Fragment> getOrderedFragments() {
        return this._orderedFragments;
    }

    public Ordering getOrdering() {
        return this._ordering;
    }

    public void setOrdering(Ordering o) {
        this._ordering = o;
    }

    public Fragment getFragment(String name) {
        return this._webFragmentNameMap.get(name);
    }

    public Map<String, Fragment> getNamedFragments() {
        return Collections.unmodifiableMap(this._webFragmentNameMap);
    }

    public void process(Descriptor descriptor) throws Exception {
        if (descriptor != null) {
            this.initStandardDescriptorProcessor();
            this.process(descriptor, this._standardDescriptorProcessor);
        }
    }

    public void process(Descriptor descriptor, DescriptorProcessor processor) throws Exception {
        if (descriptor != null && processor != null) {
            processor.process(descriptor);
        }
    }

    public Origin getOrigin(String name) {
        Descriptor d = this._origins.get(name);
        if (d == null) {
            return Origin.NotSet;
        }
        if (d instanceof Fragment) {
            return Origin.WebFragment;
        }
        if (d instanceof OverrideDescriptor) {
            return Origin.WebOverride;
        }
        if (d instanceof DefaultsDescriptor) {
            return Origin.WebDefaults;
        }
        return Origin.WebXml;
    }

    public Descriptor getOriginDescriptor(String name) {
        return this._origins.get(name);
    }

    public void setOrigin(String name, Descriptor d) {
        this._origins.put(name, d);
    }

    public void initStandardDescriptorProcessor() {
        if (this._standardDescriptorProcessor == null) {
            this._standardDescriptorProcessor = new StandardDescriptorProcessor(this);
        }
    }

    public class RelativeOrdering
    implements Ordering {
        protected LinkedList<String> _beforeOthers = new LinkedList();
        protected LinkedList<String> _afterOthers = new LinkedList();
        protected LinkedList<String> _noOthers = new LinkedList();

        @Override
        public List<Fragment> order() {
            ArrayList<Fragment> orderedList = new ArrayList<Fragment>();
            int maxIterations = 2;
            boolean done = false;
            do {
                done = this.orderList(this._beforeOthers);
                done = this.orderList(this._afterOthers);
            } while (!(done = this.orderList(this._noOthers)) && --maxIterations > 0);
            if (!done) {
                throw new IllegalStateException("Circular references for fragments");
            }
            for (String s : this._beforeOthers) {
                orderedList.add(WebXmlProcessor.this.getFragment(s));
            }
            for (String s : this._noOthers) {
                orderedList.add(WebXmlProcessor.this.getFragment(s));
            }
            for (String s : this._afterOthers) {
                orderedList.add(WebXmlProcessor.this.getFragment(s));
            }
            return orderedList;
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        public void addBeforeOthers(Fragment d) {
            this._beforeOthers.addLast(d.getName());
        }

        public void addAfterOthers(Fragment d) {
            this._afterOthers.addLast(d.getName());
        }

        public void addNoOthers(Fragment d) {
            this._noOthers.addLast(d.getName());
        }

        protected boolean orderList(LinkedList<String> list) {
            boolean noChanges = true;
            ArrayList<String> iterable = new ArrayList<String>(list);
            for (String name : iterable) {
                List<String> afters;
                Fragment f = WebXmlProcessor.this._webFragmentNameMap.get(name);
                if (f == null) {
                    throw new IllegalStateException("No fragment matching name " + name);
                }
                List<String> befores = f.getBefores();
                if (befores != null && !befores.isEmpty()) {
                    for (String b : befores) {
                        if (this.isBefore(list, name, b)) continue;
                        int idx1 = list.indexOf(name);
                        int idx2 = list.indexOf(b);
                        if (idx2 < 0) {
                            this._noOthers.remove(b);
                            this.insert(list, idx1 + 1, b);
                            noChanges = false;
                            continue;
                        }
                        list.remove(name);
                        this.insert(list, idx2, name);
                        noChanges = false;
                    }
                }
                if ((afters = f.getAfters()) == null || afters.isEmpty()) continue;
                for (String a : afters) {
                    if (this.isAfter(list, name, a)) continue;
                    int idx1 = list.indexOf(name);
                    int idx2 = list.indexOf(a);
                    if (idx2 < 0) {
                        this._noOthers.remove(a);
                        this.insert(list, idx1, a);
                        noChanges = false;
                        continue;
                    }
                    list.remove(a);
                    this.insert(list, idx1, a);
                    noChanges = false;
                }
            }
            return noChanges;
        }

        protected boolean isBefore(List<String> list, String a, String b) {
            int idxa = list.indexOf(a);
            int idxb = list.indexOf(b);
            if (idxb >= 0 && idxb < idxa) {
                return false;
            }
            if (idxb < 0) {
                if (list == this._beforeOthers) {
                    return true;
                }
                if (list == this._afterOthers) {
                    if (this._beforeOthers.contains(b)) {
                        throw new IllegalStateException("Incorrect relationship: " + a + " before " + b);
                    }
                    return false;
                }
            }
            return true;
        }

        protected boolean isAfter(List<String> list, String a, String b) {
            int idxa = list.indexOf(a);
            int idxb = list.indexOf(b);
            if (idxb >= 0 && idxa < idxb) {
                return false;
            }
            if (idxb < 0) {
                if (list == this._afterOthers) {
                    return true;
                }
                if (list == this._beforeOthers) {
                    if (this._afterOthers.contains(b)) {
                        throw new IllegalStateException("Incorrect relationship: " + b + " after " + a);
                    }
                    return false;
                }
            }
            return true;
        }

        protected void insert(List<String> list, int index, String element) {
            if (index > list.size()) {
                list.add(element);
            } else {
                list.add(index, element);
            }
        }
    }

    public class AbsoluteOrdering
    implements Ordering {
        public static final String OTHER = "@@-OTHER-@@";
        protected List<String> _order = new ArrayList<String>();
        protected boolean _hasOther = false;

        @Override
        public List<Fragment> order() {
            ArrayList<Fragment> orderedList = new ArrayList<Fragment>();
            HashMap<String, Fragment> others = new HashMap<String, Fragment>(WebXmlProcessor.this.getNamedFragments());
            int index = -1;
            for (String item : this._order) {
                if (!item.equals(OTHER)) {
                    Fragment f = (Fragment)others.remove(item);
                    if (f == null) continue;
                    orderedList.add(f);
                    continue;
                }
                index = orderedList.size();
            }
            orderedList.addAll(index, others.values());
            return orderedList;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        public void add(String name) {
            this._order.add(name);
        }

        public void addOthers() {
            if (this._hasOther) {
                throw new IllegalStateException("Duplicate <other> element in absolute ordering");
            }
            this._hasOther = true;
            this._order.add(OTHER);
        }
    }

    public static interface Ordering {
        public List<Fragment> order();

        public boolean isAbsolute();
    }

    public static enum Origin {
        NotSet,
        WebXml,
        WebDefaults,
        WebOverride,
        WebFragment;

    }
}

