/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebListenerAnnotationHandler
implements AnnotationParser.DiscoverableAnnotationHandler {
    protected WebAppContext _wac;

    public WebListenerAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        Class clazz = null;
        try {
            clazz = Loader.loadClass(null, className);
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz)) {
                EventListener listener = (EventListener)clazz.newInstance();
                this._wac.addEventListener(listener);
            } else {
                Log.warn(clazz.getName() + " does not implement one of the servlet listener interfaces");
            }
        }
        catch (Exception e) {
            Log.warn(e);
            return;
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@WebListener is not applicable to fields: " + className + "." + fieldName);
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@WebListener is not applicable to methods: " + className + "." + methodName + " " + signature);
    }
}

