/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class ResourceAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _wac;
    protected InjectionCollection _injections;

    public ResourceAnnotationHandler(WebAppContext wac) {
        super(true);
        this._wac = wac;
        this._injections = (InjectionCollection)this._wac.getAttribute("org.eclipse.jetty.injectionCollection");
    }

    @Override
    public void doHandle(Class clazz) {
        if (Util.isServletType(clazz)) {
            this.handleClass(clazz);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.handleMethod(clazz, methods[i]);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.handleField(clazz, fields[i]);
            }
        }
    }

    public void handleClass(Class clazz) {
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            String name = resource.name();
            String mappedName = resource.mappedName();
            Resource.AuthenticationType auth = resource.authenticationType();
            Class type = resource.type();
            boolean shareable = resource.shareable();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC(this._wac, name, mappedName) && !NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                Log.warn(e);
            }
        }
    }

    public void handleField(Class clazz, Field field) {
        block14: {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    Log.warn("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be static");
                    return;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    Log.warn("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be final");
                    return;
                }
                String name = clazz.getCanonicalName() + "/" + field.getName();
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> type = field.getType();
                Injection webXmlInjection = this._injections.getInjection(name, clazz, field);
                if (webXmlInjection == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC(this._wac, name, mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            Log.debug("Bound " + (mappedName == null ? name : mappedName) + " as " + name);
                            Injection injection = new Injection();
                            injection.setTarget(clazz, field, type);
                            injection.setJndiName(name);
                            injection.setMappingName(mappedName);
                            this._injections.add(injection);
                        } else if (!Util.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (Util.isEnvEntryType(type)) break block14;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public void handleMethod(Class clazz, Method method) {
        block16: {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource != null) {
                if (Modifier.isStatic(method.getModifiers())) {
                    Log.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": cannot be static");
                    return;
                }
                if (!method.getName().startsWith("set")) {
                    Log.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, does not start with 'set'");
                    return;
                }
                if (method.getParameterTypes().length != 1) {
                    Log.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, not single argument to method");
                    return;
                }
                if (Void.TYPE != method.getReturnType()) {
                    Log.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, not void");
                    return;
                }
                String name = method.getName().substring(3);
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
                name = clazz.getCanonicalName() + "/" + name;
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> paramType = method.getParameterTypes()[0];
                Class resourceType = resource.type();
                Injection webXmlInjection = this._injections.getInjection(name, clazz, method, paramType);
                if (webXmlInjection == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC(this._wac, name, mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            Log.debug("Bound " + (mappedName == null ? name : mappedName) + " as " + name);
                            Injection injection = new Injection();
                            injection.setTarget(clazz, method, paramType, resourceType);
                            injection.setJndiName(name);
                            injection.setMappingName(mappedName);
                            this._injections.add(injection);
                        } else if (!Util.isEnvEntryType(paramType)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (Util.isEnvEntryType(paramType)) break block16;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }
}

