/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.log.Log;

public class HttpExchange {
    public static final int STATUS_START = 0;
    public static final int STATUS_WAITING_FOR_CONNECTION = 1;
    public static final int STATUS_WAITING_FOR_COMMIT = 2;
    public static final int STATUS_SENDING_REQUEST = 3;
    public static final int STATUS_WAITING_FOR_RESPONSE = 4;
    public static final int STATUS_PARSING_HEADERS = 5;
    public static final int STATUS_PARSING_CONTENT = 6;
    public static final int STATUS_COMPLETED = 7;
    public static final int STATUS_EXPIRED = 8;
    public static final int STATUS_EXCEPTED = 9;
    private String _method = "GET";
    private Buffer _scheme = HttpSchemes.HTTP_BUFFER;
    private String _uri;
    private int _version = 11;
    private Address _address;
    private final HttpFields _requestFields = new HttpFields();
    private Buffer _requestContent;
    private InputStream _requestContentSource;
    private volatile int _status = 0;
    private Buffer _requestContentChunk;
    private boolean _retryStatus = false;
    private boolean _configureListeners = true;
    private HttpEventListener _listener = new Listener();
    boolean _onRequestCompleteDone;
    boolean _onResponseCompleteDone;
    boolean _onDone;

    public int getStatus() {
        return this._status;
    }

    public void waitForStatus(int status) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForDone() throws InterruptedException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            while (!this.isDone(this._status)) {
                this.wait();
            }
            return this._status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this._onRequestCompleteDone = false;
            this._onResponseCompleteDone = false;
            this._onDone = false;
            this.setStatus(0);
        }
    }

    void setStatus(int status) {
        this._status = status;
        try {
            switch (status) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.getEventListener().onRequestCommitted();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.getEventListener().onResponseHeaderComplete();
                    break;
                }
                case 7: {
                    this.getEventListener().onResponseComplete();
                    break;
                }
                case 8: {
                    this.getEventListener().onExpire();
                }
            }
        }
        catch (IOException e) {
            Log.warn(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone(int status) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this._onDone;
        }
    }

    public HttpEventListener getEventListener() {
        return this._listener;
    }

    public void setEventListener(HttpEventListener listener) {
        this._listener = listener;
    }

    public void setURL(String url) {
        int port;
        HttpURI uri = new HttpURI(url);
        String scheme = uri.getScheme();
        if (scheme != null) {
            if ("http".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTP_BUFFER);
            } else if ("https".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTPS_BUFFER);
            } else {
                this.setScheme(new ByteArrayBuffer(scheme));
            }
        }
        if ((port = uri.getPort()) <= 0) {
            port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
        this.setAddress(new Address(uri.getHost(), port));
        String completePath = uri.getCompletePath();
        if (completePath == null) {
            completePath = "/";
        }
        this.setURI(completePath);
    }

    public void setAddress(Address address) {
        this._address = address;
    }

    public Address getAddress() {
        return this._address;
    }

    public void setScheme(Buffer scheme) {
        this._scheme = scheme;
    }

    public Buffer getScheme() {
        return this._scheme;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void setVersion(String version) {
        BufferCache.CachedBuffer v = HttpVersions.CACHE.get(version);
        this._version = v == null ? 10 : v.getOrdinal();
    }

    public int getVersion() {
        return this._version;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public String getURI() {
        return this._uri;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public void addRequestHeader(String name, String value) {
        this.getRequestFields().add(name, value);
    }

    public void addRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().add(name, value);
    }

    public void setRequestHeader(String name, String value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestContentType(String value) {
        this.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, value);
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public void setRequestContent(Buffer requestContent) {
        this._requestContent = requestContent;
    }

    public void setRequestContentSource(InputStream stream) {
        this._requestContentSource = stream;
    }

    public InputStream getRequestContentSource() {
        return this._requestContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getRequestContentChunk() throws IOException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this._requestContentChunk == null) {
                this._requestContentChunk = new ByteArrayBuffer(4096);
            } else {
                if (this._requestContentChunk.hasContent()) {
                    throw new IllegalStateException();
                }
                this._requestContentChunk.clear();
            }
            int read = this._requestContentChunk.capacity();
            int length = this._requestContentSource.read(this._requestContentChunk.array(), 0, read);
            if (length >= 0) {
                this._requestContentChunk.setPutIndex(length);
                return this._requestContentChunk;
            }
            return null;
        }
    }

    public Buffer getRequestContent() {
        return this._requestContent;
    }

    public boolean getRetryStatus() {
        return this._retryStatus;
    }

    public void setRetryStatus(boolean retryStatus) {
        this._retryStatus = retryStatus;
    }

    public void cancel() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode() + "=" + this._method + "//" + this._address + this._uri + "#" + this.getStatus();
    }

    protected void onRequestCommitted() throws IOException {
    }

    protected void onRequestComplete() throws IOException {
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
    }

    protected void onResponseHeaderComplete() throws IOException {
    }

    protected void onResponseContent(Buffer content) throws IOException {
    }

    protected void onResponseComplete() throws IOException {
    }

    protected void onConnectionFailed(Throwable x) {
        Log.warn("CONNECTION FAILED " + this, x);
    }

    protected void onException(Throwable x) {
        Log.warn("EXCEPTION " + this, x);
    }

    protected void onExpire() {
        Log.warn("EXPIRED " + this);
    }

    protected void onRetry() throws IOException {
    }

    public boolean configureListeners() {
        return this._configureListeners;
    }

    public void setConfigureListeners(boolean autoConfigure) {
        this._configureListeners = autoConfigure;
    }

    public static class ContentExchange
    extends org.eclipse.jetty.client.ContentExchange {
    }

    public static class CachedExchange
    extends org.eclipse.jetty.client.CachedExchange {
        public CachedExchange(boolean cacheFields) {
            super(cacheFields);
        }
    }

    private class Listener
    implements HttpEventListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionFailed(Throwable ex) {
            try {
                HttpExchange.this.onConnectionFailed(ex);
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onDone = true;
                    HttpExchange.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Throwable ex) {
            try {
                HttpExchange.this.onException(ex);
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onDone = true;
                    HttpExchange.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExpire() {
            try {
                HttpExchange.this.onExpire();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onDone = true;
                    HttpExchange.this.notifyAll();
                }
            }
        }

        public void onRequestCommitted() throws IOException {
            HttpExchange.this.onRequestCommitted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRequestComplete() throws IOException {
            try {
                HttpExchange.this.onRequestComplete();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onRequestCompleteDone = true;
                    HttpExchange.this._onDone = HttpExchange.this._onResponseCompleteDone;
                    HttpExchange.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponseComplete() throws IOException {
            try {
                HttpExchange.this.onResponseComplete();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onResponseCompleteDone = true;
                    HttpExchange.this._onDone = HttpExchange.this._onRequestCompleteDone;
                    HttpExchange.this.notifyAll();
                }
            }
        }

        public void onResponseContent(Buffer content) throws IOException {
            HttpExchange.this.onResponseContent(content);
        }

        public void onResponseHeader(Buffer name, Buffer value) throws IOException {
            HttpExchange.this.onResponseHeader(name, value);
        }

        public void onResponseHeaderComplete() throws IOException {
            HttpExchange.this.onResponseHeaderComplete();
        }

        public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            HttpExchange.this.onResponseStatus(version, status, reason);
        }

        public void onRetry() {
            HttpExchange.this.setRetryStatus(true);
            try {
                HttpExchange.this.onRetry();
            }
            catch (IOException e) {
                Log.debug(e);
            }
        }
    }
}

