/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ProxyServlet
implements Servlet {
    private static Logger __log = Log.getLogger("org.eclipse.jetty.servlets.ProxyServlet");
    HttpClient _client;
    protected HashSet<String> _DontProxyHeaders = new HashSet();
    private ServletConfig config;
    private ServletContext context;

    public ProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
        this._client = new HttpClient();
        this._client.setConnectorType(2);
        try {
            this._client.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        final int debug = __log.isDebugEnabled() ? req.hashCode() : 0;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
        } else {
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            final Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            if (!continuation.isInitial()) {
                response.sendError(504);
            } else {
                String connectionHdr;
                String uri = request.getRequestURI();
                if (request.getQueryString() != null) {
                    uri = uri + "?" + request.getQueryString();
                }
                HttpURI url = this.proxyHttpURI(request.getScheme(), request.getServerName(), request.getServerPort(), uri);
                if (debug != 0) {
                    __log.debug(debug + " proxy " + uri + "-->" + url);
                }
                if (url == null) {
                    response.sendError(403);
                    return;
                }
                HttpExchange exchange = new HttpExchange((OutputStream)out, response){
                    final /* synthetic */ OutputStream val$out;
                    final /* synthetic */ HttpServletResponse val$response;
                    {
                        this.val$out = outputStream;
                        this.val$response = httpServletResponse;
                    }

                    protected void onRequestCommitted() throws IOException {
                    }

                    protected void onRequestComplete() throws IOException {
                    }

                    protected void onResponseComplete() throws IOException {
                        if (debug != 0) {
                            __log.debug(debug + " complete");
                        }
                        continuation.complete();
                    }

                    protected void onResponseContent(Buffer content) throws IOException {
                        if (debug != 0) {
                            __log.debug(debug + " content" + content.length());
                        }
                        content.writeTo(this.val$out);
                    }

                    protected void onResponseHeaderComplete() throws IOException {
                    }

                    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
                        if (debug != 0) {
                            __log.debug(debug + " " + version + " " + status + " " + reason);
                        }
                        if (reason != null && reason.length() > 0) {
                            this.val$response.setStatus(status, reason.toString());
                        } else {
                            this.val$response.setStatus(status);
                        }
                    }

                    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
                        String s = name.toString().toLowerCase();
                        if (!ProxyServlet.this._DontProxyHeaders.contains(s) || HttpHeaders.CONNECTION_BUFFER.equals(name) && HttpHeaderValues.CLOSE_BUFFER.equals(value)) {
                            if (debug != 0) {
                                __log.debug(debug + " " + name + ": " + value);
                            }
                            this.val$response.addHeader(name.toString(), value.toString());
                        } else if (debug != 0) {
                            __log.debug(debug + " " + name + "! " + value);
                        }
                    }

                    protected void onConnectionFailed(Throwable ex) {
                        this.onException(ex);
                    }

                    protected void onException(Throwable ex) {
                        if (ex instanceof EofException) {
                            Log.ignore(ex);
                            return;
                        }
                        Log.warn(ex.toString());
                        Log.debug(ex);
                        if (!this.val$response.isCommitted()) {
                            this.val$response.setStatus(500);
                        }
                        continuation.complete();
                    }

                    protected void onExpire() {
                        if (!this.val$response.isCommitted()) {
                            this.val$response.setStatus(500);
                        }
                        continuation.complete();
                    }
                };
                exchange.setScheme("https".equals(request.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER);
                exchange.setMethod(request.getMethod());
                exchange.setURL(url.toString());
                exchange.setVersion(request.getProtocol());
                if (debug != 0) {
                    __log.debug(debug + " " + request.getMethod() + " " + url + " " + request.getProtocol());
                }
                if ((connectionHdr = request.getHeader("Connection")) != null && (connectionHdr = connectionHdr.toLowerCase()).indexOf("keep-alive") < 0 && connectionHdr.indexOf("close") < 0) {
                    connectionHdr = null;
                }
                boolean xForwardedFor = false;
                boolean hasContent = false;
                long contentLength = -1L;
                Enumeration enm = request.getHeaderNames();
                while (enm.hasMoreElements()) {
                    String hdr = (String)enm.nextElement();
                    String lhdr = hdr.toLowerCase();
                    if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
                    if ("content-type".equals(lhdr)) {
                        hasContent = true;
                    } else if ("content-length".equals(lhdr)) {
                        contentLength = request.getContentLength();
                        exchange.setRequestHeader("Content-Length", TypeUtil.toString(contentLength));
                        if (contentLength > 0L) {
                            hasContent = true;
                        }
                    } else if ("x-forwarded-for".equals(lhdr)) {
                        xForwardedFor = true;
                    }
                    Enumeration vals = request.getHeaders(hdr);
                    while (vals.hasMoreElements()) {
                        String val = (String)vals.nextElement();
                        if (val == null) continue;
                        if (debug != 0) {
                            __log.debug(debug + " " + hdr + ": " + val);
                        }
                        exchange.setRequestHeader(hdr, val);
                    }
                }
                exchange.setRequestHeader("Via", "1.1 (jetty)");
                if (!xForwardedFor) {
                    exchange.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
                }
                if (hasContent) {
                    exchange.setRequestContentSource((InputStream)in);
                }
                continuation.suspend((ServletResponse)response);
                this._client.send(exchange);
            }
        }
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String port = "";
        String host = "";
        int c = uri.indexOf(58);
        if (c >= 0) {
            port = uri.substring(c + 1);
            host = uri.substring(0, c);
            if (host.indexOf(47) > 0) {
                host = host.substring(host.indexOf(47) + 1);
            }
        }
        InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        Socket socket = new Socket(inetAddress.getAddress(), inetAddress.getPort());
        response.setStatus(200);
        response.setHeader("Connection", "close");
        response.flushBuffer();
        IO.copyThread(socket.getInputStream(), (OutputStream)out);
        IO.copy((InputStream)in, socket.getOutputStream());
    }

    protected HttpURI proxyHttpURI(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        return new HttpURI(scheme + "://" + serverName + ":" + serverPort + uri);
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    public void destroy() {
    }

    public static class Transparent
    extends ProxyServlet {
        String _prefix;
        String _proxyTo;

        public Transparent() {
        }

        public Transparent(String prefix, String server, int port) {
            this._prefix = prefix;
            this._proxyTo = "http://" + server + ":" + port;
        }

        public void init(ServletConfig config) throws ServletException {
            if (config.getInitParameter("ProxyTo") != null) {
                this._proxyTo = config.getInitParameter("ProxyTo");
            }
            if (config.getInitParameter("Prefix") != null) {
                this._prefix = config.getInitParameter("Prefix");
            }
            if (this._proxyTo == null) {
                throw new UnavailableException("No ProxyTo");
            }
            super.init(config);
            config.getServletContext().log("Transparent AsyncProxyServlet @ " + (this._prefix == null ? "-" : this._prefix) + " to " + this._proxyTo);
        }

        protected HttpURI proxyHttpURI(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
            if (this._prefix != null && !uri.startsWith(this._prefix)) {
                return null;
            }
            if (this._prefix != null) {
                return new HttpURI(this._proxyTo + uri.substring(this._prefix.length()));
            }
            return new HttpURI(this._proxyTo + uri);
        }
    }
}

