/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameInformationPopup;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class RenameLinkedMode {
    private static RenameLinkedMode fgActiveLinkedMode;
    private final CompilationUnitEditor fEditor;
    private final IJavaElement fJavaElement;
    private RenameInformationPopup fInfoPopup;
    private boolean fOriginalSaved;
    private Point fOriginalSelection;
    private String fOriginalName;
    private LinkedPosition fNamePosition;
    private LinkedModeModel fLinkedModeModel;
    private LinkedPositionGroup fLinkedPositionGroup;
    private final FocusEditingSupport fFocusEditingSupport;
    private boolean fShowPreview;

    public RenameLinkedMode(IJavaElement element, CompilationUnitEditor editor) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fJavaElement = element;
        this.fFocusEditingSupport = new FocusEditingSupport();
    }

    public static RenameLinkedMode getActiveLinkedMode() {
        if (fgActiveLinkedMode != null) {
            StyledText textWidget;
            ISourceViewer viewer = RenameLinkedMode.fgActiveLinkedMode.fEditor.getViewer();
            if (viewer != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                return fgActiveLinkedMode;
            }
            fgActiveLinkedMode = null;
        }
        return null;
    }

    public void start() {
        if (RenameLinkedMode.getActiveLinkedMode() != null) {
            fgActiveLinkedMode.startFullDialog();
            return;
        }
        this.fOriginalSaved = !this.fEditor.isDirty();
        ISourceViewer viewer = this.fEditor.getViewer();
        IDocument document = viewer.getDocument();
        this.fOriginalSelection = viewer.getSelectedRange();
        int offset = this.fOriginalSelection.x;
        try {
            CompilationUnit root = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.getCompilationUnit(), ASTProvider.WAIT_YES, null);
            this.fLinkedPositionGroup = new LinkedPositionGroup();
            ASTNode selectedNode = NodeFinder.perform((ASTNode)root, this.fOriginalSelection.x, this.fOriginalSelection.y);
            if (!(selectedNode instanceof SimpleName)) {
                return;
            }
            SimpleName nameNode = (SimpleName)selectedNode;
            this.fOriginalName = nameNode.getIdentifier();
            final int pos = nameNode.getStartPosition();
            SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)root, nameNode);
            Arrays.sort(sameNodes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return this.rank((ASTNode)o1) - this.rank((ASTNode)o2);
                }

                private int rank(ASTNode node) {
                    int relativeRank = node.getStartPosition() + node.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            int i = 0;
            while (i < sameNodes.length) {
                SimpleName elem = sameNodes[i];
                LinkedPosition linkedPosition = new LinkedPosition(document, elem.getStartPosition(), elem.getLength(), i);
                if (i == 0) {
                    this.fNamePosition = linkedPosition;
                }
                this.fLinkedPositionGroup.addPosition(linkedPosition);
                ++i;
            }
            this.fLinkedModeModel = new LinkedModeModel();
            this.fLinkedModeModel.addGroup(this.fLinkedPositionGroup);
            this.fLinkedModeModel.forceInstall();
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fEditor));
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI ui = new EditorLinkedModeUI(this.fLinkedModeModel, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, offset, 0, Integer.MAX_VALUE);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            ui.enter();
            viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
            if (viewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
                registry.register((IEditingSupport)this.fFocusEditingSupport);
            }
            this.openSecondaryPopup();
            fgActiveLinkedMode = this;
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doRename(boolean showPreview) {
        this.cancel();
        Image image = null;
        Label label = null;
        this.fShowPreview |= showPreview;
        try {
            boolean executed;
            String newName;
            SourceViewer sourceViewer;
            Control viewerControl;
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer instanceof SourceViewer && (viewerControl = (sourceViewer = (SourceViewer)viewer).getControl()) instanceof Composite) {
                Point size;
                Composite composite = (Composite)viewerControl;
                Display display = composite.getDisplay();
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
                GC gc = new GC((Drawable)composite);
                try {
                    size = composite.getSize();
                    image = new Image(gc.getDevice(), size.x, size.y);
                    gc.copyArea(image, 0, 0);
                }
                finally {
                    gc.dispose();
                    gc = null;
                }
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBounds(0, 0, size.x, size.y);
                label.moveAbove(null);
            }
            if (this.fOriginalName.equals(newName = this.fNamePosition.getContent())) {
                return;
            }
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport == null) {
                return;
            }
            Shell shell = this.fEditor.getSite().getShell();
            if (this.fShowPreview) {
                executed = renameSupport.openDialog(shell, true);
            } else {
                renameSupport.perform(shell, (IRunnableContext)this.fEditor.getSite().getWorkbenchWindow());
                executed = true;
            }
            if (executed) {
                this.restoreFullSelection();
            }
            JavaModelUtil.reconcile(this.getCompilationUnit());
            return;
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException ex) {
            JavaPlugin.log(ex);
            return;
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            return;
        }
        finally {
            if (label != null) {
                label.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    public void cancel() {
        if (this.fLinkedModeModel != null) {
            this.fLinkedModeModel.exit(0);
        }
        this.linkedModeLeft();
    }

    private void restoreFullSelection() {
        if (this.fOriginalSelection.y != 0) {
            int originalOffset = this.fOriginalSelection.x;
            LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
            int i = 0;
            while (i < positions.length) {
                LinkedPosition position = positions[i];
                if (!position.isDeleted() && position.includes(originalOffset)) {
                    this.fEditor.getViewer().setSelectedRange(position.offset, position.length);
                    return;
                }
                ++i;
            }
        }
    }

    private RenameSupport undoAndCreateRenameSupport(String newName) throws CoreException {
        ISourceViewer viewer = this.fEditor.getViewer();
        final IDocument document = viewer.getDocument();
        try {
            try {
                if (!this.fOriginalName.equals(newName)) {
                    this.fEditor.getSite().getWorkbenchWindow().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            LinkedPosition[] positions = RenameLinkedMode.this.fLinkedPositionGroup.getPositions();
                            Arrays.sort(positions, new Comparator(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public int compare(Object o1, Object o2) {
                                    return ((LinkedPosition)o1).offset - ((LinkedPosition)o2).offset;
                                }
                            });
                            int correction = 0;
                            int originalLength = RenameLinkedMode.this.fOriginalName.length();
                            int i = 0;
                            while (i < positions.length) {
                                LinkedPosition position = positions[i];
                                try {
                                    int length = position.getLength();
                                    document.replace(position.getOffset() + correction, length, RenameLinkedMode.this.fOriginalName);
                                    correction = correction - length + originalLength;
                                }
                                catch (BadLocationException e) {
                                    throw new InvocationTargetException(e);
                                }
                                ++i;
                            }
                            if (RenameLinkedMode.this.fOriginalSaved) {
                                RenameLinkedMode.this.fEditor.doSave(monitor);
                            }
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), ReorgMessages.RenameLinkedMode_error_saving_editor, (Throwable)e));
            }
            catch (InterruptedException interruptedException) {
                JavaModelUtil.reconcile(this.getCompilationUnit());
                return null;
            }
        }
        finally {
            JavaModelUtil.reconcile(this.getCompilationUnit());
        }
        viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
        RenameJavaElementDescriptor descriptor = this.createRenameDescriptor(this.fJavaElement, newName);
        RenameSupport renameSupport = RenameSupport.create(descriptor);
        return renameSupport;
    }

    private ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
    }

    public void startFullDialog() {
        this.cancel();
        try {
            String newName = this.fNamePosition.getContent();
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport != null) {
                renameSupport.openDialog(this.fEditor.getSite().getShell());
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private RenameJavaElementDescriptor createRenameDescriptor(IJavaElement javaElement, String newName) throws JavaModelException {
        IDialogSettings javaSettings;
        IDialogSettings refactoringSettings;
        String contributionId;
        int elementType = javaElement.getElementType();
        switch (elementType) {
            case 2: {
                contributionId = "org.eclipse.jdt.ui.rename.java.project";
                break;
            }
            case 3: {
                contributionId = "org.eclipse.jdt.ui.rename.source.folder";
                break;
            }
            case 4: {
                contributionId = "org.eclipse.jdt.ui.rename.package";
                break;
            }
            case 5: {
                contributionId = "org.eclipse.jdt.ui.rename.compilationunit";
                break;
            }
            case 7: {
                contributionId = "org.eclipse.jdt.ui.rename.type";
                break;
            }
            case 9: {
                IMethod method = (IMethod)javaElement;
                if (method.isConstructor()) {
                    return this.createRenameDescriptor((IJavaElement)method.getDeclaringType(), newName);
                }
                contributionId = "org.eclipse.jdt.ui.rename.method";
                break;
            }
            case 8: {
                IField field = (IField)javaElement;
                if (field.isEnumConstant()) {
                    contributionId = "org.eclipse.jdt.ui.rename.enum.constant";
                    break;
                }
                contributionId = "org.eclipse.jdt.ui.rename.field";
                break;
            }
            case 15: {
                contributionId = "org.eclipse.jdt.ui.rename.type.parameter";
                break;
            }
            case 14: {
                contributionId = "org.eclipse.jdt.ui.rename.local.variable";
                break;
            }
            default: {
                return null;
            }
        }
        RenameJavaElementDescriptor descriptor = (RenameJavaElementDescriptor)RefactoringCore.getRefactoringContribution((String)contributionId).createDescriptor();
        descriptor.setJavaElement(javaElement);
        descriptor.setNewName(newName);
        if (elementType != 3) {
            descriptor.setUpdateReferences(true);
        }
        if ((refactoringSettings = (javaSettings = JavaPlugin.getDefault().getDialogSettings()).getSection("org.eclipse.ltk.ui.refactoring.settings")) == null) {
            refactoringSettings = javaSettings.addNewSection("org.eclipse.ltk.ui.refactoring.settings");
        }
        switch (elementType) {
            case 8: 
            case 9: {
                descriptor.setDeprecateDelegate(refactoringSettings.getBoolean("delegateDeprecation"));
                descriptor.setKeepOriginal(refactoringSettings.getBoolean("delegateUpdating"));
            }
        }
        switch (elementType) {
            case 7: {
                int strategy;
                descriptor.setUpdateSimilarDeclarations(refactoringSettings.getBoolean("updateSimilarElements"));
                try {
                    strategy = refactoringSettings.getInt("updateSimilarElementsMatchStrategy");
                }
                catch (NumberFormatException numberFormatException) {
                    strategy = 1;
                }
                descriptor.setMatchStrategy(strategy);
            }
        }
        switch (elementType) {
            case 4: {
                descriptor.setUpdateHierarchy(refactoringSettings.getBoolean("renameSubpackages"));
            }
        }
        switch (elementType) {
            case 4: 
            case 7: {
                String fileNamePatterns = refactoringSettings.get("patterns");
                if (fileNamePatterns == null || fileNamePatterns.length() == 0) break;
                descriptor.setFileNamePatterns(fileNamePatterns);
                boolean updateQualifiedNames = refactoringSettings.getBoolean("updateQualifiedNames");
                descriptor.setUpdateQualifiedNames(updateQualifiedNames);
                this.fShowPreview |= updateQualifiedNames;
            }
        }
        switch (elementType) {
            case 4: 
            case 7: 
            case 8: {
                boolean updateTextualOccurrences = refactoringSettings.getBoolean("updateTextualMatches");
                descriptor.setUpdateTextualOccurrences(updateTextualOccurrences);
                this.fShowPreview |= updateTextualOccurrences;
            }
        }
        switch (elementType) {
            case 8: {
                descriptor.setRenameGetters(refactoringSettings.getBoolean("renameGetter"));
                descriptor.setRenameSetters(refactoringSettings.getBoolean("renameSetter"));
            }
        }
        return descriptor;
    }

    private void linkedModeLeft() {
        ISourceViewer viewer;
        fgActiveLinkedMode = null;
        if (this.fInfoPopup != null) {
            this.fInfoPopup.close();
        }
        if ((viewer = this.fEditor.getViewer()) instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister((IEditingSupport)this.fFocusEditingSupport);
        }
    }

    private void openSecondaryPopup() {
        this.fInfoPopup = new RenameInformationPopup(this.fEditor, this);
        this.fInfoPopup.open();
    }

    public boolean isCaretInLinkedPosition() {
        return this.getCurrentLinkedPosition() != null;
    }

    public LinkedPosition getCurrentLinkedPosition() {
        Point selection = this.fEditor.getViewer().getSelectedRange();
        int start = selection.x;
        int end = start + selection.y;
        LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
        int i = 0;
        while (i < positions.length) {
            LinkedPosition position = positions[i];
            if (position.includes(start) && position.includes(end)) {
                return position;
            }
            ++i;
        }
        return null;
    }

    public boolean isEnabled() {
        String newName;
        block3: {
            try {
                newName = this.fNamePosition.getContent();
                if (!this.fOriginalName.equals(newName)) break block3;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        IJavaProject project = this.fJavaElement.getJavaProject();
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateIdentifier((String)newName, (String)sourceLevel, (String)complianceLevel).isOK();
    }

    public boolean isOriginalName() {
        try {
            String newName = this.fNamePosition.getContent();
            return this.fOriginalName.equals(newName);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private class EditorSynchronizer
    implements ILinkedModeListener {
        private EditorSynchronizer() {
        }

        public void left(LinkedModeModel model, int flags) {
            RenameLinkedMode.this.linkedModeLeft();
            if ((flags & 2) != 0) {
                RenameLinkedMode.this.doRename(RenameLinkedMode.this.fShowPreview);
            }
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        public void suspend(LinkedModeModel model) {
        }
    }

    private class ExitPolicy
    extends LinkedNamesAssistProposal.DeleteBlockingExitPolicy {
        public ExitPolicy(IDocument document) {
            super(document);
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            RenameLinkedMode renameLinkedMode = RenameLinkedMode.this;
            renameLinkedMode.fShowPreview = renameLinkedMode.fShowPreview | (event.stateMask & 0x40000) != 0;
            return super.doExit(model, event, offset, length);
        }
    }

    private class FocusEditingSupport
    implements IEditingSupport {
        private FocusEditingSupport() {
        }

        public boolean ownsFocusShell() {
            Shell activeShell;
            if (RenameLinkedMode.this.fInfoPopup == null) {
                return false;
            }
            if (RenameLinkedMode.this.fInfoPopup.ownsFocusShell()) {
                return true;
            }
            Shell editorShell = RenameLinkedMode.this.fEditor.getSite().getShell();
            return editorShell == (activeShell = editorShell.getDisplay().getActiveShell());
        }

        public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
            return false;
        }
    }
}

