/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class SourceAttachmentPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private SourceAttachmentBlock fSourceAttachmentBlock;
    private IPackageFragmentRoot fRoot;
    private IPath fContainerPath;
    private IClasspathEntry fEntry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.source_attachment_property_page_context");
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Control result = this.createPageContent(composite);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createPageContent(Composite composite) {
        try {
            this.fContainerPath = null;
            this.fEntry = null;
            this.fRoot = this.getJARPackageFragmentRoot();
            if (this.fRoot == null || this.fRoot.getKind() != 2) {
                return this.createMessageContent(composite, PreferencesMessages.SourceAttachmentPropertyPage_noarchive_message);
            }
            IPath containerPath = null;
            IJavaProject jproject = this.fRoot.getJavaProject();
            IClasspathEntry entry = this.fRoot.getRawClasspathEntry();
            if (entry == null) {
                entry = JavaCore.newLibraryEntry((IPath)this.fRoot.getPath(), null, null);
            } else if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
                if (initializer == null || container == null) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_invalid_container, containerPath.toString()));
                }
                String containerName = container.getDescription();
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, jproject);
                if (status.getCode() == 1) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_not_supported, containerName));
                }
                if (status.getCode() == 2) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_read_only, containerName));
                }
                entry = JavaModelUtil.findEntryInContainer(container, this.fRoot.getPath());
                Assert.isNotNull((Object)entry);
            }
            this.fContainerPath = containerPath;
            this.fEntry = entry;
            this.fSourceAttachmentBlock = new SourceAttachmentBlock(this, entry);
            return this.fSourceAttachmentBlock.createControl(composite);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return this.createMessageContent(composite, PreferencesMessages.SourceAttachmentPropertyPage_noarchive_message);
        }
    }

    private Control createMessageContent(Composite composite, String message) {
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        GridData gd = new GridData(256);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        Label label = new Label(inner, 16448);
        label.setText(message);
        label.setLayoutData((Object)gd);
        return inner;
    }

    public boolean performOk() {
        if (this.fSourceAttachmentBlock != null) {
            IClasspathEntry entry;
            block5: {
                entry = this.fSourceAttachmentBlock.getNewEntry();
                if (!entry.equals(this.fEntry)) break block5;
                return true;
            }
            try {
                IRunnableWithProgress runnable = SourceAttachmentBlock.getRunnable(this.getShell(), entry, this.fRoot.getJavaProject(), this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.SourceAttachmentPropertyPage_error_title;
                String message = PreferencesMessages.SourceAttachmentPropertyPage_error_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    protected void performDefaults() {
        if (this.fSourceAttachmentBlock != null) {
            this.fSourceAttachmentBlock.setDefaults();
        }
        super.performDefaults();
    }

    private IPackageFragmentRoot getJARPackageFragmentRoot() throws CoreException {
        IProject proj;
        IResource resource;
        IJavaElement elem;
        IAdaptable adaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)elem;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) instanceof IFile && (proj = resource.getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject jproject = JavaCore.create((IProject)proj);
            return jproject.getPackageFragmentRoot(resource);
        }
        return null;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

