/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class RenameModifications
extends RefactoringModifications {
    private List fRename = new ArrayList();
    private List fRenameArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void rename(IResource resource, RenameArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void rename(IJavaProject project, RenameArguments args) {
        this.add(project, (RefactoringArguments)args, null);
        IProject rProject = project.getProject();
        if (rProject != null) {
            this.getResourceModifications().addRename((IResource)rProject, args);
            IProject[] referencingProjects = rProject.getReferencingProjects();
            int i = 0;
            while (i < referencingProjects.length) {
                IFile classpath = this.getClasspathFile((IResource)referencingProjects[i]);
                if (classpath != null) {
                    this.getResourceModifications().addChanged(classpath);
                }
                ++i;
            }
        }
    }

    public void rename(IPackageFragmentRoot sourceFolder, RenameArguments arguments) {
        this.add(sourceFolder, (RefactoringArguments)arguments, null);
        if (sourceFolder.getResource() != null) {
            this.getResourceModifications().addRename(sourceFolder.getResource(), arguments);
        }
    }

    public void rename(IPackageFragment rootPackage, RenameArguments args, boolean renameSubPackages) throws CoreException {
        IContainer container;
        this.add(rootPackage, (RefactoringArguments)args, null);
        IPackageFragment[] allSubPackages = null;
        if (renameSubPackages) {
            allSubPackages = this.getSubpackages(rootPackage);
            int i = 0;
            while (i < allSubPackages.length) {
                IPackageFragment pack = allSubPackages[i];
                RenameArguments subArgs = new RenameArguments(this.getNewPackageName(rootPackage, args.getNewName(), pack.getElementName()), args.getUpdateReferences());
                this.add(pack, (RefactoringArguments)subArgs, null);
                ++i;
            }
        }
        if ((container = (IContainer)rootPackage.getResource()) == null) {
            return;
        }
        IContainer target = (IContainer)((IPackageFragmentRoot)rootPackage.getParent()).getPackageFragment(args.getNewName()).getResource();
        if ((!rootPackage.hasSubpackages() || renameSubPackages) && this.canMove(container, target)) {
            this.createIncludingParents(target.getParent());
            if (container.getParent().equals((Object)target.getParent())) {
                this.getResourceModifications().addRename((IResource)container, new RenameArguments(target.getName(), args.getUpdateReferences()));
            } else {
                try {
                    this.getResourceModifications().ignoreForDelta();
                    this.addAllResourceModifications(rootPackage, args, renameSubPackages, allSubPackages);
                }
                finally {
                    this.getResourceModifications().trackForDelta();
                }
                this.getResourceModifications().addDelta(new ResourceModifications.MoveDescription((IResource)container, target.getFullPath()));
            }
        } else {
            this.addAllResourceModifications(rootPackage, args, renameSubPackages, allSubPackages);
        }
    }

    public void rename(ICompilationUnit unit, RenameArguments args) {
        this.add(unit, (RefactoringArguments)args, null);
        if (unit.getResource() != null) {
            this.getResourceModifications().addRename(unit.getResource(), new RenameArguments(args.getNewName(), args.getUpdateReferences()));
        }
    }

    public void rename(IType type, RenameTypeArguments args, IParticipantDescriptorFilter filter) {
        this.add(type, (RefactoringArguments)args, filter);
    }

    public void rename(IField field, RenameArguments args) {
        this.add(field, (RefactoringArguments)args, null);
    }

    public void rename(IMethod method, RenameArguments args) {
        this.add(method, (RefactoringArguments)args, null);
    }

    public void rename(ILocalVariable variable, RenameArguments args) {
        this.add(variable, (RefactoringArguments)args, null);
    }

    public void rename(ITypeParameter typeParameter, RenameArguments arguments) {
        this.add(typeParameter, (RefactoringArguments)arguments, null);
    }

    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fRename.size()) {
            Object element = this.fRename.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildMoveDelta(builder, (IResource)element, (RenameArguments)this.fRenameArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    public void buildValidateEdits(ValidateEditChecker checker) {
        Iterator iter = this.fRename.iterator();
        while (iter.hasNext()) {
            ICompilationUnit unit;
            IResource resource;
            Object element = iter.next();
            if (!(element instanceof ICompilationUnit) || (resource = (unit = (ICompilationUnit)element).getResource()) == null || resource.getType() != 1) continue;
            checker.addFile((IFile)resource);
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.fRename.size()) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, this.fRename.get(i), (RenameArguments)((RenameArguments)this.fRenameArguments.get(i)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i)), (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fRename.add(element);
        this.fRenameArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }

    private void addAllResourceModifications(IPackageFragment rootPackage, RenameArguments args, boolean renameSubPackages, IPackageFragment[] allSubPackages) throws CoreException {
        this.addResourceModifications(rootPackage, args, rootPackage, renameSubPackages);
        if (renameSubPackages) {
            int i = 0;
            while (i < allSubPackages.length) {
                IPackageFragment pack = allSubPackages[i];
                this.addResourceModifications(rootPackage, args, pack, renameSubPackages);
                ++i;
            }
        }
    }

    private void addResourceModifications(IPackageFragment rootPackage, RenameArguments args, IPackageFragment pack, boolean renameSubPackages) throws CoreException {
        IContainer container = (IContainer)pack.getResource();
        if (container == null) {
            return;
        }
        IFolder target = this.computeTargetFolder(rootPackage, args, pack);
        this.createIncludingParents((IContainer)target);
        MoveArguments arguments = new MoveArguments((Object)target, args.getUpdateReferences());
        IResource[] resourcesToMove = this.collectResourcesOfInterest(pack);
        HashSet<IResource> allMembers = new HashSet<IResource>(Arrays.asList(container.members()));
        int i = 0;
        while (i < resourcesToMove.length) {
            IResource toMove = resourcesToMove[i];
            this.getResourceModifications().addMove(toMove, arguments);
            allMembers.remove(toMove);
            ++i;
        }
        Iterator iter = allMembers.iterator();
        while (iter.hasNext()) {
            IResource element = (IResource)iter.next();
            if (!(element instanceof IFile)) continue;
            this.getResourceModifications().addDelete(element);
            iter.remove();
        }
        if (renameSubPackages && rootPackage.equals(pack) || !renameSubPackages && allMembers.isEmpty()) {
            this.getResourceModifications().addDelete((IResource)container);
        }
    }

    private boolean canMove(IContainer source, IContainer target) {
        return !target.exists() && !source.getFullPath().isPrefixOf(target.getFullPath());
    }

    private IPackageFragment[] getSubpackages(IPackageFragment pack) throws CoreException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IJavaElement[] allPackages = root.getChildren();
        if (pack.isDefaultPackage()) {
            return new IPackageFragment[0];
        }
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        String prefix = String.valueOf(pack.getElementName()) + '.';
        int i = 0;
        while (i < allPackages.length) {
            IPackageFragment currentPackage = (IPackageFragment)allPackages[i];
            if (currentPackage.getElementName().startsWith(prefix)) {
                result.add(currentPackage);
            }
            ++i;
        }
        return result.toArray(new IPackageFragment[result.size()]);
    }

    private IFolder computeTargetFolder(IPackageFragment rootPackage, RenameArguments args, IPackageFragment pack) {
        IPath path = pack.getParent().getPath();
        path = path.append(this.getNewPackageName(rootPackage, args.getNewName(), pack.getElementName()).replace('.', '/'));
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        return target;
    }

    private String getNewPackageName(IPackageFragment rootPackage, String newPackageName, String oldSubPackageName) {
        String oldPackageName = rootPackage.getElementName();
        return String.valueOf(newPackageName) + oldSubPackageName.substring(oldPackageName.length());
    }
}

