/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.fix.LinkedFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.SerialVersionDefaultOperation;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionHashOperation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class PotentialProgrammingProblemsFix
extends LinkedFix {
    private static final String SERIALIZABLE_NAME = "java.io.Serializable";
    private static final String NAME_FIELD = "serialVersionUID";
    private static ISerialVersionFixContext fCurrentContext;

    public static IFix[] createMissingSerialVersionFixes(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (problem.getProblemId() != 0x20000060) {
            return null;
        }
        ICompilationUnit unit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (unit == null) {
            return null;
        }
        SimpleName simpleName = PotentialProgrammingProblemsFix.getSelectedName(compilationUnit, problem);
        if (simpleName == null) {
            return null;
        }
        ASTNode declaringNode = PotentialProgrammingProblemsFix.getDeclarationNode(simpleName);
        if (declaringNode == null) {
            return null;
        }
        SerialVersionDefaultOperation defop = new SerialVersionDefaultOperation(unit, new ASTNode[]{declaringNode});
        PotentialProgrammingProblemsFix fix1 = new PotentialProgrammingProblemsFix(FixMessages.Java50Fix_SerialVersion_default_description, compilationUnit, new IFixRewriteOperation[]{defop});
        SerialVersionHashOperation hashop = new SerialVersionHashOperation(unit, new ASTNode[]{declaringNode});
        PotentialProgrammingProblemsFix fix2 = new PotentialProgrammingProblemsFix(FixMessages.Java50Fix_SerialVersion_hash_description, compilationUnit, new IFixRewriteOperation[]{hashop});
        return new IFix[]{fix1, fix2};
    }

    public static RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor, boolean calculatedId, boolean defaultId, boolean randomId) throws CoreException {
        if (defaultId) {
            fCurrentContext = new ISerialVersionFixContext(){

                public long getSerialVersionId(String qualifiedName) {
                    return 1L;
                }

                public RefactoringStatus initialize(IProgressMonitor pm) throws CoreException {
                    return new RefactoringStatus();
                }

                public boolean hasSerialVersionId(String qualifiedName) {
                    return true;
                }
            };
            return fCurrentContext.initialize(monitor);
        }
        if (randomId) {
            fCurrentContext = new ISerialVersionFixContext(){
                private Random rng;

                public long getSerialVersionId(String qualifiedName) {
                    return this.rng.nextLong();
                }

                public RefactoringStatus initialize(IProgressMonitor pm) throws CoreException {
                    this.rng = new Random(new Date().getTime());
                    return new RefactoringStatus();
                }

                public boolean hasSerialVersionId(String qualifiedName) {
                    return true;
                }
            };
            return fCurrentContext.initialize(monitor);
        }
        if (calculatedId) {
            fCurrentContext = new SerialVersionHashContext(project, compilationUnits);
            return fCurrentContext.initialize(monitor);
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.done();
        }
        fCurrentContext = null;
        return new RefactoringStatus();
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean addSerialVersionIds) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, locations, addSerialVersionIds);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addSerialVersionIds) {
        if (addSerialVersionIds) {
            ICompilationUnit unit = (ICompilationUnit)compilationUnit.getJavaElement();
            if (unit == null) {
                return null;
            }
            ArrayList<ASTNode> declarationNodes = new ArrayList<ASTNode>();
            int i = 0;
            while (i < problems.length) {
                ASTNode declarationNode;
                SimpleName simpleName;
                if (problems[i].getProblemId() == 0x20000060 && (simpleName = PotentialProgrammingProblemsFix.getSelectedName(compilationUnit, problems[i])) != null && (declarationNode = PotentialProgrammingProblemsFix.getDeclarationNode(simpleName)) != null) {
                    declarationNodes.add(declarationNode);
                }
                ++i;
            }
            if (declarationNodes.size() == 0) {
                return null;
            }
            Iterator iter = declarationNodes.iterator();
            while (iter.hasNext()) {
                ASTNode declarationNode = (ASTNode)iter.next();
                if (!fCurrentContext.hasSerialVersionId(PotentialProgrammingProblemsFix.getQualifiedName(declarationNode))) continue;
                SerialVersionHashBatchOperation op = new SerialVersionHashBatchOperation(unit, declarationNodes.toArray(new ASTNode[declarationNodes.size()]), fCurrentContext);
                return new PotentialProgrammingProblemsFix(FixMessages.PotentialProgrammingProblemsFix_add_id_change_name, compilationUnit, new IFixRewriteOperation[]{op});
            }
        }
        return null;
    }

    private static SimpleName getSelectedName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selection = problem.getCoveredNode(compilationUnit);
        if (selection == null) {
            return null;
        }
        Name name = null;
        if (selection instanceof SimpleType) {
            SimpleType type = (SimpleType)selection;
            name = type.getName();
        } else if (selection instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)selection;
            Type raw = type.getType();
            if (raw instanceof SimpleType) {
                name = ((SimpleType)raw).getName();
            } else if (raw instanceof QualifiedType) {
                name = ((QualifiedType)raw).getName();
            }
        } else if (selection instanceof Name) {
            name = (Name)selection;
        }
        if (name == null) {
            return null;
        }
        if (name.isSimpleName()) {
            return (SimpleName)name;
        }
        return ((QualifiedName)name).getName();
    }

    private static ASTNode getDeclarationNode(SimpleName name) {
        ASTNode parent = name.getParent();
        if (!(parent instanceof AbstractTypeDeclaration)) {
            if ((parent = parent.getParent()) instanceof ParameterizedType || parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                parent = creation.getAnonymousClassDeclaration();
            }
        }
        return parent;
    }

    private static String getQualifiedName(ASTNode parent) {
        ITypeBinding binding = null;
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            binding = declaration.resolveBinding();
        } else if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            ClassInstanceCreation creation = (ClassInstanceCreation)declaration.getParent();
            binding = creation.resolveTypeBinding();
        } else if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            binding = type.resolveBinding();
        }
        if (binding != null) {
            return binding.getBinaryName();
        }
        return null;
    }

    protected PotentialProgrammingProblemsFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static interface ISerialVersionFixContext {
        public RefactoringStatus initialize(IProgressMonitor var1) throws CoreException;

        public boolean hasSerialVersionId(String var1);

        public long getSerialVersionId(String var1);
    }

    private static class SerialVersionHashBatchOperation
    extends AbstractSerialVersionOperation {
        private final ISerialVersionFixContext fContext;

        protected SerialVersionHashBatchOperation(ICompilationUnit unit, ASTNode[] node, ISerialVersionFixContext context) {
            super(unit, node);
            this.fContext = context;
        }

        protected boolean addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) throws CoreException {
            String qualifiedName = PotentialProgrammingProblemsFix.getQualifiedName(declarationNode);
            if (!this.fContext.hasSerialVersionId(qualifiedName)) {
                return false;
            }
            long id = this.fContext.getSerialVersionId(qualifiedName);
            fragment.setInitializer((Expression)fragment.getAST().newNumberLiteral(String.valueOf(id) + "L"));
            return true;
        }

        protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModel positionGroups) {
        }
    }

    private static class SerialVersionHashContext
    implements ISerialVersionFixContext {
        private final IJavaProject fProject;
        private final ICompilationUnit[] fCompilationUnits;
        private final Hashtable fIdsTable;

        public SerialVersionHashContext(IJavaProject project, ICompilationUnit[] compilationUnits) {
            this.fProject = project;
            this.fCompilationUnits = compilationUnits;
            this.fIdsTable = new Hashtable();
        }

        public RefactoringStatus initialize(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", 3);
            IType[] types = this.findTypesWithMissingUID(this.fProject, this.fCompilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (types.length == 0) {
                return new RefactoringStatus();
            }
            RefactoringStatus result = new RefactoringStatus();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(this.fProject);
            IBinding[] bindings = parser.createBindings((IJavaElement[])types, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<String> qualifiedNames = new ArrayList<String>();
            int i = 0;
            while (i < bindings.length) {
                ITypeBinding binding = (ITypeBinding)bindings[i];
                if (binding != null && binding.getBinaryName() != null) {
                    qualifiedNames.add(binding.getBinaryName());
                } else {
                    IType type = types[i];
                    result.addWarning(Messages.format(FixMessages.PotentialProgrammingProblemsFix_calculatingUIDFailed_binding, types[i].getFullyQualifiedName()), new RefactoringStatusContext(this, type){
                        final /* synthetic */ SerialVersionHashContext this$1;
                        private final /* synthetic */ IType val$type;
                        {
                            this.this$1 = serialVersionHashContext;
                            this.val$type = iType;
                        }

                        public Object getCorrespondingElement() {
                            return this.val$type;
                        }
                    });
                }
                ++i;
            }
            if (qualifiedNames.size() == 0) {
                return result;
            }
            try {
                String[] names = qualifiedNames.toArray(new String[qualifiedNames.size()]);
                long[] ids = SerialVersionHashOperation.calculateSerialVersionIds(names, this.fProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                int i2 = 0;
                while (i2 < ids.length) {
                    if (ids[i2] != 0L) {
                        this.fIdsTable.put(names[i2], new Long(ids[i2]));
                    } else {
                        result.addWarning(Messages.format(FixMessages.PotentialProgrammingProblemsFix_calculatingUIDFailed_unknown, names[i2]));
                    }
                    ++i2;
                }
            }
            catch (IOException e) {
                return this.createWarning(e);
            }
            catch (CoreException ce) {
                return this.createWarning((Exception)((Object)ce));
            }
            return result;
        }

        private RefactoringStatus createWarning(Exception e) {
            RefactoringStatus result = new RefactoringStatus();
            result.addWarning(Messages.format(FixMessages.PotentialProgrammingProblemsFix_calculatingUIDFailed_exception, new String[]{this.fProject.getElementName(), e.getLocalizedMessage()}), new RefactoringStatusContext(this){
                final /* synthetic */ SerialVersionHashContext this$1;
                {
                    this.this$1 = serialVersionHashContext;
                }

                public Object getCorrespondingElement() {
                    return SerialVersionHashContext.access$0(this.this$1);
                }
            });
            return result;
        }

        public boolean hasSerialVersionId(String qualifiedName) {
            if (qualifiedName == null) {
                return false;
            }
            Long id = (Long)this.fIdsTable.get(qualifiedName);
            return id != null;
        }

        public long getSerialVersionId(String qualifiedName) {
            return (Long)this.fIdsTable.get(qualifiedName);
        }

        private IType[] findTypesWithMissingUID(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
            try {
                monitor.beginTask("", compilationUnits.length);
                IType serializable = project.findType(PotentialProgrammingProblemsFix.SERIALIZABLE_NAME);
                ArrayList types = new ArrayList();
                if (compilationUnits.length > 500) {
                    HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
                    int i = 0;
                    while (i < compilationUnits.length) {
                        cus.add(compilationUnits[i]);
                        ++i;
                    }
                    monitor.subTask(Messages.format(FixMessages.Java50Fix_SerialVersion_CalculateHierarchy_description, PotentialProgrammingProblemsFix.SERIALIZABLE_NAME));
                    ITypeHierarchy hierarchy1 = serializable.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length));
                    IType[] allSubtypes1 = hierarchy1.getAllSubtypes(serializable);
                    this.addTypes(allSubtypes1, cus, types);
                } else {
                    monitor.subTask(FixMessages.Java50Fix_InitializeSerialVersionId_subtask_description);
                    int i = 0;
                    while (i < compilationUnits.length) {
                        this.collectChildrenWithMissingSerialVersionId(compilationUnits[i].getChildren(), serializable, types);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        ++i;
                    }
                }
                IType[] iTypeArray = types.toArray(new IType[types.size()]);
                return iTypeArray;
            }
            finally {
                monitor.done();
            }
        }

        private void addTypes(IType[] allSubtypes, HashSet cus, List types) throws JavaModelException {
            int i = 0;
            while (i < allSubtypes.length) {
                IType type = allSubtypes[i];
                IField field = type.getField(PotentialProgrammingProblemsFix.NAME_FIELD);
                if (!field.exists() && type.isClass() && cus.contains(type.getCompilationUnit())) {
                    types.add(type);
                }
                ++i;
            }
        }

        private void collectChildrenWithMissingSerialVersionId(IJavaElement[] children, IType serializable, List result) throws JavaModelException {
            int i = 0;
            while (i < children.length) {
                IJavaElement child = children[i];
                if (child instanceof IType) {
                    IField field;
                    IType type = (IType)child;
                    if (type.isClass() && !(field = type.getField(PotentialProgrammingProblemsFix.NAME_FIELD)).exists()) {
                        ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        IType[] interfaces = hierarchy.getAllSuperInterfaces(type);
                        int j = 0;
                        while (j < interfaces.length) {
                            if (interfaces[j].equals(serializable)) {
                                result.add(type);
                                break;
                            }
                            ++j;
                        }
                    }
                    this.collectChildrenWithMissingSerialVersionId(type.getChildren(), serializable, result);
                } else if (child instanceof IMethod) {
                    this.collectChildrenWithMissingSerialVersionId(((IMethod)child).getChildren(), serializable, result);
                } else if (child instanceof IField) {
                    this.collectChildrenWithMissingSerialVersionId(((IField)child).getChildren(), serializable, result);
                }
                ++i;
            }
        }

        static /* synthetic */ IJavaProject access$0(SerialVersionHashContext serialVersionHashContext) {
            return serialVersionHashContext.fProject;
        }
    }
}

