/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.unittest.junit.ui.OpenEditorAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.unittest.model.ITestRunSession;

public class OpenEditorAtLineAction
extends OpenEditorAction {
    private int fLineNumber;

    public OpenEditorAtLineAction(Shell shell, String className, int line, ITestRunSession session) {
        super(shell, className, session);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.unittest.junit.open_editor_atline_action_context");
        this.fLineNumber = line;
    }

    @Override
    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.fLineNumber - 1), document.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected IJavaElement findElement(IJavaProject project, String className) throws CoreException {
        return this.findType(project, className);
    }
}

