/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.jdt.ui.unittest.junit.ui.JUnitMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.unittest.model.ITestRunSession;

public abstract class OpenEditorAction
extends Action {
    protected final Shell shell;
    protected final ITestRunSession testSession;
    protected String fClassName;
    private final boolean fActivate;

    protected OpenEditorAction(Shell shell, String testClassName, ITestRunSession session) {
        this(shell, testClassName, true, session);
    }

    public OpenEditorAction(Shell shell, String className, boolean activate, ITestRunSession session) {
        super(JUnitMessages.OpenEditorAction_action_label);
        this.fClassName = className;
        this.shell = shell;
        this.fActivate = activate;
        this.testSession = session;
    }

    public void run() {
        IEditorPart editor = null;
        try {
            IJavaElement element = this.findElement(JUnitLaunchConfigurationConstants.getJavaProject((ILaunchConfiguration)this.testSession.getLaunch().getLaunchConfiguration()), this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)JUnitMessages.OpenEditorAction_error_cannotopen_title, (String)JUnitMessages.OpenEditorAction_error_cannotopen_message);
                return;
            }
            editor = JavaUI.openInEditor((IJavaElement)element, (boolean)this.fActivate, (boolean)false);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JUnitMessages.OpenEditorAction_error_dialog_title, (String)JUnitMessages.OpenEditorAction_error_dialog_message, (IStatus)e.getStatus());
            return;
        }
        if (!(editor instanceof ITextEditor)) {
            MessageDialog.openError((Shell)this.getShell(), (String)JUnitMessages.OpenEditorAction_error_dialog_title, (String)JUnitMessages.OpenEditorAction_error_dialog_message);
            return;
        }
        this.reveal((ITextEditor)editor);
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected abstract IJavaElement findElement(IJavaProject var1, String var2) throws CoreException;

    protected abstract void reveal(ITextEditor var1);

    protected final IType findType(IJavaProject project, String className) {
        final IType[] result = new IType[1];
        String dottedName = className.replace('$', '.');
        if (project == null) {
            return null;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    iTypeArray[0] = this.internalFindType(project, dottedName, new HashSet<IJavaProject>(), monitor);
                    if (result[0] == null) {
                        int lastDot = dottedName.lastIndexOf(46);
                        TypeNameMatchRequestor nameMatchRequestor = new TypeNameMatchRequestor(){

                            public void acceptTypeNameMatch(TypeNameMatch match) {
                                result[0] = match.getType();
                            }
                        };
                        new SearchEngine().searchAllTypeNames(lastDot >= 0 ? dottedName.substring(0, lastDot).toCharArray() : null, 8, (lastDot >= 0 ? dottedName.substring(lastDot + 1) : dottedName).toCharArray(), 8, 0, SearchEngine.createWorkspaceScope(), nameMatchRequestor, 3, monitor);
                    }
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            JUnitTestPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result[0];
    }

    private IType internalFindType(IJavaProject project, String className, Set<IJavaProject> visitedProjects, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (visitedProjects.contains(project)) {
                return null;
            }
            monitor.beginTask("", 2);
            IType type = project.findType(className, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            if (type != null) {
                IType iType = type;
                return iType;
            }
            visitedProjects.add(project);
            IJavaModel javaModel = project.getJavaModel();
            String[] requiredProjectNames = project.getRequiredProjectNames();
            SubMonitor reqMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            reqMonitor.beginTask("", requiredProjectNames.length);
            String[] stringArray = requiredProjectNames;
            int n = requiredProjectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredProjectName = stringArray[n2];
                IJavaProject requiredProject = javaModel.getJavaProject(requiredProjectName);
                if (requiredProject.exists() && (type = this.internalFindType(requiredProject, className, visitedProjects, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)reqMonitor, (int)1))) != null) {
                    IType iType = type;
                    return iType;
                }
                ++n2;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }
}

