/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.launcher;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

class JUnitTestKindUtil {
    public static final String JUNIT3_TEST_KIND_ID = "org.eclipse.jdt.ui.unittest.junit.loader.junit3";
    public static final String JUNIT4_TEST_KIND_ID = "org.eclipse.jdt.ui.unittest.junit.loader.junit4";
    public static final String JUNIT5_TEST_KIND_ID = "org.eclipse.jdt.ui.unittest.junit.loader.junit5";

    private JUnitTestKindUtil() {
    }

    public static String getContainerTestKindId(IJavaElement element) {
        if (element != null) {
            IJavaProject project = element.getJavaProject();
            if (JUnitTestKindUtil.isRunWithJUnitPlatform(element)) {
                return JUNIT4_TEST_KIND_ID;
            }
            if (CoreTestSearchEngine.hasJUnit5TestAnnotation((IJavaProject)project)) {
                return JUNIT5_TEST_KIND_ID;
            }
            if (CoreTestSearchEngine.hasJUnit4TestAnnotation((IJavaProject)project)) {
                return JUNIT4_TEST_KIND_ID;
            }
        }
        return JUNIT3_TEST_KIND_ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunWithJUnitPlatform(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            element = ((ICompilationUnit)element).findPrimaryType();
        }
        if (!(element instanceof IType)) return false;
        IType type = (IType)element;
        try {
            IMemberValuePair[] memberValuePairs;
            IAnnotation runWithAnnotation = type.getAnnotation("RunWith");
            if (!runWithAnnotation.exists()) {
                runWithAnnotation = type.getAnnotation("org.junit.runner.RunWith");
            }
            if (!runWithAnnotation.exists()) return false;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = runWithAnnotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if (memberValuePair.getMemberName().equals("value") && memberValuePair.getValue().equals("JUnitPlatform")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }
}

