/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.launcher;

import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitMigrationDelegate;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.jdt.ui.unittest.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.ui.unittest.junit.launcher.JUnitLaunchIncludeExcludeTagsDialog;
import org.eclipse.jdt.ui.unittest.junit.launcher.Messages;
import org.eclipse.jdt.ui.unittest.junit.ui.BasicElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.unittest.ui.ConfigureViewerSupport;
import org.osgi.framework.Bundle;

public class JUnitLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Label fProjLabel;
    private Text fProjText;
    private Button fProjButton;
    private Button fKeepRunning;
    private Text fTestText;
    private Button fSearchButton;
    private final Image fTestIcon = JUnitLaunchConfigurationTab.createImage("obj16/test.svg");
    private String fOriginalTestMethodName;
    private Label fTestMethodLabel;
    private Text fTestMethodText;
    private Button fTestMethodSearchButton;
    private Text fContainerText;
    private IJavaElement fContainerElement;
    private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider();
    private Button fContainerSearchButton;
    private Button fTestContainerRadioButton;
    private Button fTestRadioButton;
    private Label fTestLabel;
    private Label fIncludeExcludeTagsLabel;
    private Button fIncludeExcludeTagsButton;
    private ComboViewer fTestLoaderViewer;
    private ILaunchConfiguration fLaunchConfiguration;
    private boolean fIsValid = true;
    private Set<String> fMethodsCache;
    private String fMethodsCacheKey;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        this.createSingleTestSection(comp);
        this.createSpacer(comp);
        this.createTestContainerSelectionGroup(comp);
        this.createSpacer(comp);
        this.createTagsGroup(comp);
        this.createSpacer(comp);
        this.createTestLoaderGroup(comp);
        this.createSpacer(comp);
        this.createKeepAliveGroup(comp);
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.unittest.junit.launch_configuration_dialog_junit_main_tab");
        this.validatePage();
    }

    private void createTagsGroup(Composite comp) {
        this.fIncludeExcludeTagsLabel = new Label(comp, 0);
        this.fIncludeExcludeTagsLabel.setText(Messages.JUnitLaunchConfigurationTab_addtag_text);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fIncludeExcludeTagsLabel.setLayoutData((Object)gd);
        this.fIncludeExcludeTagsButton = new Button(comp, 8);
        this.fIncludeExcludeTagsButton.setText(Messages.JUnitLaunchConfigurationTab_addtag_label);
        this.fIncludeExcludeTagsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JUnitLaunchConfigurationTab.this.configureIncludeExcludeTags();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fIncludeExcludeTagsButton.setLayoutData((Object)gd);
    }

    private void createTestLoaderGroup(Composite comp) {
        Label loaderLabel = new Label(comp, 0);
        loaderLabel.setText(Messages.JUnitLaunchConfigurationTab_Test_Loader);
        GridData gd = new GridData();
        gd.horizontalIndent = 0;
        loaderLabel.setLayoutData((Object)gd);
        this.fTestLoaderViewer = new ComboViewer(comp, 12);
        this.fTestLoaderViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.fTestLoaderViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTestLoaderViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((JUnitTestPlugin.JUnitVersion)((Object)element)).toString();
            }
        });
        this.fTestLoaderViewer.setInput((Object)JUnitTestPlugin.JUnitVersion.values());
        this.fTestLoaderViewer.addSelectionChangedListener(event -> {
            this.setEnableTagsGroup(event);
            this.validatePage();
            this.updateLaunchConfigurationDialog();
        });
    }

    private void setEnableTagsGroup(SelectionChangedEvent event) {
        Object first;
        IStructuredSelection ss;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (first = ss.getFirstElement()) instanceof JUnitTestPlugin.JUnitVersion) {
            JUnitTestPlugin.JUnitVersion junitVersion = (JUnitTestPlugin.JUnitVersion)((Object)first);
            this.fIncludeExcludeTagsButton.setEnabled(junitVersion == JUnitTestPlugin.JUnitVersion.JUNIT5 || junitVersion == JUnitTestPlugin.JUnitVersion.JUNIT6);
        }
    }

    private void createSpacer(Composite comp) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    private void createSingleTestSection(Composite comp) {
        this.fTestRadioButton = new Button(comp, 16);
        this.fTestRadioButton.setText(Messages.JUnitLaunchConfigurationTab_label_oneTest);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fTestRadioButton.setLayoutData((Object)gd);
        this.fTestRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JUnitLaunchConfigurationTab.this.fTestRadioButton.getSelection()) {
                    JUnitLaunchConfigurationTab.this.testModeChanged();
                }
            }
        });
        this.fProjLabel = new Label(comp, 0);
        this.fProjLabel.setText(Messages.JUnitLaunchConfigurationTab_label_project);
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(comp, 2052);
        this.fProjText.setLayoutData((Object)new GridData(768));
        this.fProjText.addModifyListener(evt -> {
            this.validatePage();
            this.updateLaunchConfigurationDialog();
            this.fSearchButton.setEnabled(this.fTestRadioButton.getSelection() && this.fProjText.getText().length() > 0);
        });
        this.fProjButton = new Button(comp, 8);
        this.fProjButton.setText(Messages.JUnitLaunchConfigurationTab_label_browse);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitLaunchConfigurationTab.this.handleProjectButtonSelected();
            }
        });
        this.setButtonGridData(this.fProjButton);
        this.fTestLabel = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fTestLabel.setLayoutData((Object)gd);
        this.fTestLabel.setText(Messages.JUnitLaunchConfigurationTab_label_test);
        this.fTestText = new Text(comp, 2052);
        this.fTestText.setLayoutData((Object)new GridData(768));
        this.fTestText.addModifyListener(evt -> {
            this.fTestMethodSearchButton.setEnabled(this.fTestText.getText().length() > 0);
            this.validatePage();
            this.updateLaunchConfigurationDialog();
        });
        this.fSearchButton = new Button(comp, 8);
        this.fSearchButton.setEnabled(this.fProjText.getText().length() > 0);
        this.fSearchButton.setText(Messages.JUnitLaunchConfigurationTab_label_search);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitLaunchConfigurationTab.this.handleSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fSearchButton);
        this.fTestMethodLabel = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fTestMethodLabel.setLayoutData((Object)gd);
        this.fTestMethodLabel.setText(Messages.JUnitLaunchConfigurationTab_label_method);
        this.fTestMethodText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fTestMethodText.setLayoutData((Object)gd);
        this.fTestMethodText.addModifyListener(evt -> {
            this.validatePage();
            this.updateLaunchConfigurationDialog();
        });
        this.fTestMethodText.setMessage(Messages.JUnitLaunchConfigurationTab_all_methods_text);
        this.fTestMethodSearchButton = new Button(comp, 8);
        this.fTestMethodSearchButton.setEnabled(this.fTestText.getText().length() > 0);
        this.fTestMethodSearchButton.setText(Messages.JUnitLaunchConfigurationTab_label_search_method);
        this.fTestMethodSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitLaunchConfigurationTab.this.handleTestMethodSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fTestMethodSearchButton);
    }

    private void createTestContainerSelectionGroup(Composite comp) {
        this.fTestContainerRadioButton = new Button(comp, 16);
        this.fTestContainerRadioButton.setText(Messages.JUnitLaunchConfigurationTab_label_containerTest);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fTestContainerRadioButton.setLayoutData((Object)gd);
        this.fTestContainerRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.fTestContainerRadioButton.getSelection()) {
                this.testModeChanged();
            }
        }));
        this.fContainerText = new Text(comp, 2060);
        SWTUtil.fixReadonlyTextBackground((Text)this.fContainerText);
        gd = new GridData(768);
        gd.horizontalIndent = 25;
        gd.horizontalSpan = 2;
        this.fContainerText.setLayoutData((Object)gd);
        this.fContainerText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
        this.fContainerSearchButton = new Button(comp, 8);
        this.fContainerSearchButton.setText(Messages.JUnitLaunchConfigurationTab_label_search);
        this.fContainerSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitLaunchConfigurationTab.this.handleContainerSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fContainerSearchButton);
    }

    private void handleContainerSearchButtonSelected() {
        IJavaElement javaElement = this.chooseContainer(this.fContainerElement);
        if (javaElement != null) {
            this.setContainerElement(javaElement);
        }
    }

    private void setContainerElement(IJavaElement javaElement) {
        this.fContainerElement = javaElement;
        this.fContainerText.setText(this.getPresentationName(javaElement));
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private void createKeepAliveGroup(Composite comp) {
        this.fKeepRunning = new Button(comp, 32);
        this.fKeepRunning.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.fKeepRunning.setText(Messages.JUnitLaunchConfigurationTab_label_keeprunning);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.fKeepRunning.setLayoutData((Object)gd);
    }

    private static Image createImage(String path) {
        URL url = FileLocator.find((Bundle)JUnitTestPlugin.getDefault().getBundle(), (IPath)new Path("icons/full/" + path));
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
        this.updateProjectFromConfig(config);
        String containerHandle = "";
        try {
            containerHandle = config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (containerHandle.length() > 0) {
            this.updateTestContainerFromConfig(config);
        } else {
            this.updateTestTypeFromConfig(config);
        }
        this.updateKeepRunning(config);
        this.updateTestLoaderFromConfig(config);
        this.validatePage();
    }

    private void updateTestLoaderFromConfig(ILaunchConfiguration config) {
        JUnitTestPlugin.JUnitVersion junitVersion = JUnitLaunchConfigurationDelegate.getJUnitVersion(config);
        if (junitVersion == null) {
            if (this.fContainerElement != null) {
                junitVersion = JUnitTestPlugin.getJUnitVersion(this.fContainerElement);
            }
            if (junitVersion == null) {
                junitVersion = JUnitTestPlugin.JUnitVersion.JUNIT3;
            }
        }
        this.fTestLoaderViewer.setSelection((ISelection)new StructuredSelection((Object)junitVersion));
    }

    private JUnitTestPlugin.JUnitVersion getSelectedJUnitVersion() {
        IStructuredSelection selection = (IStructuredSelection)this.fTestLoaderViewer.getSelection();
        return (JUnitTestPlugin.JUnitVersion)((Object)selection.getFirstElement());
    }

    private void updateKeepRunning(ILaunchConfiguration config) {
        boolean running = false;
        try {
            running = config.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fKeepRunning.setSelection(running);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fProjText.setText(projectName);
    }

    private void updateTestTypeFromConfig(ILaunchConfiguration config) {
        String testTypeName = "";
        this.fOriginalTestMethodName = "";
        try {
            testTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            this.fOriginalTestMethodName = config.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fTestRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(true);
        this.setEnableContainerTestGroup(false);
        this.fTestContainerRadioButton.setSelection(false);
        this.fTestText.setText(testTypeName);
        this.fContainerText.setText("");
        this.fTestMethodText.setText(this.fOriginalTestMethodName);
    }

    private void updateTestContainerFromConfig(ILaunchConfiguration config) {
        String containerHandle = "";
        IJavaElement containerElement = null;
        try {
            containerHandle = config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            if (containerHandle.length() > 0) {
                containerElement = JavaCore.create((String)containerHandle);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (containerElement != null) {
            this.fContainerElement = containerElement;
        }
        this.fTestContainerRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(false);
        this.setEnableContainerTestGroup(true);
        this.fTestRadioButton.setSelection(false);
        if (this.fContainerElement != null) {
            this.fContainerText.setText(this.getPresentationName(this.fContainerElement));
        }
        this.fTestText.setText("");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.fTestContainerRadioButton.getSelection() && this.fContainerElement != null) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fContainerElement.getJavaProject().getElementName());
            config.setAttribute("org.eclipse.jdt.junit.CONTAINER", this.fContainerElement.getHandleIdentifier());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            config.setAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fTestText.getText());
            config.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            config.setAttribute("org.eclipse.jdt.junit.TESTNAME", this.fTestMethodText.getText());
        }
        new ConfigureViewerSupport("org.eclipse.jdt.ui.unittest.junit").apply(config);
        config.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", this.fKeepRunning.getSelection());
        try {
            this.mapResources(config);
        }
        catch (CoreException e) {
            JUnitTestPlugin.log(e.getStatus());
        }
        IStructuredSelection junitVersionSelection = (IStructuredSelection)this.fTestLoaderViewer.getSelection();
        if (!junitVersionSelection.isEmpty()) {
            JUnitTestPlugin.JUnitVersion junitVersion = (JUnitTestPlugin.JUnitVersion)((Object)junitVersionSelection.getFirstElement());
            config.setAttribute("org.eclipse.jdt.junit.TEST_KIND", junitVersion.getJUnitTestKind().getId());
        }
    }

    private void mapResources(ILaunchConfigurationWorkingCopy config) throws CoreException {
        JUnitMigrationDelegate.mapResources((ILaunchConfigurationWorkingCopy)config);
    }

    public void dispose() {
        super.dispose();
        this.fTestIcon.dispose();
        this.fJavaElementLabelProvider.dispose();
    }

    public Image getImage() {
        return this.fTestIcon;
    }

    private void handleSearchButtonSelected() {
        Set types;
        Shell shell = this.getShell();
        IJavaProject javaProject = this.getJavaProject();
        boolean[] radioSetting = new boolean[2];
        try {
            try {
                radioSetting[0] = this.fTestRadioButton.getSelection();
                radioSetting[1] = this.fTestContainerRadioButton.getSelection();
                types = TestSearchEngine.findTests((IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaElement)javaProject, (ITestKind)this.getSelectedJUnitVersion().getJUnitTestKind());
            }
            catch (InterruptedException e) {
                this.setErrorMessage(e.getMessage());
                this.fTestRadioButton.setSelection(radioSetting[0]);
                this.fTestContainerRadioButton.setSelection(radioSetting[1]);
                return;
            }
            catch (InvocationTargetException e) {
                JUnitTestPlugin.log(e.getTargetException());
                this.fTestRadioButton.setSelection(radioSetting[0]);
                this.fTestContainerRadioButton.setSelection(radioSetting[1]);
                return;
            }
        }
        finally {
            this.fTestRadioButton.setSelection(radioSetting[0]);
            this.fTestContainerRadioButton.setSelection(radioSetting[1]);
        }
        final HashSet<CallSite> typeLookup = new HashSet<CallSite>();
        for (IType type : types) {
            typeLookup.add((CallSite)((Object)(type.getPackageFragment().getElementName() + "/" + type.getTypeQualifiedName('.'))));
        }
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (int)1), (int)256, (boolean)false, (String)"**", (TypeSelectionExtension)new TypeSelectionExtension(){

                public ITypeInfoFilterExtension getFilterExtension() {
                    return requestor -> {
                        StringBuilder buf = new StringBuilder();
                        buf.append(requestor.getPackageName()).append('/');
                        String enclosingName = requestor.getEnclosingName();
                        if (enclosingName.length() > 0) {
                            buf.append(enclosingName).append('.');
                        }
                        buf.append(requestor.getTypeName());
                        return typeLookup.contains(buf.toString());
                    };
                }
            });
        }
        catch (JavaModelException e) {
            JUnitTestPlugin.log(e);
            return;
        }
        dialog.setTitle(Messages.JUnitLaunchConfigurationTab_testdialog_title);
        dialog.setMessage(Messages.JUnitLaunchConfigurationTab_testdialog_message);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fTestText.setText(type.getFullyQualifiedName('.'));
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    private void handleTestMethodSearchButtonSelected() {
        try {
            IJavaProject javaProject = this.getJavaProject();
            IType testType = javaProject.findType(this.fTestText.getText());
            Set<String> methodNames = this.getMethodsForType(javaProject, testType, this.getSelectedJUnitVersion());
            String methodName = this.chooseMethodName(methodNames);
            if (methodName != null) {
                this.fTestMethodText.setText(methodName);
                this.validatePage();
                this.updateLaunchConfigurationDialog();
            }
        }
        catch (JavaModelException e) {
            JUnitTestPlugin.log(e.getStatus());
        }
    }

    private Set<String> getMethodsForType(IJavaProject javaProject, IType type, JUnitTestPlugin.JUnitVersion junitVersion) throws JavaModelException {
        ITestKind testKind = junitVersion.getJUnitTestKind();
        if (javaProject == null || type == null || testKind == null) {
            return Collections.emptySet();
        }
        String methodsCacheKey = javaProject.getElementName() + "\n" + type.getFullyQualifiedName() + "\n" + testKind.getId();
        if (methodsCacheKey.equals(this.fMethodsCacheKey)) {
            return this.fMethodsCache;
        }
        HashSet<String> methodNames = new HashSet<String>();
        this.fMethodsCache = methodNames;
        this.fMethodsCacheKey = methodsCacheKey;
        this.collectMethodNames(type, javaProject, junitVersion, methodNames);
        return methodNames;
    }

    private void collectMethodNames(IType type, IJavaProject javaProject, JUnitTestPlugin.JUnitVersion junitVersion, Set<String> methodNames) throws JavaModelException {
        String[] superInterfaceNames;
        if (type == null) {
            return;
        }
        this.collectDeclaredMethodNames(type, javaProject, junitVersion, methodNames);
        String superclassName = type.getSuperclassName();
        IType superType = this.getResolvedType(superclassName, type, javaProject);
        this.collectMethodNames(superType, javaProject, junitVersion, methodNames);
        String[] stringArray = superInterfaceNames = type.getSuperInterfaceNames();
        int n = superInterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            superType = this.getResolvedType(interfaceName, type, javaProject);
            this.collectMethodNames(superType, javaProject, junitVersion, methodNames);
            ++n2;
        }
    }

    private IType getResolvedType(String typeName, IType type, IJavaProject javaProject) throws JavaModelException {
        IType resolvedType = null;
        if (typeName != null) {
            String[][] resolvedTypeNames;
            int pos = typeName.indexOf(60);
            if (pos != -1) {
                typeName = typeName.substring(0, pos);
            }
            if ((resolvedTypeNames = type.resolveType(typeName)) != null && resolvedTypeNames.length > 0) {
                String[] resolvedTypeName = resolvedTypeNames[0];
                resolvedType = javaProject.findType(resolvedTypeName[0], resolvedTypeName[1]);
            }
        }
        return resolvedType;
    }

    private void collectDeclaredMethodNames(IType type, IJavaProject javaProject, JUnitTestPlugin.JUnitVersion jUnitVersion, Set<String> methodNames) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String methodName = method.getElementName();
            int flags = method.getFlags();
            if (Modifier.isPublic((int)flags) && !Modifier.isStatic((int)flags) && method.getNumberOfParameters() == 0 && "V".equals(method.getReturnType()) && methodName.startsWith("test")) {
                methodNames.add(methodName);
            }
            if (jUnitVersion != JUnitTestPlugin.JUnitVersion.JUNIT3 && !Modifier.isPrivate((int)flags) && !Modifier.isStatic((int)flags)) {
                IAnnotation annotation = method.getAnnotation("Test");
                if (annotation.exists()) {
                    methodNames.add(methodName + JUnitStubUtility.getParameterTypes((IMethod)method, (boolean)false));
                } else if (jUnitVersion == JUnitTestPlugin.JUnitVersion.JUNIT5 || jUnitVersion == JUnitTestPlugin.JUnitVersion.JUNIT6) {
                    boolean hasAnyTestAnnotation;
                    boolean bl = hasAnyTestAnnotation = method.getAnnotation("TestFactory").exists() || method.getAnnotation("Testable").exists() || method.getAnnotation("TestTemplate").exists() || method.getAnnotation("ParameterizedTest").exists() || method.getAnnotation("RepeatedTest").exists();
                    if (hasAnyTestAnnotation || this.isAnnotatedWithTestable(method, type, javaProject)) {
                        methodNames.add(methodName + JUnitStubUtility.getParameterTypes((IMethod)method, (boolean)false));
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isAnnotatedWithTestable(IMethod method, IType declaringType, IJavaProject javaProject) throws JavaModelException {
        IAnnotation[] iAnnotationArray = method.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            IType annotationType = this.getResolvedType(annotation.getElementName(), declaringType, javaProject);
            if (annotationType != null) {
                if (this.matchesTestable(annotationType)) {
                    return true;
                }
                HashSet<IType> hierarchy = new HashSet<IType>();
                if (this.matchesTestableInAnnotationHierarchy(annotationType, javaProject, hierarchy)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean matchesTestable(IType annotationType) {
        return annotationType != null && "org.junit.platform.commons.annotation.Testable".equals(annotationType.getFullyQualifiedName());
    }

    private boolean matchesTestableInAnnotationHierarchy(IType annotationType, IJavaProject javaProject, Set<IType> hierarchy) throws JavaModelException {
        if (annotationType != null) {
            IAnnotation[] iAnnotationArray = annotationType.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                IType annType = this.getResolvedType(annotation.getElementName(), annotationType, javaProject);
                if (annType != null && hierarchy.add(annType) && (this.matchesTestable(annType) || this.matchesTestableInAnnotationHierarchy(annType, javaProject, hierarchy))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String chooseMethodName(Set<String> methodNames) {
        Shell shell = this.getShell();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
        dialog.setMessage(MessageFormat.format(Messages.JUnitLaunchConfigurationTab_select_method_header, this.fTestText.getText()));
        dialog.setTitle(Messages.JUnitLaunchConfigurationTab_select_method_title);
        int methodCount = methodNames.size();
        Object[] elements = new String[methodCount + 1];
        methodNames.toArray(elements);
        elements[methodCount] = Messages.JUnitLaunchConfigurationTab_all_methods_text;
        dialog.setElements(elements);
        String methodName = this.fTestMethodText.getText();
        if (methodNames.contains(methodName)) {
            dialog.setInitialSelections(new Object[]{methodName});
        }
        dialog.setAllowDuplicates(false);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            String result = (String)dialog.getFirstResult();
            return result == null || result.equals(Messages.JUnitLaunchConfigurationTab_all_methods_text) ? "" : result;
        }
        return null;
    }

    private IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JUnitTestPlugin.log(e.getStatus());
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.JUnitLaunchConfigurationTab_projectdialog_title);
        dialog.setMessage(Messages.JUnitLaunchConfigurationTab_projectdialog_message);
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.validatePage();
        return this.fIsValid;
    }

    private void testModeChanged() {
        IJavaProject javaProject;
        String projText;
        boolean isSingleTestMode = this.fTestRadioButton.getSelection();
        this.setEnableSingleTestGroup(isSingleTestMode);
        this.setEnableContainerTestGroup(!isSingleTestMode);
        if (!isSingleTestMode && this.fContainerText.getText().length() == 0 && Path.EMPTY.isValidSegment(projText = this.fProjText.getText()) && (javaProject = this.getJavaModel().getJavaProject(projText)) != null && javaProject.exists()) {
            this.setContainerElement((IJavaElement)javaProject);
        }
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    protected void setErrorMessage(String errorMessage) {
        this.fIsValid = errorMessage == null;
        super.setErrorMessage(errorMessage);
    }

    private void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fTestContainerRadioButton.getSelection()) {
            if (this.fContainerElement == null) {
                this.setErrorMessage(Messages.JUnitLaunchConfigurationTab_error_noContainer);
                return;
            }
            this.validateJavaProject(this.fContainerElement.getJavaProject());
        } else {
            String projectName = this.fProjText.getText().trim();
            if (projectName.length() == 0) {
                this.setErrorMessage(Messages.JUnitLaunchConfigurationTab_error_projectnotdefined);
                return;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validatePath("/" + projectName, 4);
            if (!status.isOK() || !Path.ROOT.isValidSegment(projectName)) {
                this.setErrorMessage(MessageFormat.format(Messages.JUnitLaunchConfigurationTab_error_invalidProjectName, BasicElementLabels.getResourceName(projectName)));
                return;
            }
            IProject project = this.getWorkspaceRoot().getProject(projectName);
            if (!project.exists()) {
                this.setErrorMessage(Messages.JUnitLaunchConfigurationTab_error_projectnotexists);
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            this.validateJavaProject(javaProject);
            try {
                Set<String> methodsForType;
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.setErrorMessage(Messages.JUnitLaunchConfigurationTab_error_notJavaProject);
                    return;
                }
                String className = this.fTestText.getText().trim();
                if (className.length() == 0) {
                    this.setErrorMessage(Messages.JUnitLaunchConfigurationTab_error_testnotdefined);
                    return;
                }
                IType type = javaProject.findType(className);
                if (type == null) {
                    this.setErrorMessage(MessageFormat.format(Messages.JUnitLaunchConfigurationTab_error_test_class_not_found, className, projectName));
                    return;
                }
                String methodName = this.fTestMethodText.getText();
                if (methodName.length() > 0 && !(methodsForType = this.getMethodsForType(javaProject, type, this.getSelectedJUnitVersion())).contains(methodName)) {
                    super.setErrorMessage(MessageFormat.format(Messages.JUnitLaunchConfigurationTab_error_test_method_not_found, className, methodName, projectName));
                    return;
                }
            }
            catch (CoreException e) {
                JUnitTestPlugin.log(e);
            }
        }
    }

    private void validateJavaProject(IJavaProject javaProject) {
        JUnitTestPlugin.JUnitVersion jUnitVersion = this.getSelectedJUnitVersion();
        if (jUnitVersion != null) {
            if (jUnitVersion != JUnitTestPlugin.JUnitVersion.JUNIT5 && jUnitVersion != JUnitTestPlugin.JUnitVersion.JUNIT6 && !CoreTestSearchEngine.hasTestCaseType((IJavaProject)javaProject)) {
                this.setErrorMessage(Messages.JUnitLaunchConfigurationTab_error_testcasenotonpath);
                return;
            }
            String msg = Messages.JUnitLaunchConfigurationTab_error_testannotationnotonpath;
            if (jUnitVersion == JUnitTestPlugin.JUnitVersion.JUNIT4 && !CoreTestSearchEngine.hasJUnit4TestAnnotation((IJavaProject)javaProject)) {
                this.setErrorMessage(MessageFormat.format(msg, "org.junit.Test"));
                return;
            }
            if (jUnitVersion == JUnitTestPlugin.JUnitVersion.JUNIT5 && !CoreTestSearchEngine.hasJUnit5TestAnnotation((IJavaProject)javaProject)) {
                this.setErrorMessage(MessageFormat.format(msg, "org.junit.platform.commons.annotation.Testable"));
                return;
            }
            if (jUnitVersion == JUnitTestPlugin.JUnitVersion.JUNIT6 && !CoreTestSearchEngine.hasJUnit6TestAnnotation((IJavaProject)javaProject)) {
                this.setErrorMessage(MessageFormat.format(msg, "org.junit.platform.commons.annotation.Testable"));
                return;
            }
        }
    }

    private void setEnableContainerTestGroup(boolean enabled) {
        this.fContainerSearchButton.setEnabled(enabled);
        this.fContainerText.setEnabled(enabled);
    }

    private void setEnableSingleTestGroup(boolean enabled) {
        this.fProjLabel.setEnabled(enabled);
        this.fProjText.setEnabled(enabled);
        this.fProjButton.setEnabled(enabled);
        this.fTestLabel.setEnabled(enabled);
        this.fTestText.setEnabled(enabled);
        boolean projectTextHasContents = this.fProjText.getText().length() > 0;
        this.fSearchButton.setEnabled(enabled && projectTextHasContents);
        this.fTestMethodLabel.setEnabled(enabled);
        this.fTestMethodText.setEnabled(enabled);
        this.fTestMethodSearchButton.setEnabled(enabled && projectTextHasContents && this.fTestText.getText().length() > 0);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            config.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        }
        this.initializeTestAttributes(javaElement, config);
    }

    private void initializeTestAttributes(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        if (javaElement != null && javaElement.getElementType() < 5) {
            this.initializeTestContainer(javaElement, config);
        } else {
            this.initializeTestType(javaElement, config);
        }
    }

    private void initializeTestContainer(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.jdt.junit.CONTAINER", javaElement.getHandleIdentifier());
        this.initializeName(config, javaElement.getElementName());
    }

    private void initializeName(ILaunchConfigurationWorkingCopy config, String name) {
        if (name == null) {
            name = "";
        }
        if (name.length() > 0) {
            int index;
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            boolean useQualification = preferenceStore.getBoolean("launch_name_fully_qualified_for_junit_test");
            if (!useQualification && (index = name.lastIndexOf(46)) > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    private void initializeTestType(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = "";
        String testKindId = null;
        try {
            if (javaElement instanceof ISourceReference) {
                ITestKind testKind = JUnitTestPlugin.getJUnitVersion(javaElement).getJUnitTestKind();
                testKindId = testKind.getId();
                Set types = TestSearchEngine.findTests((IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaElement)javaElement, (ITestKind)testKind);
                if (types == null || types.isEmpty()) {
                    return;
                }
                name = ((IType)types.iterator().next()).getFullyQualifiedName('.');
            }
        }
        catch (InterruptedException | InvocationTargetException testKind) {
            // empty catch block
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        new ConfigureViewerSupport(testKindId).apply(config);
        this.initializeName(config, name);
        boolean isRunWithJUnitPlatform = JUnitTestPlugin.isRunWithJUnitPlatform(javaElement);
        if (isRunWithJUnitPlatform) {
            config.setAttribute("org.eclipse.jdt.junit.IS_RUN_WITH_JUNIT_PLATFORM", true);
        }
    }

    public String getName() {
        return Messages.JUnitLaunchConfigurationTab_tab_label;
    }

    private IJavaElement chooseContainer(IJavaElement initElement) {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class, IPackageFragment.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                return true;
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class, IPackageFragment.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).isArchive()) {
                    return false;
                }
                try {
                    if (element instanceof IPackageFragment && !((IPackageFragment)element).hasChildren()) {
                        return false;
                    }
                }
                catch (JavaModelException e) {
                    return false;
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(Messages.JUnitLaunchConfigurationTab_folderdialog_title);
        dialog.setMessage(Messages.JUnitLaunchConfigurationTab_folderdialog_message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            return (IJavaElement)element;
        }
        return null;
    }

    private String getPresentationName(IJavaElement element) {
        return this.fJavaElementLabelProvider.getText((Object)element);
    }

    private IJavaElement getContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IJavaElement) {
                    return (IJavaElement)obj;
                }
                if (obj instanceof IResource) {
                    IJavaElement je = JavaCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = JavaCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input = part.getEditorInput();
                return (IJavaElement)input.getAdapter(IJavaElement.class);
            }
        }
        return null;
    }

    private void initializeJavaProject(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String name = null;
        if (javaProject != null && javaProject.exists()) {
            name = javaProject.getElementName();
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        LayoutUtil.setButtonDimensionHint((Button)button);
    }

    public String getId() {
        return "org.eclipse.jdt.ui.unittest.junit.JUnitLaunchConfigurationTab";
    }

    private void configureIncludeExcludeTags() {
        JUnitLaunchIncludeExcludeTagsDialog dialog = new JUnitLaunchIncludeExcludeTagsDialog(this.getShell(), this.fLaunchConfiguration);
        if (dialog.open() == 0) {
            try {
                ILaunchConfigurationWorkingCopy workingCopy = this.fLaunchConfiguration.getWorkingCopy();
                workingCopy.setAttribute("org.eclipse.jdt.junit.HAS_INCLUDE_TAGS", dialog.hasIncludeTags());
                workingCopy.setAttribute("org.eclipse.jdt.junit.HAS_EXCLUDE_TAGS", dialog.hasExcludeTags());
                workingCopy.setAttribute("org.eclipse.jdt.junit.INCLUDE_TAGS", dialog.getIncludeTags());
                workingCopy.setAttribute("org.eclipse.jdt.junit.EXCLUDE_TAGS", dialog.getExcludeTags());
                workingCopy.doSave();
                this.validatePage();
                this.updateLaunchConfigurationDialog();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

