/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.internal.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestRunSession;

public abstract class RemoteTestRunnerClient
implements ITestRunnerClient {
    private int fPort = -1;
    protected String fLastLineDelimiter;
    protected InputStream fInputStream;
    protected PrintWriter fWriter;
    protected PushbackReader fPushbackReader;
    protected String fVersion;
    protected boolean fDebug = false;
    protected final ITestRunSession fTestRunSession;
    protected ServerSocket fServerSocket;
    protected Socket fSocket;

    protected RemoteTestRunnerClient(int port, ITestRunSession testRunSession) {
        this.fPort = port;
        this.fTestRunSession = testRunSession;
    }

    public void startMonitoring() {
        ServerConnection connection = new ServerConnection(this.fPort);
        connection.start();
    }

    public abstract void receiveMessage(String var1);

    public synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fPushbackReader != null) {
                this.fPushbackReader.close();
                this.fPushbackReader = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.fDebug) {
            System.out.println("shutdown");
        }
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String readMessage(PushbackReader in) throws IOException {
        int ch;
        StringBuilder buf = new StringBuilder(128);
        while ((ch = in.read()) != -1) {
            switch (ch) {
                case 10: {
                    this.fLastLineDelimiter = "\n";
                    return buf.toString();
                }
                case 13: {
                    ch = in.read();
                    if (ch == 10) {
                        this.fLastLineDelimiter = "\r\n";
                    } else {
                        in.unread(ch);
                        this.fLastLineDelimiter = "\r";
                    }
                    return buf.toString();
                }
            }
            buf.append((char)ch);
        }
        this.fLastLineDelimiter = null;
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public synchronized void stopMonitoring() {
        if (this.fServerSocket != null && !this.fServerSocket.isClosed() && this.fSocket == null) {
            this.shutDown();
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            JUnitTestPlugin.log(exception);
        }
    }

    abstract class ProcessingState {
        ProcessingState() {
        }

        abstract ProcessingState readMessage(String var1);
    }

    private class ServerConnection
    extends Thread {
        int fServerPort;

        public ServerConnection(int port) {
            super("ServerConnection");
            this.fServerPort = port;
        }

        @Override
        public void run() {
            try {
                String message;
                if (RemoteTestRunnerClient.this.fDebug) {
                    System.out.println("Creating server socket " + this.fServerPort);
                }
                RemoteTestRunnerClient.this.fServerSocket = new ServerSocket(this.fServerPort);
                RemoteTestRunnerClient.this.fSocket = RemoteTestRunnerClient.this.fServerSocket.accept();
                RemoteTestRunnerClient.this.fPushbackReader = new PushbackReader(new BufferedReader(new InputStreamReader(RemoteTestRunnerClient.this.fSocket.getInputStream(), StandardCharsets.UTF_8)));
                RemoteTestRunnerClient.this.fWriter = new PrintWriter((Writer)new OutputStreamWriter(RemoteTestRunnerClient.this.fSocket.getOutputStream(), StandardCharsets.UTF_8), true);
                while (RemoteTestRunnerClient.this.fPushbackReader != null && (message = RemoteTestRunnerClient.this.readMessage(RemoteTestRunnerClient.this.fPushbackReader)) != null) {
                    RemoteTestRunnerClient.this.receiveMessage(message);
                }
            }
            catch (SocketException e) {
                RemoteTestRunnerClient.this.fTestRunSession.notifyTestSessionAborted(null, (Exception)e);
            }
            catch (IOException e) {
                JUnitTestPlugin.log(e);
            }
            RemoteTestRunnerClient.this.shutDown();
        }
    }
}

