/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class JUnitTestPlugin
extends AbstractUIPlugin {
    private static JUnitTestPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.ui.unittest.junit";
    public static final String UNIT_TEST_VIEW_SUPPORT_ID = "org.eclipse.jdt.ui.unittest.junit";
    private BundleContext fBundleContext;

    public JUnitTestPlugin() {
        fgPlugin = this;
    }

    public static JUnitTestPlugin getDefault() {
        return fgPlugin;
    }

    public static String getPluginId() {
        return "org.eclipse.jdt.ui.unittest.junit";
    }

    public static void log(Throwable e) {
        JUnitTestPlugin.log((IStatus)new Status(4, JUnitTestPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitTestPlugin.getDefault().getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.fBundleContext = null;
    }

    public Object getService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.fBundleContext.getService(reference);
    }

    public static JUnitVersion getJUnitVersion(IJavaElement element) {
        if (element != null) {
            IJavaProject project = element.getJavaProject();
            if (JUnitTestPlugin.isRunWithJUnitPlatform(element)) {
                return JUnitVersion.JUNIT4;
            }
            if (CoreTestSearchEngine.hasJUnit6TestAnnotation((IJavaProject)project)) {
                return JUnitVersion.JUNIT6;
            }
            if (CoreTestSearchEngine.hasJUnit5TestAnnotation((IJavaProject)project)) {
                return JUnitVersion.JUNIT5;
            }
            if (CoreTestSearchEngine.hasJUnit4TestAnnotation((IJavaProject)project)) {
                return JUnitVersion.JUNIT4;
            }
        }
        return JUnitVersion.JUNIT3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunWithJUnitPlatform(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            element = ((ICompilationUnit)element).findPrimaryType();
        }
        if (!(element instanceof IType)) return false;
        IType type = (IType)element;
        try {
            IMemberValuePair[] memberValuePairs;
            IAnnotation runWithAnnotation = type.getAnnotation("RunWith");
            if (!runWithAnnotation.exists()) {
                runWithAnnotation = type.getAnnotation("org.junit.runner.RunWith");
            }
            if (!runWithAnnotation.exists()) return false;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = runWithAnnotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if (memberValuePair.getMemberName().equals("value") && memberValuePair.getValue().equals("JUnitPlatform")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Bundle[] getBundles(String bundleName, String version) {
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        ServiceReference serviceRef = this.fBundleContext.getServiceReference(PackageAdmin.class);
        PackageAdmin admin = (PackageAdmin)this.fBundleContext.getService(serviceRef);
        bundles = admin.getBundles(bundleName, version);
        if (bundles != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = JUnitTestPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = PlatformUI.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = JUnitTestPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static void activateUnitTestCoreBundle() {
        Assert.isNotNull((Object)Platform.getBundle((String)"org.eclipse.unittest.ui"));
    }

    public static enum JUnitVersion {
        JUNIT3("org.eclipse.jdt.junit.loader.junit3"),
        JUNIT4("org.eclipse.jdt.junit.loader.junit4"),
        JUNIT5("org.eclipse.jdt.junit.loader.junit5"),
        JUNIT6("org.eclipse.jdt.junit.loader.junit6");

        public final String junitTestKindId;

        private JUnitVersion(String junitTestKindId) {
            this.junitTestKindId = junitTestKindId;
        }

        public static JUnitVersion fromJUnitTestKindId(String junitTestKindId) {
            return Arrays.stream(JUnitVersion.values()).filter(version -> version.junitTestKindId.equals(junitTestKindId)).findAny().orElse(null);
        }

        public ITestKind getJUnitTestKind() {
            return TestKindRegistry.getDefault().getKind(this.junitTestKindId);
        }
    }
}

