/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.junit.JUnitPreferencesConstants;
import org.eclipse.jdt.internal.junit.launcher.AssertionVMArg;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitUIPreferencesConstants;
import org.eclipse.jdt.internal.ui.filtertable.FilterManager;
import org.eclipse.jdt.internal.ui.filtertable.JavaFilterTable;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JUnitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final FilterManager FILTER_MANAGER = new FilterManager("org.eclipse.jdt.junit.active_filters", "org.eclipse.jdt.junit.inactive_filters"){

        protected String[] getDefaultActiveFilters(IPreferenceStore store) {
            return JUnitPreferencesConstants.createDefaultStackFiltersList();
        }

        protected String[] getDefaultInactiveFilters(IPreferenceStore store) {
            return new String[0];
        }
    };
    private final JavaFilterTable fJavaFilterTable;
    private Button fEnableAssertionsCheckBox;
    private Button fShowInAllViewsCheckBox;

    public JUnitPreferencePage() {
        this.setDescription(JUnitMessages.JUnitPreferencePage_description);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jdt.junit.core"));
        this.fJavaFilterTable = new JavaFilterTable((PreferencePage)this, FILTER_MANAGER, new JavaFilterTable.FilterTableConfig().setLabelText(JUnitMessages.JUnitPreferencePage_filter_label).setAddFilter(new JavaFilterTable.ButtonLabel(JUnitMessages.JUnitPreferencePage_addfilterbutton_label)).setAddType(new JavaFilterTable.ButtonLabel(JUnitMessages.JUnitPreferencePage_addtypebutton_label)).setAddTypeDialog(new JavaFilterTable.DialogLabels(JUnitMessages.JUnitPreferencePage_addtypedialog_title, JUnitMessages.JUnitPreferencePage_addtypedialog_message)).setAddPackage(new JavaFilterTable.ButtonLabel(JUnitMessages.JUnitPreferencePage_addpackagebutton_label)).setAddPackageDialog(new JavaFilterTable.DialogLabels(JUnitMessages.JUnitPreferencePage_addpackagedialog_title, JUnitMessages.JUnitPreferencePage_addpackagedialog_message)).setRemove(new JavaFilterTable.ButtonLabel(JUnitMessages.JUnitPreferencePage_removefilterbutton_label)).setSelectAll(new JavaFilterTable.ButtonLabel(JUnitMessages.JUnitPreferencePage_enableallbutton_label)).setDeselectAll(new JavaFilterTable.ButtonLabel(JUnitMessages.JUnitPreferencePage_disableallbutton_label)).setHelpContextId("org.eclipse.jdt.junit.junit_preference_page_context"));
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.junit.junit_preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createEnableAssertionsCheckbox(composite);
        this.createShowInAllViewsCheckbox(composite);
        this.createJavaFilterTable(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createJavaFilterTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.fJavaFilterTable.createTable(container);
    }

    private void createEnableAssertionsCheckbox(Composite container) {
        this.fEnableAssertionsCheckBox = new Button(container, 96);
        this.fEnableAssertionsCheckBox.setText(JUnitMessages.JUnitPreferencePage_enableassertionscheckbox_label);
        GridData gd = this.getButtonGridData(this.fEnableAssertionsCheckBox);
        this.fEnableAssertionsCheckBox.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fEnableAssertionsCheckBox);
        this.setAssertionCheckBoxSelection(AssertionVMArg.getEnableAssertionsPreference());
    }

    private void createShowInAllViewsCheckbox(Composite container) {
        this.fShowInAllViewsCheckBox = new Button(container, 96);
        this.fShowInAllViewsCheckBox.setText(JUnitMessages.JUnitPreferencePage_showInAllViews_label);
        GridData gd = this.getButtonGridData(this.fShowInAllViewsCheckBox);
        this.fShowInAllViewsCheckBox.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fShowInAllViewsCheckBox);
        this.setShowInAllViewsCheckBoxSelection(JUnitUIPreferencesConstants.getShowInAllViews());
    }

    public boolean getAssertionCheckBoxSelection() {
        return this.fEnableAssertionsCheckBox.getSelection();
    }

    public void setAssertionCheckBoxSelection(boolean selected) {
        this.fEnableAssertionsCheckBox.setSelection(selected);
    }

    public boolean getShowInAllViewsCheckBoxSelection() {
        return this.fShowInAllViewsCheckBox.getSelection();
    }

    public void setShowInAllViewsCheckBoxSelection(boolean selected) {
        this.fShowInAllViewsCheckBox.setSelection(selected);
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        AssertionVMArg.setEnableAssertionsPreference(this.getAssertionCheckBoxSelection());
        JUnitUIPreferencesConstants.setShowInAllViews(this.getShowInAllViewsCheckBoxSelection());
        this.fJavaFilterTable.performOk(this.getPreferenceStore());
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fEnableAssertionsCheckBox.setSelection(DefaultScope.INSTANCE.getNode("org.eclipse.jdt.junit.core").getBoolean("org.eclipse.jdt.junit.enable_assertions", true));
        this.fShowInAllViewsCheckBox.setSelection(DefaultScope.INSTANCE.getNode("org.eclipse.jdt.junit").getBoolean("org.eclipse.jdt.junit.show_in_all_views", false));
        this.fJavaFilterTable.performDefaults();
    }
}

