/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.launcher.DefineSystemLibraryQuickFix;
import org.eclipse.jdt.internal.debug.ui.launcher.JREResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.OpenPreferencePageResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.OpenPropertyPageResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.SelectDefaultSystemLibraryQuickFix;
import org.eclipse.jdt.internal.debug.ui.launcher.SelectSystemLibraryQuickFix;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.ConfigureProblemSeverityAction;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IMarkerResolutionRelevance;

public class JreResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            if (JavaRuntime.JRE_CONTAINER_MARKER.equals(marker.getType())) {
                boolean noVM;
                OpenPreferencePageResolution openPreferencePageResolution = new OpenPreferencePageResolution("org.eclipse.jdt.debug.ui.jreProfiles", new String[]{"org.eclipse.jdt.debug.ui.jreProfiles", "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage"}, LauncherMessages.JreResolutionGenerator_open_ee_prefs, LauncherMessages.JreResolutionGenerator_opens_ee_prefs);
                IJavaProject project = this.getJavaProject(marker);
                IPath container = null;
                IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals((path = entry.getPath()).segment(0))) {
                        container = path;
                    }
                    ++n2;
                }
                boolean bl = noVM = container == null || JREContainerInitializer.resolveVM(container) == null;
                if (noVM) {
                    return new IMarkerResolution[]{openPreferencePageResolution};
                }
                ConfigureSeverityResolution configureSeverityResolution = new ConfigureSeverityResolution(project, JavaRuntime.PREF_STRICTLY_COMPATIBLE_JRE_NOT_AVAILABLE);
                return new IMarkerResolution[]{openPreferencePageResolution, configureSeverityResolution};
            }
            if (JavaRuntime.JRE_COMPILER_COMPLIANCE_MARKER.equals(marker.getType())) {
                IJavaProject project = this.getJavaProject(marker);
                OpenPropertyPageResolution openPropertyPageResolution = new OpenPropertyPageResolution((IAdaptable)project, "org.eclipse.jdt.ui.propertyPages.CompliancePreferencePage", new String[]{"org.eclipse.jdt.ui.propertyPages.CompliancePreferencePage", "org.eclipse.jdt.ui.propertyPages.JavaBuildPreferencePage"}, LauncherMessages.JreResolutionGenerator_open_cc_props, LauncherMessages.JreResolutionGenerator_opens_cc_props);
                ConfigureSeverityResolution configureSeverityResolution = new ConfigureSeverityResolution(project, JavaRuntime.PREF_COMPILER_COMPLIANCE_DOES_NOT_MATCH_JRE);
                return new IMarkerResolution[]{openPropertyPageResolution, configureSeverityResolution};
            }
            int id = marker.getAttribute("id", -1);
            switch (id) {
                case 963: {
                    String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
                    Path path = new Path(arguments[0]);
                    if (path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                        if (JREResolution.getAllVMs().length > 0) {
                            IJavaProject project = this.getJavaProject(marker);
                            return new IMarkerResolution[]{new SelectSystemLibraryQuickFix((IPath)path, project)};
                        }
                        return new IMarkerResolution[]{new DefineSystemLibraryQuickFix()};
                    }
                    break;
                }
                case 965: {
                    String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
                    Path path = new Path(arguments[0]);
                    if (path.segment(0).equals("JRE_LIB")) {
                        if (JREResolution.getAllVMs().length > 0) {
                            return new IMarkerResolution[]{new SelectDefaultSystemLibraryQuickFix()};
                        }
                        return new IMarkerResolution[]{new DefineSystemLibraryQuickFix()};
                    }
                    break;
                }
                case 1010: {
                    String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
                    Path path = new Path(arguments[0]);
                    if (path.segment(0).equals("JRE_LIB") || path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                        IJavaProject project = this.getJavaProject(marker);
                        return new IMarkerResolution[]{new SelectSystemLibraryQuickFix((IPath)path, project)};
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
        return NO_RESOLUTION;
    }

    protected IJavaProject getJavaProject(IMarker marker) {
        return JavaCore.create((IProject)marker.getResource().getProject());
    }

    public boolean hasResolutions(IMarker marker) {
        try {
            String type = marker.getType();
            return "org.eclipse.jdt.core.buildpath_problem".equals(type) || JavaRuntime.JRE_CONTAINER_MARKER.equals(type) || JavaRuntime.JRE_COMPILER_COMPLIANCE_MARKER.equals(type);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static class ConfigureSeverityResolution
    implements IMarkerResolution2,
    IMarkerResolutionRelevance {
        private final IJavaProject fProject;
        private final String fOptionId;

        public ConfigureSeverityResolution(IJavaProject project, String optionId) {
            this.fProject = project;
            this.fOptionId = optionId;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return JavaPluginImages.get((String)"org.eclipse.jdt.ui.configure_problem_severity.png");
        }

        public String getLabel() {
            return CorrectionMessages.ConfigureProblemSeveritySubProcessor_name;
        }

        public int getRelevanceForResolution() {
            return -1;
        }

        public void run(IMarker marker) {
            ConfigureProblemSeverityAction problemSeverityAction = new ConfigureProblemSeverityAction(this.fProject, this.fOptionId, "org.eclipse.jdt.launching", ConfigureProblemSeverityAction.PreferencePage.BUILDING, null);
            problemSeverityAction.run();
        }
    }
}

