/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class OpenTypeAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        try {
            while (itr.hasNext()) {
                Object element = itr.next();
                if (!this.openElement(action, element)) continue;
                return;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }

    protected boolean openElement(IAction action, Object element) throws DebugException, CoreException {
        IType sourceElement = this.resolveSourceElement(element);
        if (sourceElement == null) {
            Status status = new Status(1, IJavaDebugUIConstants.PLUGIN_ID, 150, "Source not found", null);
            throw new CoreException((IStatus)status);
        }
        this.openInEditor(element, sourceElement);
        return false;
    }

    protected abstract IDebugElement getDebugElement(IAdaptable var1);

    protected abstract IJavaType getTypeToOpen(IDebugElement var1) throws CoreException;

    protected IType resolveSourceElement(Object e) throws CoreException {
        IType source = null;
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            IJavaType type = this.getTypeToOpen(dbgElement);
            while (type instanceof IJavaArrayType) {
                type = ((IJavaArrayType)type).getComponentType();
            }
            if (type != null && (source = JavaDebugUtils.resolveType((IJavaType)type)) == null) {
                source = OpenTypeAction.findTypeInWorkspace(type.getName(), false);
            }
        }
        return source;
    }

    protected void openInEditor(Object element, IType sourceElement) throws CoreException {
        if (this.isHierarchy()) {
            OpenTypeHierarchyUtil.open((IJavaElement)sourceElement, (IWorkbenchWindow)this.getWorkbenchWindow());
        } else {
            JavaUI.openInEditor((IJavaElement)sourceElement);
        }
    }

    protected boolean isHierarchy() {
        return false;
    }

    public static IType findTypeInWorkspace(String typeName, boolean findOnlyUniqueMatch) throws CoreException {
        String simpleName;
        char[][] qualifications;
        int dot = typeName.lastIndexOf(46);
        if (dot != -1) {
            qualifications = new char[][]{typeName.substring(0, dot).toCharArray()};
            simpleName = typeName.substring(dot + 1);
        } else {
            qualifications = null;
            simpleName = typeName;
        }
        char[][] typeNames = new char[][]{simpleName.toCharArray()};
        if (findOnlyUniqueMatch) {
            return OpenTypeAction.findUniqueTypeInWorkspace(qualifications, typeNames);
        }
        return OpenTypeAction.findAnyTypeInWorkspace(qualifications, typeNames);
    }

    private static IType findAnyTypeInWorkspace(char[][] qualifications, char[][] typeNames) throws JavaModelException {
        class ResultException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IType fType;

            public ResultException(IType type) {
                this.fType = type;
            }
        }
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                throw new ResultException(match.getType());
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(qualifications, typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        }
        catch (ResultException e) {
            return e.fType;
        }
        return null;
    }

    private static IType findUniqueTypeInWorkspace(char[][] qualifications, char[][] typeNames) throws JavaModelException {
        final IType[] result = new IType[1];
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                if (result[0] != null) {
                    throw new OperationCanceledException();
                }
                result[0] = match.getType();
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(qualifications, typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        return result[0];
    }

    protected void typeHierarchyError() {
        this.showErrorMessage(ActionMessages.ObjectActionDelegate_Unable_to_display_type_hierarchy__The_selected_source_element_is_not_contained_in_the_workspace__1);
    }
}

