/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.util.Objects;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.swt.graphics.Image;

public class BindingProperty
extends ASTAttribute {
    private final String fName;
    private final Binding fParent;
    private final ASTAttribute[] fValues;
    private final boolean fIsRelevant;

    public BindingProperty(Binding parent, String name, Object value, boolean isRelevant) {
        this.fParent = parent;
        this.fName = value instanceof String ? (((String)value).length() == 0 ? String.valueOf(name) + ": (empty string)" : String.valueOf(name) + ": " + Binding.getEscapedStringLiteral((String)value)) : (value instanceof Character ? String.valueOf(name) + ": " + Binding.getEscapedCharLiteral(((Character)value).charValue()) : String.valueOf(name) + ": " + String.valueOf(value));
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, boolean value, boolean isRelevant) {
        this.fParent = parent;
        this.fName = String.valueOf(name) + ": " + String.valueOf(value);
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, int value, boolean isRelevant) {
        this.fParent = parent;
        this.fName = String.valueOf(name) + ": " + String.valueOf(value);
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, IBinding[] bindings, boolean isRelevant) {
        this.fParent = parent;
        if (bindings == null) {
            this.fName = String.valueOf(name) + " (null)";
            this.fValues = null;
        } else {
            this.fValues = this.createBindings(bindings, isRelevant);
            this.fName = String.valueOf(name) + " (" + this.fValues.length + ')';
        }
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, ASTAttribute[] children, boolean isRelevant) {
        this.fParent = parent;
        if (children == null) {
            children = new ASTAttribute[]{};
        }
        this.fValues = children;
        this.fName = String.valueOf(name) + " (" + this.fValues.length + ')';
        this.fIsRelevant = isRelevant;
    }

    @Deprecated
    public BindingProperty(Binding parent, StringBuffer label, boolean isRelevant) {
        this.fParent = parent;
        this.fName = label.toString();
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, StringBuilder label, boolean isRelevant) {
        this.fParent = parent;
        this.fName = label.toString();
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    private Binding[] createBindings(IBinding[] bindings, boolean isRelevant) {
        Binding[] res = new Binding[bindings.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new Binding(this, String.valueOf(i), bindings[i], isRelevant);
            ++i;
        }
        return res;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    @Override
    public Object[] getChildren() {
        if (this.fValues != null) {
            return this.fValues;
        }
        return EMPTY;
    }

    @Override
    public String getLabel() {
        return this.fName;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean isRelevant() {
        return this.fIsRelevant;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        BindingProperty other = (BindingProperty)obj;
        if (!Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        return Objects.equals(this.fName, other.fName);
    }

    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0);
    }
}

