/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.model.ITestRunSessionListener;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.ModelMessages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunHandler;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestRunSessionSerializer;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JUnitModel {
    private final ListenerList fTestRunSessionListeners = new ListenerList();
    private final LinkedList fTestRunSessions = new LinkedList();
    private final ILaunchListener fLaunchListener = new JUnitLaunchListener();

    public void start() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener(this.fLaunchListener);
        this.addTestRunSessionListener(new LegacyTestRunSessionListener());
    }

    public void stop() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener(this.fLaunchListener);
        File historyDirectory = JUnitPlugin.getHistoryDirectory();
        File[] swapFiles = historyDirectory.listFiles();
        if (swapFiles != null) {
            int i = 0;
            while (i < swapFiles.length) {
                swapFiles[i].delete();
                ++i;
            }
        }
    }

    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    public List getTestRunSessions() {
        return new ArrayList(this.fTestRunSessions);
    }

    public void addTestRunSession(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        Assert.isLegal((!this.fTestRunSessions.contains(testRunSession) ? 1 : 0) != 0);
        this.fTestRunSessions.addFirst(testRunSession);
        this.notifyTestRunSessionAdded(testRunSession);
    }

    public static TestRunSession importTestRunSession(File file) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler();
            parser.parse(file, (DefaultHandler)handler);
            TestRunSession session = handler.getTestRunSession();
            JUnitPlugin.getModel().addTestRunSession(session);
            return session;
        }
        catch (ParserConfigurationException e) {
            JUnitModel.throwImportError(file, e);
        }
        catch (SAXException e) {
            JUnitModel.throwImportError(file, e);
        }
        catch (IOException e) {
            JUnitModel.throwImportError(file, e);
        }
        return null;
    }

    public static void importIntoTestRunSession(File swapFile, TestRunSession testRunSession) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler(testRunSession);
            parser.parse(swapFile, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            JUnitModel.throwImportError(swapFile, e);
        }
        catch (SAXException e) {
            JUnitModel.throwImportError(swapFile, e);
        }
        catch (IOException e) {
            JUnitModel.throwImportError(swapFile, e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportTestRunSession(TestRunSession testRunSession, File file) throws CoreException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                JUnitModel.exportTestRunSession(testRunSession, out);
                return;
            }
            catch (IOException e) {
                JUnitModel.throwExportError(file, e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    JUnitPlugin.log(e2);
                }
                return;
            }
            catch (TransformerConfigurationException e) {
                JUnitModel.throwExportError(file, e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    JUnitPlugin.log(e2);
                }
                return;
            }
            catch (TransformerException e) {
                JUnitModel.throwExportError(file, e);
                if (out == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    JUnitPlugin.log(e2);
                }
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    JUnitPlugin.log(e2);
                }
            }
        }
    }

    public static void exportTestRunSession(TestRunSession testRunSession, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        InputSource inputSource = new InputSource();
        SAXSource source = new SAXSource(new TestRunSessionSerializer(testRunSession), inputSource);
        StreamResult result = new StreamResult(out);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        transformer.transform(source, result);
    }

    private static void throwExportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JUnitPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_write, file.getAbsolutePath()), (Throwable)e));
    }

    private static void throwImportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JUnitPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_read, file.getAbsolutePath()), (Throwable)e));
    }

    public void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed = this.fTestRunSessions.remove(testRunSession);
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
        testRunSession.removeSwapFile();
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        testRunSession.stopTestRun();
        ILaunch launch = testRunSession.getLaunch();
        if (launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionRemoved(testRunSession);
            ++i;
        }
    }

    private void notifyTestRunSessionAdded(TestRunSession testRunSession) {
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionAdded(testRunSession);
            ++i;
        }
    }

    private final class JUnitLaunchListener
    implements ILaunchListener {
        private HashSet fTrackedLaunches = new HashSet(20);

        private JUnitLaunchListener() {
        }

        public void launchAdded(ILaunch launch) {
            this.fTrackedLaunches.add(launch);
        }

        public void launchRemoved(ILaunch launch) {
            this.fTrackedLaunches.remove(launch);
        }

        public void launchChanged(ILaunch launch) {
            if (!this.fTrackedLaunches.contains(launch)) {
                return;
            }
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config == null) {
                return;
            }
            IJavaProject javaProject = JUnitLaunchConfigurationConstants.getJavaProject(config);
            if (javaProject == null) {
                return;
            }
            String portStr = launch.getAttribute("org.eclipse.jdt.junit.PORT");
            if (portStr == null) {
                return;
            }
            try {
                int port = Integer.parseInt(portStr);
                this.fTrackedLaunches.remove(launch);
                this.getDisplay().asyncExec(new Runnable(this, launch, javaProject, port){
                    final /* synthetic */ JUnitLaunchListener this$1;
                    private final /* synthetic */ ILaunch val$launch;
                    private final /* synthetic */ IJavaProject val$javaProject;
                    private final /* synthetic */ int val$port;
                    {
                        this.this$1 = jUnitLaunchListener;
                        this.val$launch = iLaunch;
                        this.val$javaProject = iJavaProject;
                        this.val$port = n;
                    }

                    public void run() {
                        JUnitLaunchListener.access$1(this.this$1, this.val$launch, this.val$javaProject, this.val$port);
                    }
                });
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }

        private void connectTestRunner(ILaunch launch, IJavaProject javaProject, int port) {
            this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
            int maxCount = JUnitPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.jdt.junit.max_test_runs");
            int toDelete = JUnitModel.this.fTestRunSessions.size() - maxCount;
            while (toDelete > 0) {
                --toDelete;
                TestRunSession session = (TestRunSession)JUnitModel.this.fTestRunSessions.removeLast();
                JUnitModel.this.notifyTestRunSessionRemoved(session);
            }
            TestRunSession testRunSession = new TestRunSession(launch, javaProject, port);
            JUnitModel.this.addTestRunSession(testRunSession);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
            block12: {
                block11: {
                    block9: {
                        block10: {
                            activePart = null;
                            page = null;
                            try {
                                if (testRunner != null && testRunner.isCreated()) {
                                    var6_4 = testRunner;
                                    if (page == null || activePart == null) break block9;
                                    break block10;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (PartInitException pie) {
                                JUnitPlugin.log(pie);
                            }
                            finally {
                                if (page == null || activePart == null) break block11;
                            }
                        }
                        page.activate(activePart);
                    }
                    return var6_4;
lbl-1000:
                    // 1 sources

                    {
                        page = JUnitPlugin.getActivePage();
                        if (page == null) {
                        }
                        ** GOTO lbl-1000
                    }
                    page.activate(activePart);
                }
                return null;
lbl-1000:
                // 1 sources

                {
                    activePart = page.getActivePart();
                    var6_5 = (TestRunnerViewPart)page.showView("org.eclipse.jdt.junit.ResultView");
                    if (page == null || activePart == null) break block12;
                }
                page.activate(activePart);
            }
            return var6_5;
        }

        private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
            IWorkbenchPage page = JUnitPlugin.getActivePage();
            if (page == null) {
                return null;
            }
            return (TestRunnerViewPart)page.findView("org.eclipse.jdt.junit.ResultView");
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            return display;
        }

        static /* synthetic */ void access$1(JUnitLaunchListener jUnitLaunchListener, ILaunch iLaunch, IJavaProject iJavaProject, int n) {
            jUnitLaunchListener.connectTestRunner(iLaunch, iJavaProject, n);
        }
    }

    private static final class LegacyTestRunSessionListener
    implements ITestRunSessionListener {
        private TestRunSession fActiveTestRunSession;
        private ITestSessionListener fTestSessionListener;

        private LegacyTestRunSessionListener() {
        }

        public void sessionAdded(TestRunSession testRunSession) {
            if (this.fActiveTestRunSession != null) {
                return;
            }
            this.fActiveTestRunSession = testRunSession;
            this.fTestSessionListener = new ITestSessionListener(this){
                final /* synthetic */ LegacyTestRunSessionListener this$1;
                {
                    this.this$1 = legacyTestRunSessionListener;
                }

                public void testAdded(TestElement testElement) {
                }

                public void sessionStarted() {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunStarted(LegacyTestRunSessionListener.access$0(this.this$1).getTotalCount());
                        ++i;
                    }
                }

                public void sessionTerminated() {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunTerminated();
                        ++i;
                    }
                    this.this$1.sessionRemoved(LegacyTestRunSessionListener.access$0(this.this$1));
                }

                public void sessionStopped(long elapsedTime) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunStopped(elapsedTime);
                        ++i;
                    }
                    this.this$1.sessionRemoved(LegacyTestRunSessionListener.access$0(this.this$1));
                }

                public void sessionEnded(long elapsedTime) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testRunEnded(elapsedTime);
                        ++i;
                    }
                    this.this$1.sessionRemoved(LegacyTestRunSessionListener.access$0(this.this$1));
                }

                public void runningBegins() {
                }

                public void testStarted(TestCaseElement testCaseElement) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testStarted(testCaseElement.getId(), testCaseElement.getTestName());
                        ++i;
                    }
                }

                public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testFailed(status.getOldCode(), testElement.getId(), testElement.getTestName(), trace);
                        ++i;
                    }
                }

                public void testEnded(TestCaseElement testCaseElement) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testEnded(testCaseElement.getId(), testCaseElement.getTestName());
                        ++i;
                    }
                }

                public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        testRunListeners[i].testReran(testCaseElement.getId(), testCaseElement.getClassName(), testCaseElement.getTestMethodName(), status.getOldCode(), trace);
                        ++i;
                    }
                }

                public boolean acceptsSwapToDisk() {
                    return true;
                }
            };
            this.fActiveTestRunSession.addTestSessionListener(this.fTestSessionListener);
        }

        public void sessionRemoved(TestRunSession testRunSession) {
            if (this.fActiveTestRunSession == testRunSession) {
                this.fActiveTestRunSession.removeTestSessionListener(this.fTestSessionListener);
                this.fTestSessionListener = null;
                this.fActiveTestRunSession = null;
            }
        }

        static /* synthetic */ TestRunSession access$0(LegacyTestRunSessionListener legacyTestRunSessionListener) {
            return legacyTestRunSessionListener.fActiveTestRunSession;
        }
    }
}

