/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example.protocolgateway;

import io.smallrye.config.ConfigMapping;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.util.Optional;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.ServerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class TcpServer {
    private static final Logger LOG = LoggerFactory.getLogger(TcpServer.class);
    private final Vertx vertx;
    private final ServerConfig config;
    private NetServer server;
    private Handler<NetSocket> connectHandler;

    @Inject
    public TcpServer(Vertx vertx, @ConfigMapping(prefix="gateway.tcp") ServerOptions serverOptions) {
        this.vertx = vertx;
        this.config = new ServerConfig(serverOptions);
    }

    public void setConnectHandler(Handler<NetSocket> handler) {
        this.connectHandler = handler;
    }

    public Future<NetServer> start() {
        if (this.connectHandler == null) {
            LOG.warn("no connect handler set, server will reject all connections");
            this.connectHandler = socket -> socket.close();
        }
        Promise result = Promise.promise();
        this.vertx.createNetServer().connectHandler(this.connectHandler).exceptionHandler(this::handleHandshakeException).listen(this.config.getInsecurePort(6666), this.config.getInsecurePortBindAddress(), (Handler)result);
        return result.future().map(s -> {
            this.server = s;
            LOG.info("successfully started TCP server [address: {}, port: {}]", (Object)this.config.getInsecurePortBindAddress(), (Object)s.actualPort());
            return s;
        }).recover(t -> {
            LOG.error("failed to start TCP server [address: {}, port: {}]", new Object[]{this.config.getInsecurePortBindAddress(), this.config.getInsecurePort(6666), t});
            return Future.failedFuture((Throwable)t);
        });
    }

    private void handleHandshakeException(Throwable cause) {
        LOG.error("cannot establish connection with client", cause);
    }

    public Future<Void> stop() {
        Promise result = Promise.promise();
        Optional.ofNullable(this.server).ifPresentOrElse(s -> s.close((Handler)result), () -> result.complete());
        return result.future();
    }
}

