/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.pubsub;

import com.google.pubsub.v1.PubsubMessage;
import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommand;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommandContext;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommandResponseSender;
import org.eclipse.hono.client.command.pubsub.PubSubBasedInternalCommandSender;
import org.eclipse.hono.client.pubsub.tracing.PubSubTracingHelper;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.commandrouter.CommandRouterMetrics;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;
import org.eclipse.hono.commandrouter.impl.CommandProcessingQueue;
import org.eclipse.hono.util.MessagingType;

public class PubSubBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler<PubSubBasedCommandContext> {
    private final PubSubBasedCommandResponseSender pubSubBasedCommandResponseSender;

    public PubSubBasedMappingAndDelegatingCommandHandler(Vertx vertx, TenantClient tenantClient, CommandProcessingQueue<PubSubBasedCommandContext> commandQueue, CommandTargetMapper commandTargetMapper, PubSubBasedInternalCommandSender internalCommandSender, CommandRouterMetrics metrics, Tracer tracer, PubSubBasedCommandResponseSender pubSubBasedCommandResponseSender) {
        super(vertx, tenantClient, commandQueue, commandTargetMapper, (InternalCommandSender)internalCommandSender, metrics, tracer);
        this.pubSubBasedCommandResponseSender = Objects.requireNonNull(pubSubBasedCommandResponseSender);
    }

    @Override
    protected MessagingType getMessagingType() {
        return MessagingType.pubsub;
    }

    @Override
    public Future<Void> start() {
        return Future.all(super.start(), (Future)this.pubSubBasedCommandResponseSender.start()).mapEmpty();
    }

    @Override
    public Future<Void> stop() {
        return Future.join(super.stop(), (Future)this.pubSubBasedCommandResponseSender.stop()).mapEmpty();
    }

    public Future<Void> mapAndDelegateIncomingCommandMessage(PubsubMessage pubsubMessage, String tenantId) {
        PubSubBasedCommand command;
        Objects.requireNonNull(pubsubMessage);
        Objects.requireNonNull(tenantId);
        Timer.Sample timer = this.getMetrics().startTimer();
        try {
            command = PubSubBasedCommand.from((PubsubMessage)pubsubMessage, (String)tenantId);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Pub/Sub command message is invalid", (Throwable)e);
            return Future.failedFuture((String)"Pub/Sub command message is invalid");
        }
        SpanContext spanContext = PubSubTracingHelper.extractSpanContext((Tracer)this.tracer, (PubsubMessage)pubsubMessage);
        Span currentSpan = this.createSpan(command.getTenant(), command.getDeviceId(), spanContext);
        command.logToSpan(currentSpan);
        PubSubBasedCommandContext commandContext = new PubSubBasedCommandContext(command, (CommandResponseSender)this.pubSubBasedCommandResponseSender, currentSpan);
        if (!command.isValid()) {
            this.log.debug("received invalid Pub/Sub command message [{}]", (Object)command);
            return this.tenantClient.get(command.getTenant(), currentSpan.context()).compose(tenantConfig -> {
                commandContext.put("tenant-config", tenantConfig);
                return Future.failedFuture((String)"command is invalid");
            }).onComplete(ar -> {
                commandContext.reject("malformed command message");
                this.reportInvalidCommand((CommandContext)commandContext, timer);
            }).mapEmpty();
        }
        this.log.info("received valid command record [{}]", (Object)command);
        return this.mapAndDelegateIncomingCommand(commandContext, timer);
    }
}

