/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.amqp;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonDelivery;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.command.amqp.ProtonBasedCommand;
import org.eclipse.hono.client.command.amqp.ProtonBasedCommandContext;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.commandrouter.CommandRouterMetrics;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;
import org.eclipse.hono.commandrouter.impl.amqp.ProtonBasedCommandProcessingQueue;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public class ProtonBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler<ProtonBasedCommandContext> {
    public ProtonBasedMappingAndDelegatingCommandHandler(Vertx vertx, TenantClient tenantClient, ProtonBasedCommandProcessingQueue commandQueue, InternalCommandSender internalCommandSender, CommandTargetMapper commandTargetMapper, CommandRouterMetrics metrics, Tracer tracer) {
        super(vertx, tenantClient, commandQueue, commandTargetMapper, internalCommandSender, metrics, tracer);
    }

    @Override
    protected final MessagingType getMessagingType() {
        return MessagingType.amqp;
    }

    public Future<Void> mapAndDelegateIncomingCommandMessage(String tenantId, ProtonDelivery messageDelivery, Message message) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(messageDelivery);
        Objects.requireNonNull(message);
        Timer.Sample timer = this.getMetrics().startTimer();
        if (!ResourceIdentifier.isValid((String)message.getAddress())) {
            this.log.debug("command message has no valid address");
            Rejected rejected = new Rejected();
            rejected.setError(new ErrorCondition(AmqpUtils.AMQP_BAD_REQUEST, "missing or invalid command target address"));
            messageDelivery.disposition((DeliveryState)rejected, true);
            return Future.failedFuture((String)"command message address is invalid");
        }
        ResourceIdentifier targetAddress = ResourceIdentifier.fromString((String)message.getAddress());
        String deviceId = targetAddress.getResourceId();
        if (!tenantId.equals(targetAddress.getTenantId())) {
            this.log.debug("command message address contains invalid tenant [expected: {}, found: {}]", (Object)tenantId, (Object)targetAddress.getTenantId());
            Rejected rejected = new Rejected();
            rejected.setError(new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, "unauthorized to send command to tenant"));
            messageDelivery.disposition((DeliveryState)rejected, true);
            return Future.failedFuture((String)"command message address contains invalid tenant");
        }
        if (Strings.isNullOrEmpty((Object)deviceId)) {
            this.log.debug("invalid command message address: {}", (Object)message.getAddress());
            Rejected rejected = new Rejected();
            rejected.setError(new ErrorCondition(AmqpUtils.AMQP_BAD_REQUEST, "invalid command target address"));
            messageDelivery.disposition((DeliveryState)rejected, true);
            return Future.failedFuture((String)"command message address is invalid");
        }
        ProtonBasedCommand command = ProtonBasedCommand.from((Message)message);
        SpanContext spanContext = AmqpUtils.extractSpanContext((Tracer)this.tracer, (Message)message);
        Span currentSpan = this.createSpan(tenantId, deviceId, spanContext);
        command.logToSpan(currentSpan);
        ProtonBasedCommandContext commandContext = new ProtonBasedCommandContext(command, messageDelivery, currentSpan);
        if (!command.isValid()) {
            this.log.debug("received invalid command message: {}", (Object)command);
            commandContext.reject("malformed command message");
            this.reportInvalidCommand((CommandContext)commandContext, timer);
            return Future.failedFuture((String)"command message is invalid");
        }
        this.log.trace("received valid command message: {}", (Object)command);
        return this.mapAndDelegateIncomingCommand(commandContext, timer);
    }
}

