/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.commandrouter.CommandRouterResult;
import org.eclipse.hono.commandrouter.CommandRouterService;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractDelegatingRequestResponseEndpoint;
import org.eclipse.hono.service.amqp.AbstractRequestResponseEndpoint;
import org.eclipse.hono.service.amqp.GenericRequestMessageFilter;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CommandRouterConstants;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;

public class DelegatingCommandRouterAmqpEndpoint<S extends CommandRouterService>
extends AbstractDelegatingRequestResponseEndpoint<S, ServiceConfigProperties> {
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_REGISTER_COMMAND_CONSUMER = "register command consumer";
    private static final String SPAN_NAME_UNREGISTER_COMMAND_CONSUMER = "unregister command consumer";
    private static final String SPAN_NAME_ENABLE_COMMAND_ROUTING = "enable command routing";

    public DelegatingCommandRouterAmqpEndpoint(Vertx vertx, S service) {
        super(vertx, service);
    }

    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Objects.requireNonNull(requestMessage);
        Objects.requireNonNull(targetAddress);
        switch (CommandRouterConstants.CommandRouterAction.from((String)requestMessage.getSubject())) {
            case SET_LAST_KNOWN_GATEWAY: {
                return this.processSetLastKnownGatewayRequest(requestMessage, targetAddress, spanContext);
            }
            case REGISTER_COMMAND_CONSUMER: {
                return this.processRegisterCommandConsumer(requestMessage, targetAddress, spanContext);
            }
            case UNREGISTER_COMMAND_CONSUMER: {
                return this.processUnregisterCommandConsumer(requestMessage, targetAddress, spanContext);
            }
            case ENABLE_COMMAND_ROUTING: {
                return this.processEnableCommandRouting(requestMessage, targetAddress, spanContext);
            }
        }
        return this.processCustomOperationMessage(requestMessage, spanContext);
    }

    protected Future<Message> processSetLastKnownGatewayRequest(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future<CommandRouterResult> resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceIdAppProperty = AmqpUtils.getDeviceId((Message)request);
        String gatewayIdAppProperty = AmqpUtils.getGatewayId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_SET_LAST_GATEWAY, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant"));
        } else if (deviceIdAppProperty != null && gatewayIdAppProperty != null) {
            this.logger.debug("setting last known gateway for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceIdAppProperty, gatewayIdAppProperty});
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceIdAppProperty);
            TracingHelper.TAG_GATEWAY_ID.set(span, gatewayIdAppProperty);
            if (AmqpUtils.getPayloadSize((Message)request) != 0) {
                this.logger.debug("ignoring payload in last known gateway request containing device/gateway properties");
            }
            resultFuture = ((CommandRouterService)this.getService()).setLastKnownGatewayForDevice(tenantId, deviceIdAppProperty, gatewayIdAppProperty, span);
        } else if (AmqpUtils.getPayloadSize((Message)request) != 0) {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            Buffer payload = AmqpUtils.getPayload((Message)request);
            resultFuture = this.parseSetLastKnownGatewayJson(payload).compose(deviceToGatewayMap -> {
                this.logger.debug("setting {} last known gateway entries for tenant [{}]", (Object)deviceToGatewayMap.size(), (Object)tenantId);
                span.log(Map.of("no_of_entries", deviceToGatewayMap.size()));
                return ((CommandRouterService)this.getService()).setLastKnownGatewayForDevice(tenantId, (Map<String, String>)deviceToGatewayMap, span);
            });
        } else {
            String error = "either device_id and gateway_id application properties or alternatively a JSON payload must be set";
            TracingHelper.logError((Span)span, (String)"either device_id and gateway_id application properties or alternatively a JSON payload must be set");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400, "either device_id and gateway_id application properties or alternatively a JSON payload must be set"));
        }
        return this.finishSpanOnFutureCompletion(span, resultFuture.map(res -> AbstractRequestResponseEndpoint.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res)));
    }

    private Future<Map<String, String>> parseSetLastKnownGatewayJson(Buffer payload) {
        Promise result = Promise.promise();
        try {
            HashMap resultMap = new HashMap();
            JsonObject jsonObject = payload.toJsonObject();
            jsonObject.forEach(entry -> {
                if (entry.getValue() instanceof String) {
                    resultMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            });
            result.complete(resultMap);
        }
        catch (DecodeException e) {
            result.fail((Throwable)new ClientErrorException(400, "payload must contain a JSON object if device_id and gateway_id application properties are not set"));
        }
        return result.future();
    }

    protected Future<Message> processRegisterCommandConsumer(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = AmqpUtils.getDeviceId((Message)request);
        String adapterInstanceId = (String)AmqpUtils.getApplicationProperty((Message)request, (String)"adapter_instance_id", String.class);
        Integer lifespanSecondsOrNull = (Integer)AmqpUtils.getApplicationProperty((Message)request, (String)"lifespan", Integer.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_REGISTER_COMMAND_CONSUMER, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        Boolean sendEvent = DelegatingCommandRouterAmqpEndpoint.getSendEvent(request);
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Duration lifespan = lifespanSecondsOrNull != null ? Duration.ofSeconds(lifespanSecondsOrNull.intValue()) : Duration.ofSeconds(-1L);
            TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
            TracingHelper.TAG_ADAPTER_INSTANCE_ID.set(span, adapterInstanceId);
            span.setTag("lifespan", (Number)lifespan.getSeconds());
            this.logger.debug("register command consumer [tenant-id: {}, device-id: {}, adapter-instance-id {}, lifespan: {}s]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespan.getSeconds()});
            resultFuture = ((CommandRouterService)this.getService()).registerCommandConsumer(tenantId, deviceId, sendEvent, adapterInstanceId, lifespan, span).map(res -> AbstractRequestResponseEndpoint.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, resultFuture);
    }

    protected Future<Message> processUnregisterCommandConsumer(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = AmqpUtils.getDeviceId((Message)request);
        String adapterInstanceId = (String)AmqpUtils.getApplicationProperty((Message)request, (String)"adapter_instance_id", String.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_UNREGISTER_COMMAND_CONSUMER, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        Boolean sendEvent = DelegatingCommandRouterAmqpEndpoint.getSendEvent(request);
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
            TracingHelper.TAG_ADAPTER_INSTANCE_ID.set(span, adapterInstanceId);
            this.logger.debug("unregister command consumer [tenant-id: {}, device-id: {}, adapter-instance-id {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
            resultFuture = ((CommandRouterService)this.getService()).unregisterCommandConsumer(tenantId, deviceId, sendEvent, adapterInstanceId, span).map(res -> AbstractRequestResponseEndpoint.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, resultFuture);
    }

    protected Future<Message> processEnableCommandRouting(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_ENABLE_COMMAND_ROUTING, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        Future response = this.parseTenantIdentifiers(request).compose(tenantIds -> {
            span.log(Map.of("no_of_tenants", tenantIds.size()));
            return ((CommandRouterService)this.getService()).enableCommandRouting((List<String>)tenantIds, span);
        }).map(result -> AbstractRequestResponseEndpoint.getAmqpReply((String)targetAddress.getEndpoint(), null, (Message)request, (RequestResponseResult)result));
        return this.finishSpanOnFutureCompletion(span, response);
    }

    private Future<List<String>> parseTenantIdentifiers(Message request) {
        Buffer payload = AmqpUtils.getPayload((Message)request);
        if (payload == null) {
            return Future.succeededFuture(List.of());
        }
        Promise result = Promise.promise();
        try {
            JsonArray array = payload.toJsonArray();
            List tenantIds = array.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
            result.complete(tenantIds);
        }
        catch (DecodeException e) {
            result.fail((Throwable)new ClientErrorException(400, "payload must contain JSON array of tenant identifiers"));
        }
        return result.future();
    }

    protected Future<Message> processCustomOperationMessage(Message request, SpanContext spanContext) {
        this.logger.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return GenericRequestMessageFilter.isValidRequestMessage((Message)msg);
    }

    public final String getName() {
        return "cmd_router";
    }

    private static Boolean getSendEvent(Message request) {
        return Optional.ofNullable((Boolean)AmqpUtils.getApplicationProperty((Message)request, (String)"send_event", Boolean.class)).orElse(false);
    }
}

