/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.NoConsumerException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.registry.DeviceDisabledOrNotRegisteredException;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.client.registry.TenantDisabledOrNotRegisteredException;
import org.eclipse.hono.commandrouter.CommandRouterMetrics;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.CommandProcessingQueue;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.tracing.TenantTraceSamplingHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Futures;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingAndDelegatingCommandHandler<T extends CommandContext>
implements Lifecycle {
    private static final Duration PROCESSING_TIMEOUT = Duration.ofSeconds(8L);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final TenantClient tenantClient;
    protected final Tracer tracer;
    private final Vertx vertx;
    private final CommandTargetMapper commandTargetMapper;
    private final InternalCommandSender internalCommandSender;
    private final CommandRouterMetrics metrics;
    private final CommandProcessingQueue<T> commandQueue;

    public AbstractMappingAndDelegatingCommandHandler(Vertx vertx, TenantClient tenantClient, CommandProcessingQueue<T> commandQueue, CommandTargetMapper commandTargetMapper, InternalCommandSender internalCommandSender, CommandRouterMetrics metrics, Tracer tracer) {
        this.vertx = Objects.requireNonNull(vertx);
        this.tenantClient = Objects.requireNonNull(tenantClient);
        this.commandQueue = Objects.requireNonNull(commandQueue);
        this.commandTargetMapper = Objects.requireNonNull(commandTargetMapper);
        this.internalCommandSender = Objects.requireNonNull(internalCommandSender);
        this.metrics = Objects.requireNonNull(metrics);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public Future<Void> start() {
        return this.internalCommandSender.start();
    }

    public Future<Void> stop() {
        this.commandQueue.clear();
        return this.internalCommandSender.stop();
    }

    protected abstract MessagingType getMessagingType();

    protected final CommandRouterMetrics getMetrics() {
        return this.metrics;
    }

    protected Future<Void> mapAndDelegateIncomingCommand(T commandContext, Timer.Sample timer) {
        Objects.requireNonNull(commandContext);
        Objects.requireNonNull(timer);
        this.commandQueue.add(commandContext);
        Promise resultPromise = Promise.promise();
        long timerId = this.vertx.setTimer(PROCESSING_TIMEOUT.toMillis(), tid -> {
            if (this.commandQueue.remove((CommandContext)commandContext) || !commandContext.isCompleted()) {
                this.log.info("command processing timed out after {}s [{}]", (Object)PROCESSING_TIMEOUT.toSeconds(), (Object)commandContext.getCommand());
                TracingHelper.logError((Span)commandContext.getTracingSpan(), (String)String.format("command processing timed out after %ds", PROCESSING_TIMEOUT.toSeconds()));
                ServerErrorException error = new ServerErrorException(503, "command processing timed out");
                commandContext.release((Throwable)error);
                resultPromise.tryFail((Throwable)error);
            }
        });
        this.mapAndDelegateIncomingCommandInternal(commandContext, timer).onComplete(ar -> {
            this.vertx.cancelTimer(timerId);
            if (ar.failed()) {
                this.commandQueue.remove((CommandContext)commandContext);
            }
            Futures.tryHandleResult((Promise)resultPromise, (AsyncResult)ar);
        });
        return resultPromise.future();
    }

    private Future<Void> mapAndDelegateIncomingCommandInternal(T commandContext, Timer.Sample timer) {
        Command command = commandContext.getCommand();
        if (this.log.isTraceEnabled()) {
            this.log.trace("determine command target gateway/adapter for [{}]", (Object)command);
        }
        Future tenantObjectFuture = this.tenantClient.get(command.getTenant(), commandContext.getTracingContext());
        return tenantObjectFuture.compose(tenantObject -> {
            TenantTraceSamplingHelper.applyTraceSamplingPriority((TenantObject)tenantObject, null, (Span)commandContext.getTracingSpan());
            commandContext.put("tenant-config", tenantObject);
            MessagingType tenantMessagingType = Optional.ofNullable((JsonObject)tenantObject.getProperty("ext", JsonObject.class)).map(ext -> ext.getString("messaging-type")).map(MessagingType::valueOf).orElse(null);
            if (tenantMessagingType != null && this.getMessagingType() != tenantMessagingType) {
                this.log.info("command received via {} but tenant is configured to use {} [{}]", new Object[]{this.getMessagingType(), tenantMessagingType, commandContext.getCommand()});
                commandContext.getTracingSpan().log(String.format("command received via %s but tenant is configured to use %s", this.getMessagingType(), tenantMessagingType));
            }
            return this.commandTargetMapper.getTargetGatewayAndAdapterInstance(command.getTenant(), command.getDeviceId(), commandContext.getTracingContext());
        }).recover(cause -> {
            Throwable error;
            if (tenantObjectFuture.failed() && ServiceInvocationException.extractStatusCode((Throwable)cause) == 404) {
                error = new TenantDisabledOrNotRegisteredException(command.getTenant(), 404);
            } else if (cause instanceof DeviceDisabledOrNotRegisteredException) {
                error = cause;
            } else if (ServiceInvocationException.extractStatusCode((Throwable)cause) == 404) {
                this.log.debug("no target adapter instance found for command with device id " + command.getDeviceId(), cause);
                error = new NoConsumerException("no target adapter instance found");
            } else {
                this.log.debug("error getting target gateway and adapter instance for command with device id " + command.getDeviceId(), cause);
                error = new ServerErrorException(503, "error getting target gateway and adapter instance", cause);
            }
            if (error instanceof ClientErrorException) {
                commandContext.reject(error);
            } else {
                commandContext.release(error);
            }
            this.reportCommandProcessingError(command, (TenantObject)tenantObjectFuture.result(), error, timer);
            return Future.failedFuture((Throwable)cause);
        }).compose(result -> {
            String targetGatewayId;
            String targetAdapterInstanceId = result.getString("adapter-instance-id");
            String targetDeviceId = result.getString("device-id");
            String string = targetGatewayId = targetDeviceId.equals(command.getDeviceId()) ? null : targetDeviceId;
            if (Objects.isNull(targetGatewayId)) {
                this.log.trace("determined target adapter instance [{}] for [{}] (command not mapped to gateway)", (Object)targetAdapterInstanceId, (Object)command);
            } else {
                command.setGatewayId(targetGatewayId);
                this.log.trace("determined target gateway [{}] and adapter instance [{}] for [{}]", new Object[]{targetGatewayId, targetAdapterInstanceId, command});
                commandContext.getTracingSpan().log("determined target gateway [" + targetGatewayId + "]");
            }
            return this.commandQueue.applySendCommandAction((CommandContext)commandContext, () -> this.sendCommandInternal(commandContext, targetAdapterInstanceId, (TenantObject)tenantObjectFuture.result(), timer));
        });
    }

    private Future<Void> sendCommandInternal(T commandContext, String targetAdapterInstanceId, TenantObject tenantObject, Timer.Sample timer) {
        return this.internalCommandSender.sendCommand(commandContext, targetAdapterInstanceId).onFailure(thr -> this.reportCommandProcessingError(commandContext.getCommand(), tenantObject, (Throwable)thr, timer));
    }

    protected void reportCommandProcessingError(Command command, TenantObject tenantObject, Throwable processingException, Timer.Sample timer) {
        this.metrics.reportCommand(command.isOneWay() ? MetricsTags.Direction.ONE_WAY : MetricsTags.Direction.REQUEST, command.getTenant(), tenantObject, MetricsTags.ProcessingOutcome.from((Throwable)processingException), command.getPayloadSize(), timer);
    }

    protected void reportInvalidCommand(CommandContext commandContext, Timer.Sample timer) {
        Command command = commandContext.getCommand();
        Future tenantObjectFuture = this.tenantClient.get(command.getTenant(), commandContext.getTracingContext());
        tenantObjectFuture.recover(thr -> Future.succeededFuture(null)).onSuccess(tenantObjectOrNull -> this.metrics.reportCommand(command.isOneWay() ? MetricsTags.Direction.ONE_WAY : MetricsTags.Direction.REQUEST, command.getTenant(), (TenantObject)tenantObjectOrNull, MetricsTags.ProcessingOutcome.UNPROCESSABLE, command.getPayloadSize(), timer));
    }

    protected final Span createSpan(String tenantId, String deviceId, SpanContext spanContext) {
        String operationName = "map and delegate command";
        Tracer.SpanBuilder spanBuilder = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"map and delegate command", (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "consumer").withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)deviceId);
        return spanBuilder.start();
    }
}

