/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.pubsub;

import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommand;
import org.eclipse.hono.client.command.pubsub.PubSubBasedCommandContext;
import org.eclipse.hono.commandrouter.impl.AbstractCommandProcessingQueue;

public class PubSubBasedCommandProcessingQueue
extends AbstractCommandProcessingQueue<PubSubBasedCommandContext, TenantAndDeviceHashQueueKey> {
    private static final int NUM_QUEUES_PER_TENANT = 8;

    public PubSubBasedCommandProcessingQueue(Vertx vertx) {
        super(vertx);
    }

    @Override
    protected TenantAndDeviceHashQueueKey getQueueKey(PubSubBasedCommandContext commandContext) {
        PubSubBasedCommand command = (PubSubBasedCommand)commandContext.getCommand();
        return new TenantAndDeviceHashQueueKey(command.getTenant(), command.getDeviceId());
    }

    @Override
    protected String getCommandSourceForLog(TenantAndDeviceHashQueueKey queueKey) {
        return "address for tenant [" + queueKey.getTenantId() + "]";
    }

    static final class TenantAndDeviceHashQueueKey {
        final String tenantId;
        final int queueIndex;

        TenantAndDeviceHashQueueKey(String tenantId, String deviceId) {
            this.tenantId = Objects.requireNonNull(tenantId);
            Objects.requireNonNull(deviceId);
            this.queueIndex = deviceId.hashCode() % 8;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!this.getClass().isInstance(o)) {
                return false;
            }
            TenantAndDeviceHashQueueKey that = (TenantAndDeviceHashQueueKey)o;
            return this.queueIndex == that.queueIndex && this.tenantId.equals(that.tenantId);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.queueIndex);
        }
    }
}

