/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.kafka;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.Objects;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommand;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommandContext;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommandResponseSender;
import org.eclipse.hono.client.command.kafka.KafkaBasedInternalCommandSender;
import org.eclipse.hono.client.kafka.tracing.KafkaTracingHelper;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.commandrouter.CommandRouterMetrics;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;
import org.eclipse.hono.commandrouter.impl.kafka.KafkaCommandProcessingQueue;
import org.eclipse.hono.util.MessagingType;

public class KafkaBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler<KafkaBasedCommandContext> {
    private final KafkaBasedCommandResponseSender kafkaBasedCommandResponseSender;

    public KafkaBasedMappingAndDelegatingCommandHandler(Vertx vertx, TenantClient tenantClient, KafkaCommandProcessingQueue commandQueue, CommandTargetMapper commandTargetMapper, KafkaBasedInternalCommandSender internalCommandSender, KafkaBasedCommandResponseSender kafkaBasedCommandResponseSender, CommandRouterMetrics metrics, Tracer tracer) {
        super(vertx, tenantClient, commandQueue, commandTargetMapper, (InternalCommandSender)internalCommandSender, metrics, tracer);
        this.kafkaBasedCommandResponseSender = Objects.requireNonNull(kafkaBasedCommandResponseSender);
    }

    @Override
    protected final MessagingType getMessagingType() {
        return MessagingType.kafka;
    }

    @Override
    public Future<Void> start() {
        return Future.all(super.start(), (Future)this.kafkaBasedCommandResponseSender.start()).mapEmpty();
    }

    @Override
    public Future<Void> stop() {
        return Future.join(super.stop(), (Future)this.kafkaBasedCommandResponseSender.stop()).mapEmpty();
    }

    public Future<Void> mapAndDelegateIncomingCommandMessage(KafkaConsumerRecord<String, Buffer> consumerRecord) {
        KafkaBasedCommand command;
        Objects.requireNonNull(consumerRecord);
        Timer.Sample timer = this.getMetrics().startTimer();
        try {
            command = KafkaBasedCommand.from(consumerRecord);
        }
        catch (IllegalArgumentException exception) {
            this.log.debug("command record is invalid", (Throwable)exception);
            return Future.failedFuture((String)"command record is invalid");
        }
        SpanContext spanContext = KafkaTracingHelper.extractSpanContext((Tracer)this.tracer, consumerRecord);
        Span currentSpan = this.createSpan(command.getTenant(), command.getDeviceId(), spanContext);
        KafkaTracingHelper.setRecordTags((Span)currentSpan, consumerRecord);
        KafkaBasedCommandContext commandContext = new KafkaBasedCommandContext(command, (CommandResponseSender)this.kafkaBasedCommandResponseSender, currentSpan);
        command.logToSpan(currentSpan);
        if (!command.isValid()) {
            this.log.debug("received invalid command record [{}]", (Object)command);
            return this.tenantClient.get(command.getTenant(), currentSpan.context()).compose(tenantConfig -> {
                commandContext.put("tenant-config", tenantConfig);
                return Future.failedFuture((String)"command is invalid");
            }).onComplete(ar -> {
                commandContext.reject("malformed command message");
                this.reportInvalidCommand((CommandContext)commandContext, timer);
            }).mapEmpty();
        }
        this.log.trace("received valid command record [{}]", (Object)command);
        return this.mapAndDelegateIncomingCommand(commandContext, timer);
    }
}

