/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.amqp;

import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.client.command.amqp.ProtonBasedCommand;
import org.eclipse.hono.client.command.amqp.ProtonBasedCommandContext;
import org.eclipse.hono.commandrouter.impl.AbstractCommandProcessingQueue;

public class ProtonBasedCommandProcessingQueue
extends AbstractCommandProcessingQueue<ProtonBasedCommandContext, TenantAndDeviceHashQueueKey> {
    private static final int NUM_QUEUES_PER_TENANT = 8;

    public ProtonBasedCommandProcessingQueue(Vertx vertx) {
        super(vertx);
    }

    @Override
    protected TenantAndDeviceHashQueueKey getQueueKey(ProtonBasedCommandContext commandContext) {
        ProtonBasedCommand command = commandContext.getCommand();
        return new TenantAndDeviceHashQueueKey(command.getTenant(), command.getDeviceId());
    }

    @Override
    protected String getCommandSourceForLog(TenantAndDeviceHashQueueKey queueKey) {
        return "address for tenant [" + queueKey.getTenantId() + "]";
    }

    public void removeEntriesForTenant(String tenantId) {
        this.removeCommandQueueEntries(queueKey -> queueKey.getTenantId().equals(tenantId));
    }

    static final class TenantAndDeviceHashQueueKey {
        final String tenantId;
        final int queueIndex;

        TenantAndDeviceHashQueueKey(String tenantId, String deviceId) {
            this.tenantId = Objects.requireNonNull(tenantId);
            Objects.requireNonNull(deviceId);
            this.queueIndex = deviceId.hashCode() % 8;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!this.getClass().isInstance(o)) {
                return false;
            }
            TenantAndDeviceHashQueueKey that = (TenantAndDeviceHashQueueKey)o;
            return this.queueIndex == that.queueIndex && this.tenantId.equals(that.tenantId);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.queueIndex);
        }
    }
}

