/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl;

import io.opentracing.Span;
import io.vertx.core.Future;
import java.util.Objects;
import org.eclipse.hono.adapter.client.command.Command;
import org.eclipse.hono.adapter.client.command.CommandContext;
import org.eclipse.hono.adapter.client.command.InternalCommandSender;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.tracing.TenantTraceSamplingHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingAndDelegatingCommandHandler
implements Lifecycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TenantClient tenantClient;
    private final CommandTargetMapper commandTargetMapper;
    private final InternalCommandSender internalCommandSender;

    public AbstractMappingAndDelegatingCommandHandler(TenantClient tenantClient, CommandTargetMapper commandTargetMapper, InternalCommandSender internalCommandSender) {
        this.tenantClient = Objects.requireNonNull(tenantClient);
        this.commandTargetMapper = Objects.requireNonNull(commandTargetMapper);
        this.internalCommandSender = Objects.requireNonNull(internalCommandSender);
    }

    public Future<Void> start() {
        return this.internalCommandSender.start();
    }

    public Future<Void> stop() {
        return this.internalCommandSender.stop();
    }

    protected final Future<Void> mapAndDelegateIncomingCommand(CommandContext commandContext) {
        Command command = commandContext.getCommand();
        this.log.trace("determine command target gateway/adapter for [{}]", (Object)command);
        Future tenantObjectFuture = this.tenantClient.get(command.getTenant(), commandContext.getTracingContext());
        return tenantObjectFuture.map(tenantObject -> {
            TenantTraceSamplingHelper.applyTraceSamplingPriority((TenantObject)tenantObject, null, (Span)commandContext.getTracingSpan());
            return tenantObject;
        }).compose(tenantObject -> this.commandTargetMapper.getTargetGatewayAndAdapterInstance(command.getTenant(), command.getDeviceId(), commandContext.getTracingContext())).recover(cause -> {
            String errorMsg = tenantObjectFuture.failed() ? "error getting tenant information for tenant " + command.getTenant() : (ServiceInvocationException.extractStatusCode((Throwable)cause) == 404 ? "no target adapter instance found for command with device id " + command.getDeviceId() : "error getting target gateway and adapter instance for command with device id " + command.getDeviceId());
            this.log.debug(errorMsg, cause);
            TracingHelper.logError((Span)commandContext.getTracingSpan(), (String)errorMsg, (Throwable)cause);
            commandContext.release();
            return Future.failedFuture((Throwable)cause);
        }).compose(result -> {
            String targetGatewayId;
            String targetAdapterInstanceId = result.getString("adapter-instance-id");
            String targetDeviceId = result.getString("device-id");
            String string = targetGatewayId = targetDeviceId.equals(command.getDeviceId()) ? null : targetDeviceId;
            if (Objects.isNull(targetGatewayId)) {
                this.log.trace("determined target adapter instance [{}] for [{}] (command not mapped to gateway)", (Object)targetAdapterInstanceId, (Object)command);
            } else {
                command.setGatewayId(targetGatewayId);
                this.log.trace("determined target gateway [{}] and adapter instance [{}] for [{}]", new Object[]{targetGatewayId, targetAdapterInstanceId, command});
                commandContext.getTracingSpan().log("determined target gateway [" + targetGatewayId + "]");
            }
            return this.sendCommand(commandContext, targetAdapterInstanceId);
        });
    }

    protected Future<Void> sendCommand(CommandContext commandContext, String targetAdapterInstanceId) {
        return this.internalCommandSender.sendCommand(commandContext, targetAdapterInstanceId);
    }
}

