/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.proton.ProtonDelivery;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.adapter.client.command.CommandContext;
import org.eclipse.hono.adapter.client.command.InternalCommandSender;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedCommand;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedCommandContext;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedInternalCommandSender;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.impl.CommandConsumer;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.AbstractMappingAndDelegatingCommandHandler;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public class ProtonBasedMappingAndDelegatingCommandHandler
extends AbstractMappingAndDelegatingCommandHandler {
    private final Tracer tracer;

    public ProtonBasedMappingAndDelegatingCommandHandler(TenantClient tenantClient, HonoConnection connection, CommandTargetMapper commandTargetMapper) {
        super(tenantClient, commandTargetMapper, (InternalCommandSender)new ProtonBasedInternalCommandSender(connection));
        this.tracer = connection.getTracer();
    }

    public void mapAndDelegateIncomingCommandMessage(String tenantId, ProtonDelivery messageDelivery, Message message) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(messageDelivery);
        Objects.requireNonNull(message);
        if (!ResourceIdentifier.isValid((String)message.getAddress())) {
            this.log.debug("command message has no valid address");
            Rejected rejected = new Rejected();
            rejected.setError(new ErrorCondition(Constants.AMQP_BAD_REQUEST, "missing or invalid command target address"));
            messageDelivery.disposition((DeliveryState)rejected, true);
            return;
        }
        ResourceIdentifier targetAddress = ResourceIdentifier.fromString((String)message.getAddress());
        String deviceId = targetAddress.getResourceId();
        if (!tenantId.equals(targetAddress.getTenantId())) {
            this.log.debug("command message address contains invalid tenant [expected: {}, found: {}]", (Object)tenantId, (Object)targetAddress.getTenantId());
            Rejected rejected = new Rejected();
            rejected.setError(new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, "unauthorized to send command to tenant"));
            messageDelivery.disposition((DeliveryState)rejected, true);
            return;
        }
        if (Strings.isNullOrEmpty((Object)deviceId)) {
            this.log.debug("invalid command message address: {}", (Object)message.getAddress());
            Rejected rejected = new Rejected();
            rejected.setError(new ErrorCondition(Constants.AMQP_BAD_REQUEST, "invalid command target address"));
            messageDelivery.disposition((DeliveryState)rejected, true);
            return;
        }
        ProtonBasedCommand command = ProtonBasedCommand.from((Message)message);
        if (command.isValid()) {
            this.log.trace("received valid command message: {}", (Object)command);
        } else {
            this.log.debug("received invalid command message: {}", (Object)command);
        }
        SpanContext spanContext = TracingHelper.extractSpanContext((Tracer)this.tracer, (Message)message);
        Span currentSpan = CommandConsumer.createSpan((String)"map and delegate command", (String)tenantId, (String)deviceId, null, (Tracer)this.tracer, (SpanContext)spanContext);
        command.logToSpan(currentSpan);
        ProtonBasedCommandContext commandContext = new ProtonBasedCommandContext(command, messageDelivery, currentSpan);
        if (command.isValid()) {
            this.mapAndDelegateIncomingCommand((CommandContext)commandContext);
        } else {
            commandContext.reject("malformed command message");
        }
    }
}

