/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter;

import io.opentracing.Span;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;
import org.eclipse.hono.service.deviceconnection.DeviceConnectionService;
import org.eclipse.hono.util.DeviceConnectionResult;

public class CacheBasedDeviceConnectionService
extends AbstractVerticle
implements DeviceConnectionService {
    private final DeviceConnectionInfo connectionInfoCache;

    public CacheBasedDeviceConnectionService(DeviceConnectionInfo cache) {
        this.connectionInfoCache = Objects.requireNonNull(cache);
    }

    public Future<DeviceConnectionResult> setLastKnownGatewayForDevice(String tenantId, String deviceId, String gatewayId, Span span) {
        return this.connectionInfoCache.setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, span).map(ok -> DeviceConnectionResult.from((int)204));
    }

    public Future<DeviceConnectionResult> getLastKnownGatewayForDevice(String tenantId, String deviceId, Span span) {
        return this.connectionInfoCache.getLastKnownGatewayForDevice(tenantId, deviceId, span).map(json -> DeviceConnectionResult.from((int)200, (JsonObject)json)).otherwise(t -> DeviceConnectionResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }

    public Future<DeviceConnectionResult> setCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Duration lifespan, Span span) {
        return this.connectionInfoCache.setCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, lifespan, span).map(v -> DeviceConnectionResult.from((int)204)).otherwise(t -> DeviceConnectionResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }

    public Future<DeviceConnectionResult> removeCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Span span) {
        return this.connectionInfoCache.removeCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, span).map(v -> DeviceConnectionResult.from((int)204)).otherwise(t -> DeviceConnectionResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }

    public Future<DeviceConnectionResult> getCommandHandlingAdapterInstances(String tenantId, String deviceId, List<String> viaGateways, Span span) {
        return this.connectionInfoCache.getCommandHandlingAdapterInstances(tenantId, deviceId, new HashSet<String>(viaGateways), span).map(json -> DeviceConnectionResult.from((int)200, (JsonObject)json)).otherwise(t -> DeviceConnectionResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }
}

