/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.commandrouter.impl.kafka;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.common.impl.Helper;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.hono.client.command.kafka.KafkaBasedCommandResponseSender;
import org.eclipse.hono.client.command.kafka.KafkaBasedInternalCommandSender;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.consumer.AsyncHandlingAutoCommitKafkaConsumer;
import org.eclipse.hono.client.kafka.consumer.KafkaConsumerConfigProperties;
import org.eclipse.hono.client.kafka.metrics.KafkaClientMetricsSupport;
import org.eclipse.hono.client.kafka.producer.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.producer.KafkaProducerFactory;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.commandrouter.CommandConsumerFactory;
import org.eclipse.hono.commandrouter.CommandRouterMetrics;
import org.eclipse.hono.commandrouter.CommandTargetMapper;
import org.eclipse.hono.commandrouter.impl.kafka.KafkaBasedMappingAndDelegatingCommandHandler;
import org.eclipse.hono.commandrouter.impl.kafka.KafkaCommandProcessingQueue;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessagingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBasedCommandConsumerFactoryImpl
implements CommandConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBasedCommandConsumerFactoryImpl.class);
    private static final Pattern COMMANDS_TOPIC_PATTERN = Pattern.compile(Pattern.quote(HonoTopic.Type.COMMAND.prefix) + ".*");
    private static final String DEFAULT_GROUP_ID = "cmd-router-group";
    private final Vertx vertx;
    private final TenantClient tenantClient;
    private final CommandTargetMapper commandTargetMapper;
    private final KafkaConsumerConfigProperties kafkaConsumerConfig;
    private final Tracer tracer;
    private final CommandRouterMetrics metrics;
    private final KafkaBasedInternalCommandSender internalCommandSender;
    private final KafkaBasedCommandResponseSender kafkaBasedCommandResponseSender;
    private final KafkaClientMetricsSupport kafkaClientMetricsSupport;
    private String groupId = "cmd-router-group";
    private KafkaBasedMappingAndDelegatingCommandHandler commandHandler;
    private AsyncHandlingAutoCommitKafkaConsumer kafkaConsumer;

    public KafkaBasedCommandConsumerFactoryImpl(Vertx vertx, TenantClient tenantClient, CommandTargetMapper commandTargetMapper, KafkaProducerFactory<String, Buffer> kafkaProducerFactory, KafkaProducerConfigProperties kafkaProducerConfig, KafkaConsumerConfigProperties kafkaConsumerConfig, CommandRouterMetrics metrics, KafkaClientMetricsSupport kafkaClientMetricsSupport, Tracer tracer) {
        this.vertx = Objects.requireNonNull(vertx);
        this.tenantClient = Objects.requireNonNull(tenantClient);
        this.commandTargetMapper = Objects.requireNonNull(commandTargetMapper);
        Objects.requireNonNull(kafkaProducerFactory);
        Objects.requireNonNull(kafkaProducerConfig);
        this.kafkaConsumerConfig = Objects.requireNonNull(kafkaConsumerConfig);
        this.metrics = Objects.requireNonNull(metrics);
        this.kafkaClientMetricsSupport = Objects.requireNonNull(kafkaClientMetricsSupport);
        this.tracer = Objects.requireNonNull(tracer);
        this.internalCommandSender = new KafkaBasedInternalCommandSender(kafkaProducerFactory, kafkaProducerConfig, tracer);
        this.kafkaBasedCommandResponseSender = new KafkaBasedCommandResponseSender(kafkaProducerFactory, kafkaProducerConfig, tracer);
    }

    public void setGroupId(String groupId) {
        Objects.requireNonNull(groupId);
        if (this.kafkaConsumer != null) {
            throw new IllegalStateException("must be invoked before start()");
        }
        this.groupId = groupId;
    }

    public MessagingType getMessagingType() {
        return MessagingType.kafka;
    }

    public Future<Void> start() {
        Context context = Vertx.currentContext();
        if (context == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("factory must be started in a Vert.x context"));
        }
        KafkaCommandProcessingQueue commandQueue = new KafkaCommandProcessingQueue(context);
        this.commandHandler = new KafkaBasedMappingAndDelegatingCommandHandler(this.tenantClient, commandQueue, this.commandTargetMapper, this.internalCommandSender, this.kafkaBasedCommandResponseSender, this.metrics, this.tracer);
        Map consumerConfig = this.kafkaConsumerConfig.getConsumerConfig("consumer");
        consumerConfig.put("group.id", this.groupId);
        this.kafkaConsumer = new AsyncHandlingAutoCommitKafkaConsumer(this.vertx, COMMANDS_TOPIC_PATTERN, this.commandHandler::mapAndDelegateIncomingCommandMessage, consumerConfig);
        this.kafkaConsumer.setMetricsSupport(this.kafkaClientMetricsSupport);
        this.kafkaConsumer.setOnRebalanceDoneHandler(partitions -> commandQueue.setCurrentlyHandledPartitions(Helper.to((Set)partitions)));
        return CompositeFuture.all(this.commandHandler.start(), (Future)this.kafkaConsumer.start()).mapEmpty();
    }

    public Future<Void> stop() {
        return CompositeFuture.join((Future)this.kafkaConsumer.stop(), this.commandHandler.stop(), (Future)this.internalCommandSender.stop(), (Future)this.kafkaBasedCommandResponseSender.stop()).mapEmpty();
    }

    @Override
    public Future<Void> createCommandConsumer(String tenantId, SpanContext context) {
        String topic = new HonoTopic(HonoTopic.Type.COMMAND, tenantId).toString();
        if (this.kafkaConsumer.isAmongKnownSubscribedTopics(topic)) {
            LOG.debug("createCommandConsumer: topic is already subscribed [{}]", (Object)topic);
            return Future.succeededFuture();
        }
        LOG.debug("createCommandConsumer: topic not subscribed; check for its existence, triggering auto-creation if enabled [{}]", (Object)topic);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)context, (String)"wait for topic subscription update", (String)CommandConsumerFactory.class.getSimpleName()).start();
        TracingHelper.TAG_TENANT_ID.set(span, tenantId);
        Tags.MESSAGE_BUS_DESTINATION.set(span, topic);
        return this.kafkaConsumer.ensureTopicIsAmongSubscribedTopicPatternTopics(topic).onComplete(ar -> {
            if (ar.failed()) {
                TracingHelper.logError((Span)span, (Throwable)ar.cause());
            }
            span.finish();
        });
    }
}

