/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class SamplingPrioritySampler
implements Sampler {
    private static final String SAMPLING_PRIORITY_TAG = "sampling.priority";
    private final Sampler sampler;

    public SamplingPrioritySampler(Sampler sampler) {
        this.sampler = sampler;
    }

    public SamplingResult shouldSample(@Nonnull Context parentContext, @Nonnull String traceId, @Nonnull String name, @Nonnull SpanKind spanKind, @Nonnull Attributes attributes, @Nonnull List<LinkData> parentLinks) {
        return Optional.ofNullable((Long)attributes.get(AttributeKey.longKey((String)SAMPLING_PRIORITY_TAG))).map(samplingPriority -> {
            if (samplingPriority == 1L) {
                return SamplingResult.recordAndSample();
            }
            if (samplingPriority == 0L) {
                return SamplingResult.drop();
            }
            return null;
        }).orElseGet(() -> this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks));
    }

    public String getDescription() {
        return "SamplingPrioritySampler";
    }
}

