/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.RateLimiter;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import javax.annotation.Nonnull;

public class RateLimitingSampler
implements Sampler {
    private final double maxTracesPerSecond;
    private final RateLimiter rateLimiter;

    public RateLimitingSampler(int maxTracesPerSecond) {
        this.maxTracesPerSecond = maxTracesPerSecond;
        double maxBalance = (double)maxTracesPerSecond < 1.0 ? 1.0 : (double)maxTracesPerSecond;
        this.rateLimiter = new RateLimiter((double)maxTracesPerSecond, maxBalance, Clock.getDefault());
    }

    public SamplingResult shouldSample(@Nonnull Context parentContext, @Nonnull String traceId, @Nonnull String spanName, @Nonnull SpanKind spanKind, @Nonnull Attributes attributes, @Nonnull List<LinkData> parentLinks) {
        if (!this.rateLimiter.trySpend(1.0)) {
            return SamplingResult.drop();
        }
        return Sampler.alwaysOn().shouldSample(parentContext, traceId, spanName, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return String.format("RateLimitingSampler{%.2f}", this.maxTracesPerSecond);
    }
}

